/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.encoder;

final class BarcodeRow {
    private final byte[] row;
    private int currentLocation;

    BarcodeRow(int width) {
        this.row = new byte[width];
        this.currentLocation = 0;
    }

    void set(int x2, byte value) {
        this.row[x2] = value;
    }

    private void set(int x2, boolean black) {
        this.row[x2] = (byte)(black ? 1 : 0);
    }

    void addBar(boolean black, int width) {
        for (int ii = 0; ii < width; ++ii) {
            BarcodeRow barcodeRow = this;
            barcodeRow.set(barcodeRow.currentLocation++, black);
        }
    }

    byte[] getScaledRow(int scale) {
        byte[] output = new byte[this.row.length * scale];
        for (int i2 = 0; i2 < output.length; ++i2) {
            output[i2] = this.row[i2 / scale];
        }
        return output;
    }
}

