/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.encoder;

import com.google.zxing.pdf417.encoder.BarcodeRow;

public final class BarcodeMatrix {
    private final BarcodeRow[] matrix;
    private int currentRow;
    private final int height;
    private final int width;

    BarcodeMatrix(int height, int width) {
        this.matrix = new BarcodeRow[height];
        int matrixLength = this.matrix.length;
        for (int i2 = 0; i2 < matrixLength; ++i2) {
            this.matrix[i2] = new BarcodeRow((width + 4) * 17 + 1);
        }
        this.width = width * 17;
        this.height = height;
        this.currentRow = -1;
    }

    void set(int x2, int y2, byte value) {
        this.matrix[y2].set(x2, value);
    }

    void startRow() {
        ++this.currentRow;
    }

    BarcodeRow getCurrentRow() {
        return this.matrix[this.currentRow];
    }

    public byte[][] getMatrix() {
        return this.getScaledMatrix(1, 1);
    }

    public byte[][] getScaledMatrix(int xScale, int yScale) {
        byte[][] matrixOut = new byte[this.height * yScale][this.width * xScale];
        int yMax = this.height * yScale;
        for (int i2 = 0; i2 < yMax; ++i2) {
            matrixOut[yMax - i2 - 1] = this.matrix[i2 / yScale].getScaledRow(xScale);
        }
        return matrixOut;
    }
}

