/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder.ec;

import com.google.zxing.pdf417.decoder.ec.ModulusPoly;

public final class ModulusGF {
    public static final ModulusGF PDF417_GF = new ModulusGF(929, 3);
    private final int[] expTable;
    private final int[] logTable;
    private final ModulusPoly zero;
    private final ModulusPoly one;
    private final int modulus;

    private ModulusGF(int modulus, int generator) {
        int i2;
        this.modulus = modulus;
        this.expTable = new int[modulus];
        this.logTable = new int[modulus];
        int x2 = 1;
        for (i2 = 0; i2 < modulus; ++i2) {
            this.expTable[i2] = x2;
            x2 = x2 * generator % modulus;
        }
        for (i2 = 0; i2 < modulus - 1; ++i2) {
            this.logTable[this.expTable[i2]] = i2;
        }
        this.zero = new ModulusPoly(this, new int[]{0});
        this.one = new ModulusPoly(this, new int[]{1});
    }

    ModulusPoly getZero() {
        return this.zero;
    }

    ModulusPoly getOne() {
        return this.one;
    }

    ModulusPoly buildMonomial(int degree, int coefficient) {
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.zero;
        }
        int[] nArray = new int[degree + 1];
        int[] coefficients = nArray;
        nArray[0] = coefficient;
        return new ModulusPoly(this, coefficients);
    }

    int add(int a2, int b2) {
        return (a2 + b2) % this.modulus;
    }

    int subtract(int a2, int b2) {
        return (this.modulus + a2 - b2) % this.modulus;
    }

    int exp(int a2) {
        return this.expTable[a2];
    }

    int log(int a2) {
        if (a2 == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[a2];
    }

    int inverse(int a2) {
        if (a2 == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[this.modulus - this.logTable[a2] - 1];
    }

    int multiply(int a2, int b2) {
        if (a2 == 0 || b2 == 0) {
            return 0;
        }
        return this.expTable[(this.logTable[a2] + this.logTable[b2]) % (this.modulus - 1)];
    }

    int getSize() {
        return this.modulus;
    }
}

