/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Collection;
import java.util.Collections;

public final class ITFWriter
extends OneDimensionalCodeWriter {
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN = new int[]{3, 1, 1};
    private static final int W = 3;
    private static final int N = 1;
    private static final int[][] PATTERNS = new int[][]{{1, 1, 3, 3, 1}, {3, 1, 1, 1, 3}, {1, 3, 1, 1, 3}, {3, 3, 1, 1, 1}, {1, 1, 3, 1, 3}, {3, 1, 3, 1, 1}, {1, 3, 3, 1, 1}, {1, 1, 1, 3, 3}, {3, 1, 1, 3, 1}, {1, 3, 1, 3, 1}};

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.ITF);
    }

    @Override
    public boolean[] encode(String contents) {
        int length = contents.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("The length of the input should be even");
        }
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got ".concat(String.valueOf(length)));
        }
        ITFWriter.checkNumeric(contents);
        boolean[] result = new boolean[9 + length * 9];
        int pos = ITFWriter.appendPattern(result, 0, START_PATTERN, true);
        for (int i2 = 0; i2 < length; i2 += 2) {
            int one = Character.digit(contents.charAt(i2), 10);
            int two = Character.digit(contents.charAt(i2 + 1), 10);
            int[] encoding = new int[10];
            for (int j2 = 0; j2 < 5; ++j2) {
                encoding[2 * j2] = PATTERNS[one][j2];
                encoding[2 * j2 + 1] = PATTERNS[two][j2];
            }
            pos += ITFWriter.appendPattern(result, pos, encoding, true);
        }
        ITFWriter.appendPattern(result, pos, END_PATTERN, true);
        return result;
    }
}

