/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Map;

public final class ITFReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.38f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.5f;
    private static final int W = 3;
    private static final int w = 2;
    private static final int N = 1;
    private static final int[] DEFAULT_ALLOWED_LENGTHS = new int[]{6, 8, 10, 12, 14};
    private int narrowLineWidth = -1;
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[][] END_PATTERN_REVERSED = new int[][]{{1, 1, 2}, {1, 1, 3}};
    private static final int[][] PATTERNS = new int[][]{{1, 1, 2, 2, 1}, {2, 1, 1, 1, 2}, {1, 2, 1, 1, 2}, {2, 2, 1, 1, 1}, {1, 1, 2, 1, 2}, {2, 1, 2, 1, 1}, {1, 2, 2, 1, 1}, {1, 1, 1, 2, 2}, {2, 1, 1, 2, 1}, {1, 2, 1, 2, 1}, {1, 1, 3, 3, 1}, {3, 1, 1, 1, 3}, {1, 3, 1, 1, 3}, {3, 3, 1, 1, 1}, {1, 1, 3, 1, 3}, {3, 1, 3, 1, 1}, {1, 3, 3, 1, 1}, {1, 1, 1, 3, 3}, {3, 1, 1, 3, 1}, {1, 3, 1, 3, 1}};

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws FormatException, NotFoundException {
        int[] startRange = this.decodeStart(row);
        int[] endRange = this.decodeEnd(row);
        StringBuilder result = new StringBuilder(20);
        ITFReader.decodeMiddle(row, startRange[1], endRange[0], result);
        String resultString = result.toString();
        int[] allowedLengths = null;
        if (hints != null) {
            allowedLengths = (int[])hints.get((Object)DecodeHintType.ALLOWED_LENGTHS);
        }
        if (allowedLengths == null) {
            allowedLengths = DEFAULT_ALLOWED_LENGTHS;
        }
        int length = resultString.length();
        boolean lengthOK = false;
        int maxAllowedLength = 0;
        int[] nArray = allowedLengths;
        int n2 = allowedLengths.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int allowedLength = nArray[i2];
            if (length == allowedLength) {
                lengthOK = true;
                break;
            }
            if (allowedLength <= maxAllowedLength) continue;
            maxAllowedLength = allowedLength;
        }
        if (!lengthOK && length > maxAllowedLength) {
            lengthOK = true;
        }
        if (!lengthOK) {
            throw FormatException.getFormatInstance();
        }
        return new Result(resultString, null, new ResultPoint[]{new ResultPoint(startRange[1], rowNumber), new ResultPoint(endRange[0], rowNumber)}, BarcodeFormat.ITF);
    }

    private static void decodeMiddle(BitArray row, int payloadStart, int payloadEnd, StringBuilder resultString) throws NotFoundException {
        int[] counterDigitPair = new int[10];
        int[] counterBlack = new int[5];
        int[] counterWhite = new int[5];
        while (payloadStart < payloadEnd) {
            ITFReader.recordPattern(row, payloadStart, counterDigitPair);
            for (int k2 = 0; k2 < 5; ++k2) {
                int twoK = 2 * k2;
                counterBlack[k2] = counterDigitPair[twoK];
                counterWhite[k2] = counterDigitPair[twoK + 1];
            }
            int bestMatch = ITFReader.decodeDigit(counterBlack);
            resultString.append((char)(bestMatch + 48));
            bestMatch = ITFReader.decodeDigit(counterWhite);
            resultString.append((char)(bestMatch + 48));
            int[] nArray = counterDigitPair;
            for (int i2 = 0; i2 < 10; ++i2) {
                int counterDigit = nArray[i2];
                payloadStart += counterDigit;
            }
        }
    }

    private int[] decodeStart(BitArray row) throws NotFoundException {
        int endStart = ITFReader.skipWhiteSpace(row);
        int[] startPattern = ITFReader.findGuardPattern(row, endStart, START_PATTERN);
        this.narrowLineWidth = (startPattern[1] - startPattern[0]) / 4;
        this.validateQuietZone(row, startPattern[0]);
        return startPattern;
    }

    private void validateQuietZone(BitArray row, int startPattern) throws NotFoundException {
        int quietCount = Math.min(this.narrowLineWidth * 10, startPattern);
        for (int i2 = startPattern - 1; quietCount > 0 && i2 >= 0 && !row.get(i2); --quietCount, --i2) {
        }
        if (quietCount != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static int skipWhiteSpace(BitArray row) throws NotFoundException {
        int width = row.getSize();
        int endStart = row.getNextSet(0);
        if (endStart == width) {
            throw NotFoundException.getNotFoundInstance();
        }
        return endStart;
    }

    private int[] decodeEnd(BitArray row) throws NotFoundException {
        row.reverse();
        try {
            int[] endPattern;
            int endStart = ITFReader.skipWhiteSpace(row);
            try {
                endPattern = ITFReader.findGuardPattern(row, endStart, END_PATTERN_REVERSED[0]);
            }
            catch (NotFoundException notFoundException) {
                endPattern = ITFReader.findGuardPattern(row, endStart, END_PATTERN_REVERSED[1]);
            }
            this.validateQuietZone(row, endPattern[0]);
            int temp = endPattern[0];
            endPattern[0] = row.getSize() - endPattern[1];
            endPattern[1] = row.getSize() - temp;
            int[] nArray = endPattern;
            return nArray;
        }
        finally {
            row.reverse();
        }
    }

    private static int[] findGuardPattern(BitArray row, int rowOffset, int[] pattern) throws NotFoundException {
        int patternLength = pattern.length;
        int[] counters = new int[patternLength];
        int width = row.getSize();
        boolean isWhite = false;
        int counterPosition = 0;
        int patternStart = rowOffset;
        for (int x2 = rowOffset; x2 < width; ++x2) {
            if (row.get(x2) != isWhite) {
                int n2 = counterPosition;
                counters[n2] = counters[n2] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                if (ITFReader.patternMatchVariance(counters, pattern, 0.5f) < 0.38f) {
                    return new int[]{patternStart, x2};
                }
                patternStart += counters[0] + counters[1];
                System.arraycopy(counters, 2, counters, 0, counterPosition - 1);
                counters[counterPosition - 1] = 0;
                counters[counterPosition] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite = !isWhite;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeDigit(int[] counters) throws NotFoundException {
        float bestVariance = 0.38f;
        int bestMatch = -1;
        int max = PATTERNS.length;
        for (int i2 = 0; i2 < max; ++i2) {
            float f2;
            int[] pattern = PATTERNS[i2];
            float variance = ITFReader.patternMatchVariance(counters, pattern, 0.5f);
            if (f2 < bestVariance) {
                bestVariance = variance;
                bestMatch = i2;
                continue;
            }
            if (variance != bestVariance) continue;
            bestMatch = -1;
        }
        if (bestMatch >= 0) {
            return bestMatch % 10;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

