/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class EAN8Reader
extends UPCEANReader {
    private final int[] decodeMiddleCounters = new int[4];

    @Override
    protected int decodeMiddle(BitArray row, int[] startRange, StringBuilder result) throws NotFoundException {
        int n2;
        int[] counters = this.decodeMiddleCounters;
        this.decodeMiddleCounters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        for (int x2 = 0; x2 < 4 && rowOffset < end; ++x2) {
            int bestMatch = EAN8Reader.decodeDigit(row, counters, rowOffset, L_PATTERNS);
            result.append((char)(bestMatch + 48));
            int[] nArray = counters;
            int n3 = counters.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int counter = nArray[n2];
                rowOffset += counter;
            }
        }
        rowOffset = EAN8Reader.findGuardPattern(row, rowOffset, true, MIDDLE_PATTERN)[1];
        for (int x3 = 0; x3 < 4 && rowOffset < end; ++x3) {
            int bestMatch = EAN8Reader.decodeDigit(row, counters, rowOffset, L_PATTERNS);
            result.append((char)(bestMatch + 48));
            int[] nArray = counters;
            n2 = counters.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int counter = nArray[i2];
                rowOffset += counter;
            }
        }
        return rowOffset;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_8;
    }
}

