/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};
    private final int[] decodeMiddleCounters = new int[4];

    @Override
    protected int decodeMiddle(BitArray row, int[] startRange, StringBuilder resultString) throws NotFoundException {
        int n2;
        int[] counters = this.decodeMiddleCounters;
        this.decodeMiddleCounters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int lgPatternFound = 0;
        for (int x2 = 0; x2 < 6 && rowOffset < end; ++x2) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            int[] nArray = counters;
            int n3 = counters.length;
            for (n2 = 0; n2 < n3; ++n2) {
                int counter = nArray[n2];
                rowOffset += counter;
            }
            if (bestMatch < 10) continue;
            lgPatternFound |= 1 << 5 - x2;
        }
        EAN13Reader.determineFirstDigit(resultString, lgPatternFound);
        rowOffset = EAN13Reader.findGuardPattern(row, rowOffset, true, MIDDLE_PATTERN)[1];
        for (int x3 = 0; x3 < 6 && rowOffset < end; ++x3) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_PATTERNS);
            resultString.append((char)(bestMatch + 48));
            int[] nArray = counters;
            n2 = counters.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int counter = nArray[i2];
                rowOffset += counter;
            }
        }
        return rowOffset;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }

    private static void determineFirstDigit(StringBuilder resultString, int lgPatternFound) throws NotFoundException {
        for (int d2 = 0; d2 < 10; ++d2) {
            if (lgPatternFound != FIRST_DIGIT_ENCODINGS[d2]) continue;
            resultString.insert(0, (char)(d2 + 48));
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

