/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class CodaBarReader
extends OneDReader {
    private static final float MAX_ACCEPTABLE = 2.0f;
    private static final float PADDING = 1.5f;
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCD";
    static final char[] ALPHABET = "0123456789-$:/.+ABCD".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 69, 81, 84, 21, 26, 41, 11, 14};
    private static final int MIN_CHARACTER_LENGTH = 3;
    private static final char[] STARTEND_ENCODING = new char[]{'A', 'B', 'C', 'D'};
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private int[] counters = new int[80];
    private int counterLength = 0;

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws NotFoundException {
        int i2;
        int charOffset;
        int startOffset;
        Arrays.fill(this.counters, 0);
        this.setCounters(row);
        int nextStart = startOffset = this.findStartPattern();
        this.decodeRowResult.setLength(0);
        do {
            if ((charOffset = this.toNarrowWidePattern(nextStart)) == -1) {
                throw NotFoundException.getNotFoundInstance();
            }
            this.decodeRowResult.append((char)charOffset);
        } while ((this.decodeRowResult.length() <= 1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[charOffset])) && (nextStart += 8) < this.counterLength);
        int trailingWhitespace = this.counters[nextStart - 1];
        int lastPatternSize = 0;
        for (i2 = -8; i2 < -1; ++i2) {
            lastPatternSize += this.counters[nextStart + i2];
        }
        if (nextStart < this.counterLength && trailingWhitespace < lastPatternSize / 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.validatePattern(startOffset);
        for (i2 = 0; i2 < this.decodeRowResult.length(); ++i2) {
            this.decodeRowResult.setCharAt(i2, ALPHABET[this.decodeRowResult.charAt(i2)]);
        }
        char startchar = this.decodeRowResult.charAt(0);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, startchar)) {
            throw NotFoundException.getNotFoundInstance();
        }
        char endchar = this.decodeRowResult.charAt(this.decodeRowResult.length() - 1);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, endchar)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.decodeRowResult.length() <= 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (hints == null || !hints.containsKey((Object)DecodeHintType.RETURN_CODABAR_START_END)) {
            this.decodeRowResult.deleteCharAt(this.decodeRowResult.length() - 1);
            this.decodeRowResult.deleteCharAt(0);
        }
        int runningCount = 0;
        for (int i3 = 0; i3 < startOffset; ++i3) {
            runningCount += this.counters[i3];
        }
        float left = runningCount;
        for (int i4 = startOffset; i4 < nextStart - 1; ++i4) {
            runningCount += this.counters[i4];
        }
        float right = runningCount;
        return new Result(this.decodeRowResult.toString(), null, new ResultPoint[]{new ResultPoint(left, rowNumber), new ResultPoint(right, rowNumber)}, BarcodeFormat.CODABAR);
    }

    private void validatePattern(int start) throws NotFoundException {
        int i2;
        int[] sizes = new int[]{0, 0, 0, 0};
        int[] counts = new int[]{0, 0, 0, 0};
        int end = this.decodeRowResult.length() - 1;
        int pos = start;
        int i3 = 0;
        while (true) {
            int pattern = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(i3)];
            for (int j2 = 6; j2 >= 0; --j2) {
                int category;
                int n2 = category = (j2 & 1) + ((pattern & 1) << 1);
                sizes[n2] = sizes[n2] + this.counters[pos + j2];
                int n3 = category;
                counts[n3] = counts[n3] + 1;
                pattern >>= 1;
            }
            if (i3 >= end) break;
            pos += 8;
            ++i3;
        }
        float[] maxes = new float[4];
        float[] mins = new float[4];
        for (i2 = 0; i2 < 2; ++i2) {
            mins[i2] = 0.0f;
            mins[i2 + 2] = ((float)sizes[i2] / (float)counts[i2] + (float)sizes[i2 + 2] / (float)counts[i2 + 2]) / 2.0f;
            maxes[i2] = mins[i2 + 2];
            maxes[i2 + 2] = ((float)sizes[i2 + 2] * 2.0f + 1.5f) / (float)counts[i2 + 2];
        }
        pos = start;
        i2 = 0;
        while (true) {
            int pattern = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(i2)];
            for (int j3 = 6; j3 >= 0; --j3) {
                int size = this.counters[pos + j3];
                int category = (j3 & 1) + ((pattern & 1) << 1);
                if ((float)size < mins[category] || (float)size > maxes[category]) {
                    throw NotFoundException.getNotFoundInstance();
                }
                pattern >>= 1;
            }
            if (i2 >= end) break;
            pos += 8;
            ++i2;
        }
    }

    private void setCounters(BitArray row) throws NotFoundException {
        int end;
        this.counterLength = 0;
        int i2 = row.getNextUnset(0);
        if (i2 >= (end = row.getSize())) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean isWhite = true;
        int count = 0;
        while (i2 < end) {
            if (row.get(i2) != isWhite) {
                ++count;
            } else {
                this.counterAppend(count);
                count = 1;
                isWhite = !isWhite;
            }
            ++i2;
        }
        this.counterAppend(count);
    }

    private void counterAppend(int e2) {
        this.counters[this.counterLength] = e2;
        ++this.counterLength;
        if (this.counterLength >= this.counters.length) {
            int[] temp = new int[this.counterLength << 1];
            System.arraycopy(this.counters, 0, temp, 0, this.counterLength);
            this.counters = temp;
        }
    }

    private int findStartPattern() throws NotFoundException {
        for (int i2 = 1; i2 < this.counterLength; i2 += 2) {
            int charOffset = this.toNarrowWidePattern(i2);
            if (charOffset == -1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[charOffset])) continue;
            int patternSize = 0;
            for (int j2 = i2; j2 < i2 + 7; ++j2) {
                patternSize += this.counters[j2];
            }
            if (i2 != 1 && this.counters[i2 - 1] < patternSize / 2) continue;
            return i2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static boolean arrayContains(char[] array, char key) {
        if (array != null) {
            char[] cArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (cArray[i2] != key) continue;
                return true;
            }
        }
        return false;
    }

    private int toNarrowWidePattern(int position) {
        int i2;
        int end = position + 7;
        if (end >= this.counterLength) {
            return -1;
        }
        int[] theCounters = this.counters;
        int maxBar = 0;
        int minBar = Integer.MAX_VALUE;
        for (int j2 = position; j2 < end; j2 += 2) {
            int currentCounter = theCounters[j2];
            if (currentCounter < minBar) {
                minBar = currentCounter;
            }
            if (currentCounter <= maxBar) continue;
            maxBar = currentCounter;
        }
        int thresholdBar = (minBar + maxBar) / 2;
        int maxSpace = 0;
        int minSpace = Integer.MAX_VALUE;
        for (int j3 = position + 1; j3 < end; j3 += 2) {
            int currentCounter = theCounters[j3];
            if (currentCounter < minSpace) {
                minSpace = currentCounter;
            }
            if (currentCounter <= maxSpace) continue;
            maxSpace = currentCounter;
        }
        int thresholdSpace = (minSpace + maxSpace) / 2;
        int bitmask = 128;
        int pattern = 0;
        for (i2 = 0; i2 < 7; ++i2) {
            int threshold = (i2 & 1) == 0 ? thresholdBar : thresholdSpace;
            bitmask >>= 1;
            if (theCounters[position + i2] <= threshold) continue;
            pattern |= bitmask;
        }
        for (i2 = 0; i2 < CHARACTER_ENCODINGS.length; ++i2) {
            if (CHARACTER_ENCODINGS[i2] != pattern) continue;
            return i2;
        }
        return -1;
    }
}

