/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.datamatrix.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int numDataCodewords, byte[] codewords) {
        this.numDataCodewords = numDataCodewords;
        this.codewords = codewords;
    }

    static DataBlock[] getDataBlocks(byte[] rawCodewords, Version version) {
        int i2;
        Version.ECB[] ecBlockArray;
        Version.ECBlocks ecBlocks = version.getECBlocks();
        int totalBlocks = 0;
        Version.ECB[] eCBArray = ecBlockArray = ecBlocks.getECBlocks();
        int n2 = ecBlockArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            Version.ECB ecBlock = eCBArray[i3];
            totalBlocks += ecBlock.getCount();
        }
        DataBlock[] result = new DataBlock[totalBlocks];
        int numResultBlocks = 0;
        Version.ECB[] eCBArray2 = ecBlockArray;
        int ecBlock = ecBlockArray.length;
        for (int i4 = 0; i4 < ecBlock; ++i4) {
            Version.ECB ecBlock2 = eCBArray2[i4];
            for (i2 = 0; i2 < ecBlock2.getCount(); ++i2) {
                int numDataCodewords = ecBlock2.getDataCodewords();
                int numBlockCodewords = ecBlocks.getECCodewords() + numDataCodewords;
                result[numResultBlocks++] = new DataBlock(numDataCodewords, new byte[numBlockCodewords]);
            }
        }
        int longerBlocksNumDataCodewords = result[0].codewords.length - ecBlocks.getECCodewords();
        int shorterBlocksNumDataCodewords = longerBlocksNumDataCodewords - 1;
        int rawCodewordsOffset = 0;
        for (i2 = 0; i2 < shorterBlocksNumDataCodewords; ++i2) {
            for (int j2 = 0; j2 < numResultBlocks; ++j2) {
                result[j2].codewords[i2] = rawCodewords[rawCodewordsOffset++];
            }
        }
        boolean specialVersion = version.getVersionNumber() == 24;
        int numLongerBlocks = specialVersion ? 8 : numResultBlocks;
        for (int j3 = 0; j3 < numLongerBlocks; ++j3) {
            result[j3].codewords[longerBlocksNumDataCodewords - 1] = rawCodewords[rawCodewordsOffset++];
        }
        int max = result[0].codewords.length;
        for (int i5 = longerBlocksNumDataCodewords; i5 < max; ++i5) {
            for (int j4 = 0; j4 < numResultBlocks; ++j4) {
                int jOffset = specialVersion ? (j4 + 8) % numResultBlocks : j4;
                int iOffset = specialVersion && jOffset > 7 ? i5 - 1 : i5;
                result[jOffset].codewords[iOffset] = rawCodewords[rawCodewordsOffset++];
            }
        }
        if (rawCodewordsOffset != rawCodewords.length) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

