/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.detector.MathUtils;

public final class WhiteRectangleDetector {
    private static final int INIT_SIZE = 10;
    private static final int CORR = 1;
    private final BitMatrix image;
    private final int height;
    private final int width;
    private final int leftInit;
    private final int rightInit;
    private final int downInit;
    private final int upInit;

    public WhiteRectangleDetector(BitMatrix image) throws NotFoundException {
        this(image, 10, image.getWidth() / 2, image.getHeight() / 2);
    }

    public WhiteRectangleDetector(BitMatrix image, int initSize, int x2, int y2) throws NotFoundException {
        this.image = image;
        this.height = image.getHeight();
        this.width = image.getWidth();
        int halfsize = initSize / 2;
        this.leftInit = x2 - halfsize;
        this.rightInit = x2 + halfsize;
        this.upInit = y2 - halfsize;
        this.downInit = y2 + halfsize;
        if (this.upInit < 0 || this.leftInit < 0 || this.downInit >= this.height || this.rightInit >= this.width) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    public ResultPoint[] detect() throws NotFoundException {
        int left = this.leftInit;
        int right = this.rightInit;
        int up = this.upInit;
        int down = this.downInit;
        boolean sizeExceeded = false;
        boolean aBlackPointFoundOnBorder = true;
        boolean atLeastOneBlackPointFoundOnRight = false;
        boolean atLeastOneBlackPointFoundOnBottom = false;
        boolean atLeastOneBlackPointFoundOnLeft = false;
        boolean atLeastOneBlackPointFoundOnTop = false;
        while (aBlackPointFoundOnBorder) {
            aBlackPointFoundOnBorder = false;
            boolean rightBorderNotWhite = true;
            while ((rightBorderNotWhite || !atLeastOneBlackPointFoundOnRight) && right < this.width) {
                rightBorderNotWhite = this.containsBlackPoint(up, down, right, false);
                if (rightBorderNotWhite) {
                    ++right;
                    aBlackPointFoundOnBorder = true;
                    atLeastOneBlackPointFoundOnRight = true;
                    continue;
                }
                if (atLeastOneBlackPointFoundOnRight) continue;
                ++right;
            }
            if (right >= this.width) {
                sizeExceeded = true;
                break;
            }
            boolean bottomBorderNotWhite = true;
            while ((bottomBorderNotWhite || !atLeastOneBlackPointFoundOnBottom) && down < this.height) {
                bottomBorderNotWhite = this.containsBlackPoint(left, right, down, true);
                if (bottomBorderNotWhite) {
                    ++down;
                    aBlackPointFoundOnBorder = true;
                    atLeastOneBlackPointFoundOnBottom = true;
                    continue;
                }
                if (atLeastOneBlackPointFoundOnBottom) continue;
                ++down;
            }
            if (down >= this.height) {
                sizeExceeded = true;
                break;
            }
            boolean leftBorderNotWhite = true;
            while ((leftBorderNotWhite || !atLeastOneBlackPointFoundOnLeft) && left >= 0) {
                leftBorderNotWhite = this.containsBlackPoint(up, down, left, false);
                if (leftBorderNotWhite) {
                    --left;
                    aBlackPointFoundOnBorder = true;
                    atLeastOneBlackPointFoundOnLeft = true;
                    continue;
                }
                if (atLeastOneBlackPointFoundOnLeft) continue;
                --left;
            }
            if (left < 0) {
                sizeExceeded = true;
                break;
            }
            boolean topBorderNotWhite = true;
            while ((topBorderNotWhite || !atLeastOneBlackPointFoundOnTop) && up >= 0) {
                topBorderNotWhite = this.containsBlackPoint(left, right, up, true);
                if (topBorderNotWhite) {
                    --up;
                    aBlackPointFoundOnBorder = true;
                    atLeastOneBlackPointFoundOnTop = true;
                    continue;
                }
                if (atLeastOneBlackPointFoundOnTop) continue;
                --up;
            }
            if (up >= 0) continue;
            sizeExceeded = true;
            break;
        }
        if (!sizeExceeded) {
            int maxSize = right - left;
            ResultPoint z2 = null;
            for (int i2 = 1; z2 == null && i2 < maxSize; ++i2) {
                z2 = this.getBlackPointOnSegment(left, down - i2, left + i2, down);
            }
            if (z2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint t2 = null;
            for (int i3 = 1; t2 == null && i3 < maxSize; ++i3) {
                t2 = this.getBlackPointOnSegment(left, up + i3, left + i3, up);
            }
            if (t2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint x2 = null;
            for (int i4 = 1; x2 == null && i4 < maxSize; ++i4) {
                x2 = this.getBlackPointOnSegment(right, up + i4, right - i4, up);
            }
            if (x2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint y2 = null;
            for (int i5 = 1; y2 == null && i5 < maxSize; ++i5) {
                y2 = this.getBlackPointOnSegment(right, down - i5, right - i5, down);
            }
            if (y2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            return this.centerEdges(y2, z2, x2, t2);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private ResultPoint getBlackPointOnSegment(float aX, float aY, float bX, float bY) {
        int dist = MathUtils.round(MathUtils.distance(aX, aY, bX, bY));
        float xStep = (bX - aX) / (float)dist;
        float yStep = (bY - aY) / (float)dist;
        for (int i2 = 0; i2 < dist; ++i2) {
            int y2;
            int x2 = MathUtils.round(aX + (float)i2 * xStep);
            if (!this.image.get(x2, y2 = MathUtils.round(aY + (float)i2 * yStep))) continue;
            return new ResultPoint(x2, y2);
        }
        return null;
    }

    private ResultPoint[] centerEdges(ResultPoint y2, ResultPoint z2, ResultPoint x2, ResultPoint t2) {
        float yi = y2.getX();
        float yj = y2.getY();
        float zi = z2.getX();
        float zj = z2.getY();
        float xi = x2.getX();
        float xj = x2.getY();
        float ti = t2.getX();
        float tj = t2.getY();
        if (yi < (float)this.width / 2.0f) {
            return new ResultPoint[]{new ResultPoint(ti - 1.0f, tj + 1.0f), new ResultPoint(zi + 1.0f, zj + 1.0f), new ResultPoint(xi - 1.0f, xj - 1.0f), new ResultPoint(yi + 1.0f, yj - 1.0f)};
        }
        return new ResultPoint[]{new ResultPoint(ti + 1.0f, tj + 1.0f), new ResultPoint(zi + 1.0f, zj - 1.0f), new ResultPoint(xi - 1.0f, xj + 1.0f), new ResultPoint(yi - 1.0f, yj - 1.0f)};
    }

    private boolean containsBlackPoint(int a2, int b2, int fixed, boolean horizontal) {
        if (horizontal) {
            for (int x2 = a2; x2 <= b2; ++x2) {
                if (!this.image.get(x2, fixed)) continue;
                return true;
            }
        } else {
            for (int y2 = a2; y2 <= b2; ++y2) {
                if (!this.image.get(fixed, y2)) continue;
                return true;
            }
        }
        return false;
    }
}

