/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int BLOCK_SIZE_POWER = 3;
    private static final int BLOCK_SIZE = 8;
    private static final int BLOCK_SIZE_MASK = 7;
    private static final int MINIMUM_DIMENSION = 40;
    private static final int MIN_DYNAMIC_RANGE = 24;
    private BitMatrix matrix;

    public HybridBinarizer(LuminanceSource source) {
        super(source);
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        if (this.matrix != null) {
            return this.matrix;
        }
        LuminanceSource source = this.getLuminanceSource();
        int width = source.getWidth();
        int height = source.getHeight();
        if (width >= 40 && height >= 40) {
            byte[] luminances = source.getMatrix();
            int subWidth = width >> 3;
            if ((width & 7) != 0) {
                ++subWidth;
            }
            int subHeight = height >> 3;
            if ((height & 7) != 0) {
                ++subHeight;
            }
            int[][] blackPoints = HybridBinarizer.calculateBlackPoints(luminances, subWidth, subHeight, width, height);
            BitMatrix newMatrix = new BitMatrix(width, height);
            HybridBinarizer.calculateThresholdForBlock(luminances, subWidth, subHeight, width, height, blackPoints, newMatrix);
            this.matrix = newMatrix;
        } else {
            this.matrix = super.getBlackMatrix();
        }
        return this.matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource source) {
        return new HybridBinarizer(source);
    }

    private static void calculateThresholdForBlock(byte[] luminances, int subWidth, int subHeight, int width, int height, int[][] blackPoints, BitMatrix matrix) {
        int maxYOffset = height - 8;
        int maxXOffset = width - 8;
        for (int y2 = 0; y2 < subHeight; ++y2) {
            int yoffset = y2 << 3;
            if (yoffset > maxYOffset) {
                yoffset = maxYOffset;
            }
            int top = HybridBinarizer.cap(y2, subHeight - 3);
            for (int x2 = 0; x2 < subWidth; ++x2) {
                int xoffset = x2 << 3;
                if (xoffset > maxXOffset) {
                    xoffset = maxXOffset;
                }
                int left = HybridBinarizer.cap(x2, subWidth - 3);
                int sum = 0;
                for (int z2 = -2; z2 <= 2; ++z2) {
                    int[] blackRow = blackPoints[top + z2];
                    sum += blackRow[left - 2] + blackRow[left - 1] + blackRow[left] + blackRow[left + 1] + blackRow[left + 2];
                }
                int average = sum / 25;
                HybridBinarizer.thresholdBlock(luminances, xoffset, yoffset, average, width, matrix);
            }
        }
    }

    private static int cap(int value, int max) {
        if (value < 2) {
            return 2;
        }
        return Math.min(value, max);
    }

    private static void thresholdBlock(byte[] luminances, int xoffset, int yoffset, int threshold, int stride, BitMatrix matrix) {
        int y2 = 0;
        int offset = yoffset * stride + xoffset;
        while (y2 < 8) {
            for (int x2 = 0; x2 < 8; ++x2) {
                if ((luminances[offset + x2] & 0xFF) > threshold) continue;
                matrix.set(xoffset + x2, yoffset + y2);
            }
            ++y2;
            offset += stride;
        }
    }

    private static int[][] calculateBlackPoints(byte[] luminances, int subWidth, int subHeight, int width, int height) {
        int maxYOffset = height - 8;
        int maxXOffset = width - 8;
        int[][] blackPoints = new int[subHeight][subWidth];
        for (int y2 = 0; y2 < subHeight; ++y2) {
            int yoffset = y2 << 3;
            if (yoffset > maxYOffset) {
                yoffset = maxYOffset;
            }
            for (int x2 = 0; x2 < subWidth; ++x2) {
                int xoffset = x2 << 3;
                if (xoffset > maxXOffset) {
                    xoffset = maxXOffset;
                }
                int sum = 0;
                int min = 255;
                int max = 0;
                int yy = 0;
                int offset = yoffset * width + xoffset;
                while (yy < 8) {
                    int xx;
                    for (xx = 0; xx < 8; ++xx) {
                        int pixel = luminances[offset + xx] & 0xFF;
                        sum += pixel;
                        if (pixel < min) {
                            min = pixel;
                        }
                        if (pixel <= max) continue;
                        max = pixel;
                    }
                    if (max - min > 24) {
                        ++yy;
                        offset += width;
                        while (yy < 8) {
                            for (xx = 0; xx < 8; ++xx) {
                                sum += luminances[offset + xx] & 0xFF;
                            }
                            ++yy;
                            offset += width;
                        }
                    }
                    ++yy;
                    offset += width;
                }
                int average = sum >> 6;
                if (max - min <= 24) {
                    int averageNeighborBlackPoint;
                    average = min / 2;
                    if (y2 > 0 && x2 > 0 && min < (averageNeighborBlackPoint = (blackPoints[y2 - 1][x2] + 2 * blackPoints[y2][x2 - 1] + blackPoints[y2 - 1][x2 - 1]) / 4)) {
                        average = averageNeighborBlackPoint;
                    }
                }
                blackPoints[y2][x2] = average;
            }
        }
        return blackPoints;
    }
}

