/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.common.BitArray;
import java.util.Arrays;

public final class BitMatrix
implements Cloneable {
    private final int width;
    private final int height;
    private final int rowSize;
    private final int[] bits;

    public BitMatrix(int dimension) {
        int n2 = dimension;
        this(n2, n2);
    }

    public BitMatrix(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = width;
        this.height = height;
        this.rowSize = (width + 31) / 32;
        this.bits = new int[this.rowSize * height];
    }

    private BitMatrix(int width, int height, int rowSize, int[] bits) {
        this.width = width;
        this.height = height;
        this.rowSize = rowSize;
        this.bits = bits;
    }

    public static BitMatrix parse(boolean[][] image) {
        int height = image.length;
        int width = image[0].length;
        BitMatrix bits = new BitMatrix(width, height);
        for (int i2 = 0; i2 < height; ++i2) {
            boolean[] imageI = image[i2];
            for (int j2 = 0; j2 < width; ++j2) {
                if (!imageI[j2]) continue;
                bits.set(j2, i2);
            }
        }
        return bits;
    }

    public static BitMatrix parse(String stringRepresentation, String setString, String unsetString) {
        if (stringRepresentation == null) {
            throw new IllegalArgumentException();
        }
        boolean[] bits = new boolean[stringRepresentation.length()];
        int bitsPos = 0;
        int rowStartPos = 0;
        int rowLength = -1;
        int nRows = 0;
        int pos = 0;
        while (pos < stringRepresentation.length()) {
            if (stringRepresentation.charAt(pos) == '\n' || stringRepresentation.charAt(pos) == '\r') {
                if (bitsPos > rowStartPos) {
                    if (rowLength == -1) {
                        rowLength = bitsPos - rowStartPos;
                    } else if (bitsPos - rowStartPos != rowLength) {
                        throw new IllegalArgumentException("row lengths do not match");
                    }
                    rowStartPos = bitsPos;
                    ++nRows;
                }
                ++pos;
                continue;
            }
            if (stringRepresentation.startsWith(setString, pos)) {
                pos += setString.length();
                bits[bitsPos] = true;
                ++bitsPos;
                continue;
            }
            if (stringRepresentation.startsWith(unsetString, pos)) {
                pos += unsetString.length();
                bits[bitsPos] = false;
                ++bitsPos;
                continue;
            }
            throw new IllegalArgumentException("illegal character encountered: " + stringRepresentation.substring(pos));
        }
        if (bitsPos > rowStartPos) {
            if (rowLength == -1) {
                rowLength = bitsPos - rowStartPos;
            } else if (bitsPos - rowStartPos != rowLength) {
                throw new IllegalArgumentException("row lengths do not match");
            }
            ++nRows;
        }
        BitMatrix matrix = new BitMatrix(rowLength, nRows);
        for (int i2 = 0; i2 < bitsPos; ++i2) {
            if (!bits[i2]) continue;
            matrix.set(i2 % rowLength, i2 / rowLength);
        }
        return matrix;
    }

    public boolean get(int x2, int y2) {
        int offset = y2 * this.rowSize + x2 / 32;
        return (this.bits[offset] >>> (x2 & 0x1F) & 1) != 0;
    }

    public void set(int x2, int y2) {
        int offset;
        int n2 = offset = y2 * this.rowSize + x2 / 32;
        this.bits[n2] = this.bits[n2] | 1 << (x2 & 0x1F);
    }

    public void unset(int x2, int y2) {
        int offset;
        int n2 = offset = y2 * this.rowSize + x2 / 32;
        this.bits[n2] = this.bits[n2] & ~(1 << (x2 & 0x1F));
    }

    public void flip(int x2, int y2) {
        int offset;
        int n2 = offset = y2 * this.rowSize + x2 / 32;
        this.bits[n2] = this.bits[n2] ^ 1 << (x2 & 0x1F);
    }

    public void xor(BitMatrix mask) {
        if (this.width != mask.width || this.height != mask.height || this.rowSize != mask.rowSize) {
            throw new IllegalArgumentException("input matrix dimensions do not match");
        }
        BitArray rowArray = new BitArray(this.width);
        for (int y2 = 0; y2 < this.height; ++y2) {
            int offset = y2 * this.rowSize;
            int[] row = mask.getRow(y2, rowArray).getBitArray();
            for (int x2 = 0; x2 < this.rowSize; ++x2) {
                int n2 = offset + x2;
                this.bits[n2] = this.bits[n2] ^ row[x2];
            }
        }
    }

    public void clear() {
        int max = this.bits.length;
        for (int i2 = 0; i2 < max; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public void setRegion(int left, int top, int width, int height) {
        if (top < 0 || left < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (height <= 0 || width <= 0) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int right = left + width;
        int bottom = top + height;
        if (bottom > this.height || right > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        for (int y2 = top; y2 < bottom; ++y2) {
            int offset = y2 * this.rowSize;
            for (int x2 = left; x2 < right; ++x2) {
                int n2 = offset + x2 / 32;
                this.bits[n2] = this.bits[n2] | 1 << (x2 & 0x1F);
            }
        }
    }

    public BitArray getRow(int y2, BitArray row) {
        if (row == null || row.getSize() < this.width) {
            row = new BitArray(this.width);
        } else {
            row.clear();
        }
        int offset = y2 * this.rowSize;
        for (int x2 = 0; x2 < this.rowSize; ++x2) {
            row.setBulk(x2 << 5, this.bits[offset + x2]);
        }
        return row;
    }

    public void setRow(int y2, BitArray row) {
        System.arraycopy(row.getBitArray(), 0, this.bits, y2 * this.rowSize, this.rowSize);
    }

    public void rotate180() {
        BitArray topRow = new BitArray(this.width);
        BitArray bottomRow = new BitArray(this.width);
        int maxHeight = (this.height + 1) / 2;
        for (int i2 = 0; i2 < maxHeight; ++i2) {
            topRow = this.getRow(i2, topRow);
            int bottomRowIndex = this.height - 1 - i2;
            bottomRow = this.getRow(bottomRowIndex, bottomRow);
            topRow.reverse();
            bottomRow.reverse();
            this.setRow(i2, bottomRow);
            this.setRow(bottomRowIndex, topRow);
        }
    }

    public int[] getEnclosingRectangle() {
        int left = this.width;
        int top = this.height;
        int right = -1;
        int bottom = -1;
        for (int y2 = 0; y2 < this.height; ++y2) {
            for (int x32 = 0; x32 < this.rowSize; ++x32) {
                int bit;
                int theBits = this.bits[y2 * this.rowSize + x32];
                if (theBits == 0) continue;
                if (y2 < top) {
                    top = y2;
                }
                if (y2 > bottom) {
                    bottom = y2;
                }
                if (x32 << 5 < left) {
                    bit = 0;
                    while (theBits << 31 - bit == 0) {
                        ++bit;
                    }
                    if ((x32 << 5) + bit < left) {
                        left = (x32 << 5) + bit;
                    }
                }
                if ((x32 << 5) + 31 <= right) continue;
                bit = 31;
                while (theBits >>> bit == 0) {
                    --bit;
                }
                if ((x32 << 5) + bit <= right) continue;
                right = (x32 << 5) + bit;
            }
        }
        if (right < left || bottom < top) {
            return null;
        }
        return new int[]{left, top, right - left + 1, bottom - top + 1};
    }

    public int[] getTopLeftOnBit() {
        int bitsOffset;
        for (bitsOffset = 0; bitsOffset < this.bits.length && this.bits[bitsOffset] == 0; ++bitsOffset) {
        }
        if (bitsOffset == this.bits.length) {
            return null;
        }
        int y2 = bitsOffset / this.rowSize;
        int x2 = bitsOffset % this.rowSize << 5;
        int theBits = this.bits[bitsOffset];
        int bit = 0;
        while (theBits << 31 - bit == 0) {
            ++bit;
        }
        return new int[]{x2 += bit, y2};
    }

    public int[] getBottomRightOnBit() {
        int bitsOffset;
        for (bitsOffset = this.bits.length - 1; bitsOffset >= 0 && this.bits[bitsOffset] == 0; --bitsOffset) {
        }
        if (bitsOffset < 0) {
            return null;
        }
        int y2 = bitsOffset / this.rowSize;
        int x2 = bitsOffset % this.rowSize << 5;
        int theBits = this.bits[bitsOffset];
        int bit = 31;
        while (theBits >>> bit == 0) {
            --bit;
        }
        return new int[]{x2 += bit, y2};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof BitMatrix)) {
            return false;
        }
        BitMatrix other = (BitMatrix)o2;
        return this.width == other.width && this.height == other.height && this.rowSize == other.rowSize && Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        return (((this.width * 31 + this.width) * 31 + this.height) * 31 + this.rowSize) * 31 + Arrays.hashCode(this.bits);
    }

    public String toString() {
        return this.toString("X ", "  ");
    }

    public String toString(String setString, String unsetString) {
        return this.buildToString(setString, unsetString, "\n");
    }

    @Deprecated
    public String toString(String setString, String unsetString, String lineSeparator) {
        return this.buildToString(setString, unsetString, lineSeparator);
    }

    private String buildToString(String setString, String unsetString, String lineSeparator) {
        StringBuilder result = new StringBuilder(this.height * (this.width + 1));
        for (int y2 = 0; y2 < this.height; ++y2) {
            for (int x2 = 0; x2 < this.width; ++x2) {
                result.append(this.get(x2, y2) ? setString : unsetString);
            }
            result.append(lineSeparator);
        }
        return result.toString();
    }

    public BitMatrix clone() {
        return new BitMatrix(this.width, this.height, this.rowSize, (int[])this.bits.clone());
    }
}

