/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.VCardResultParser;
import java.util.List;

public final class VEventResultParser
extends ResultParser {
    @Override
    public CalendarParsedResult parse(Result result) {
        double longitude;
        double latitude;
        String rawText = VEventResultParser.getMassagedText(result);
        if (rawText.indexOf("BEGIN:VEVENT") < 0) {
            return null;
        }
        String summary = VEventResultParser.matchSingleVCardPrefixedField("SUMMARY", rawText);
        String start = VEventResultParser.matchSingleVCardPrefixedField("DTSTART", rawText);
        if (start == null) {
            return null;
        }
        String end = VEventResultParser.matchSingleVCardPrefixedField("DTEND", rawText);
        String duration = VEventResultParser.matchSingleVCardPrefixedField("DURATION", rawText);
        String location = VEventResultParser.matchSingleVCardPrefixedField("LOCATION", rawText);
        String organizer = VEventResultParser.stripMailto(VEventResultParser.matchSingleVCardPrefixedField("ORGANIZER", rawText));
        String[] attendees = VEventResultParser.matchVCardPrefixedField("ATTENDEE", rawText);
        if (attendees != null) {
            for (int i2 = 0; i2 < attendees.length; ++i2) {
                attendees[i2] = VEventResultParser.stripMailto(attendees[i2]);
            }
        }
        String description = VEventResultParser.matchSingleVCardPrefixedField("DESCRIPTION", rawText);
        String geoString = VEventResultParser.matchSingleVCardPrefixedField("GEO", rawText);
        if (geoString == null) {
            latitude = Double.NaN;
            longitude = Double.NaN;
        } else {
            int semicolon = geoString.indexOf(59);
            if (semicolon < 0) {
                return null;
            }
            try {
                latitude = Double.parseDouble(geoString.substring(0, semicolon));
                longitude = Double.parseDouble(geoString.substring(semicolon + 1));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        try {
            return new CalendarParsedResult(summary, start, end, duration, location, organizer, attendees, description, latitude, longitude);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static String matchSingleVCardPrefixedField(CharSequence prefix, String rawText) {
        List<String> values = VCardResultParser.matchSingleVCardPrefixedField(prefix, rawText, true, false);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    private static String[] matchVCardPrefixedField(CharSequence prefix, String rawText) {
        List<List<String>> values = VCardResultParser.matchVCardPrefixedField(prefix, rawText, true, false);
        if (values == null || values.isEmpty()) {
            return null;
        }
        int size = values.size();
        String[] result = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            result[i2] = values.get(i2).get(0);
        }
        return result;
    }

    private static String stripMailto(String s2) {
        if (s2 != null && (s2.startsWith("mailto:") || s2.startsWith("MAILTO:"))) {
            s2 = s2.substring(7);
        }
        return s2;
    }
}

