/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.aztec.decoder.Decoder;
import com.google.zxing.aztec.detector.Detector;
import com.google.zxing.common.DecoderResult;
import java.util.List;
import java.util.Map;

public final class AztecReader
implements Reader {
    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        String ecLevel;
        ResultPointCallback rpcb;
        AztecDetectorResult detectorResult;
        Object notFoundException22 = null;
        Object formatException22 = null;
        Detector detector = new Detector(image.getBlackMatrix());
        ResultPoint[] points = null;
        DecoderResult decoderResult = null;
        try {
            detectorResult = detector.detect(false);
            points = detectorResult.getPoints();
            decoderResult = new Decoder().decode(detectorResult);
        }
        catch (NotFoundException notFoundException22) {
        }
        catch (FormatException formatException22) {
            // empty catch block
        }
        if (decoderResult == null) {
            try {
                detectorResult = detector.detect(true);
                points = detectorResult.getPoints();
                decoderResult = new Decoder().decode(detectorResult);
            }
            catch (FormatException | NotFoundException e2) {
                if (notFoundException22 != null) {
                    throw notFoundException22;
                }
                if (formatException22 != null) {
                    throw formatException22;
                }
                throw e2;
            }
        }
        if (hints != null && (rpcb = (ResultPointCallback)hints.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            ResultPoint[] resultPointArray = points;
            int n2 = points.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ResultPoint point = resultPointArray[i2];
                rpcb.foundPossibleResultPoint(point);
            }
        }
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), decoderResult.getNumBits(), points, BarcodeFormat.AZTEC, System.currentTimeMillis());
        List<byte[]> byteSegments = decoderResult.getByteSegments();
        if (byteSegments != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, byteSegments);
        }
        if ((ecLevel = decoderResult.getECLevel()) != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
        }
        return result;
    }

    @Override
    public void reset() {
    }
}

