/*
 * Decompiled with CFR 0.152.
 */
package org.systel.ui.components;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.systel.ui.components.LineEtchedBorder;

public class TicketButton
extends JPanel {
    private int id = 0;
    private Image bgImage = null;
    private String imgPath;

    @Override
    public void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public void setBgImage(Image image) {
        this.bgImage = image;
    }

    public String getImgPath() {
        return this.imgPath;
    }

    public void setImgPath(String string) {
        try {
            TicketButton ticketButton = this;
            ticketButton.setBgImage(ImageIO.read(ticketButton.getClass().getResourceAsStream(string)));
        }
        catch (IOException iOException) {
            Logger.getLogger(TicketButton.class.getName()).log(Level.SEVERE, null, iOException);
        }
        this.imgPath = string;
    }

    public TicketButton() {
        Serializable serializable = this;
        serializable.setBackground(new Color(47, 47, 47));
        serializable.setPreferredSize(new Dimension(150, 64));
        GroupLayout groupLayout = new GroupLayout((Container)serializable);
        serializable.setLayout(groupLayout);
        GroupLayout groupLayout2 = groupLayout;
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 127, Short.MAX_VALUE));
        GroupLayout groupLayout3 = groupLayout;
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 48, Short.MAX_VALUE));
        serializable = new LineEtchedBorder(new Color(64, 64, 64), 2, true);
        new LineEtchedBorder(new Color(64, 64, 64), 2, true).arc = 11;
        this.setBorder((Border)((Object)serializable));
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            Serializable serializable = jComponent.getParent() != null ? jComponent.getParent().getBackground() : this.getBackground();
            graphics2D.setColor((Color)serializable);
            graphics2D.drawRect(0, 0, n2, n3);
            graphics2D.setColor(this.getBackground());
            serializable = (LineEtchedBorder)jComponent.getBorder();
            graphics2D.drawRoundRect(0, 0, n2, n3, ((LineEtchedBorder)serializable).realArc, ((LineEtchedBorder)serializable).realArc);
            ((LineEtchedBorder)serializable).paintBorder(jComponent, graphics, 0, 0, n2, n3);
            graphics2D.setColor(color);
        }
    }
}

