/*
 * Decompiled with CFR 0.152.
 */
package org.systel.ui.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class MarqueePanel
extends JPanel
implements ActionListener,
WindowListener,
AncestorListener {
    protected boolean paintChildren;
    protected boolean scrollingPaused;
    protected int scrollOffset;
    protected int wrapOffset;
    private int preferredWidth = -1;
    private int scrollAmount;
    private int initialDelay;
    private int scrollFrequency;
    private boolean wrap = false;
    private int wrapAmount = 50;
    private boolean scrollWhenFocused = true;
    private Timer timer = new Timer(1000, this);

    public MarqueePanel() {
        this(20, 5);
    }

    public MarqueePanel(int n2, int n3) {
        this(n2, n3, 1500);
    }

    public MarqueePanel(int n2, int n3, int n4) {
        this.setInitialDelay(n4);
        this.setScrollFrequency(n2);
        this.setScrollAmount(n3);
        this.setLayout(new BoxLayout(this, 0));
        MarqueePanel marqueePanel = this;
        marqueePanel.addAncestorListener(marqueePanel);
    }

    @Override
    public void paintChildren(Graphics graphics) {
        if (!this.paintChildren) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(-this.scrollOffset, 0);
        super.paintChildren(graphics);
        graphics2D.translate(this.scrollOffset, 0);
        if (this.isWrap()) {
            this.wrapOffset = this.scrollOffset - super.getPreferredSize().width - this.wrapAmount;
            graphics2D.translate(-this.wrapOffset, 0);
            super.paintChildren(graphics);
            graphics2D.translate(this.wrapOffset, 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        super.getPreferredSize().width = this.preferredWidth == -1 ? dimension.width / 2 : this.preferredWidth;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int n2) {
        this.preferredWidth = n2;
        this.revalidate();
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int n2) {
        this.scrollAmount = n2;
    }

    public int getScrollFrequency() {
        return this.scrollFrequency;
    }

    public void setScrollFrequency(int n2) {
        this.scrollFrequency = n2;
        n2 = 1000 / n2;
        this.timer.setDelay(n2);
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int n2) {
        this.initialDelay = n2;
    }

    public boolean isScrollWhenFocused() {
        return this.scrollWhenFocused;
    }

    public void setScrollWhenFocused(boolean bl) {
        this.scrollWhenFocused = bl;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean bl) {
        this.wrap = bl;
    }

    public int getWrapAmount() {
        return this.wrapAmount;
    }

    public void setWrapAmount(int n2) {
        this.wrapAmount = n2;
    }

    public void startScrolling() {
        this.paintChildren = true;
        this.scrollOffset = 0;
        this.repaint();
        int n2 = 0;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            n2 += this.getComponent(i2).getWidth();
        }
        this.timer.setInitialDelay(this.initialDelay);
        if (n2 > this.getWidth()) {
            this.timer.start();
        }
    }

    public void stopScrolling() {
        this.timer.stop();
        this.paintChildren = false;
        this.repaint();
    }

    public boolean isPaused() {
        return this.scrollingPaused;
    }

    public void pauseScrolling() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.scrollingPaused = true;
        }
    }

    public void resumeScrolling() {
        if (this.scrollingPaused) {
            this.timer.setInitialDelay(0);
            this.timer.restart();
            this.scrollingPaused = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.scrollOffset += this.scrollAmount;
        int n2 = super.getPreferredSize().width;
        if (this.scrollOffset > n2) {
            this.scrollOffset = this.isWrap() ? this.wrapOffset + this.scrollAmount : -this.getSize().width;
        }
        this.repaint();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        SwingUtilities.windowForComponent(this).addWindowListener(this);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (this.isScrollWhenFocused()) {
            this.resumeScrolling();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.stopScrolling();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.stopScrolling();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (this.isScrollWhenFocused()) {
            this.pauseScrolling();
        }
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this.resumeScrolling();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.pauseScrolling();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.startScrolling();
    }
}

