/*
 * Decompiled with CFR 0.152.
 */
package org.systel.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.ConstructorProperties;
import javax.swing.border.LineBorder;

public class LineEtchedBorder
extends LineBorder {
    protected Color transparentColor;
    protected Color highlight;
    protected Color shadow;
    protected int arc;
    protected int realArc;

    public LineEtchedBorder(Color color) {
        this(color, 1, false);
    }

    public LineEtchedBorder(Color color, int n2) {
        this(color, n2, false);
    }

    public LineEtchedBorder(Color color, int n2, boolean bl, int n3) {
        this(color, n2, bl);
        this.arc = n3;
    }

    @ConstructorProperties(value={"lineColor", "thickness", "roundedCorners"})
    public LineEtchedBorder(Color color, int n2, boolean bl) {
        super(color, n2, bl);
        this.arc = n2 * 11;
        if (this.arc > 55) {
            this.arc = 55;
        }
    }

    public Color getHighlightColor(Component component) {
        if (this.highlight != null) {
            return this.highlight;
        }
        return component.getBackground().brighter();
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor(Component component) {
        if (this.shadow != null) {
            return this.shadow;
        }
        return component.getBackground().darker();
    }

    public Color getShadowColor() {
        return this.shadow;
    }

    public int getArc() {
        return this.arc;
    }

    public void setArc(int n2) {
        this.arc = n2;
    }

    @Override
    public void paintBorder(Component object, Graphics object2, int n2, int n3, int n4, int n5) {
        if (this.thickness > 0 && object2 instanceof Graphics2D) {
            object = (Graphics2D)object2;
            object2 = ((Graphics)object).getColor();
            ((Graphics)object).setColor(this.lineColor);
            this.realArc = this.arc > n4 || this.arc > n5 ? (n4 > n5 ? n5 / 2 : n4 / 2) : this.arc;
            for (int i2 = 0; i2 < this.thickness; ++i2) {
                int n6;
                int n7 = n6 = this.realArc - i2;
                ((Graphics)object).drawRoundRect(n2 + i2, n3 + i2, n4 - (2 * i2 + 1), n5 - (2 * i2 + 1), n7, n7);
            }
            ((Graphics)object).setColor((Color)object2);
        }
    }
}

