/*
 * Decompiled with CFR 0.152.
 */
package org.systel.db;

import com.ucod.crud.IBaseEntity;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlRootElement;
import org.systel.db.BaseEntity;
import org.systel.db.Department;
import org.systel.db.Inventory;
import org.systel.db.Location;
import org.systel.db.Locator;

@Entity
@Table(name="warehouse", catalog="cuora", schema="public", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Warehouse.findAll", query="SELECT w FROM Warehouse w"), @NamedQuery(name="Warehouse.findByWarehouseId", query="SELECT w FROM Warehouse w WHERE w.warehouseId = :warehouseId"), @NamedQuery(name="Warehouse.findByIsactive", query="SELECT w FROM Warehouse w WHERE w.isactive = :isactive"), @NamedQuery(name="Warehouse.findByCreated", query="SELECT w FROM Warehouse w WHERE w.created = :created"), @NamedQuery(name="Warehouse.findByCreatedby", query="SELECT w FROM Warehouse w WHERE w.createdby = :createdby"), @NamedQuery(name="Warehouse.findByUpdated", query="SELECT w FROM Warehouse w WHERE w.updated = :updated"), @NamedQuery(name="Warehouse.findByUpdatedby", query="SELECT w FROM Warehouse w WHERE w.updatedby = :updatedby"), @NamedQuery(name="Warehouse.findByValue", query="SELECT w FROM Warehouse w WHERE w.value = :value"), @NamedQuery(name="Warehouse.findByName", query="SELECT w FROM Warehouse w WHERE w.name = :name"), @NamedQuery(name="Warehouse.findByDescription", query="SELECT w FROM Warehouse w WHERE w.description = :description"), @NamedQuery(name="Warehouse.findBySeparator", query="SELECT w FROM Warehouse w WHERE w.separator = :separator"), @NamedQuery(name="Warehouse.findByIsshipper", query="SELECT w FROM Warehouse w WHERE w.isshipper = :isshipper"), @NamedQuery(name="Warehouse.findByShippercode", query="SELECT w FROM Warehouse w WHERE w.shippercode = :shippercode"), @NamedQuery(name="Warehouse.findByFromdocumentno", query="SELECT w FROM Warehouse w WHERE w.fromdocumentno = :fromdocumentno"), @NamedQuery(name="Warehouse.findByTodocumentno", query="SELECT w FROM Warehouse w WHERE w.todocumentno = :todocumentno"), @NamedQuery(name="Warehouse.findByReturnlocatorId", query="SELECT w FROM Warehouse w WHERE w.returnlocatorId = :returnlocatorId")})
public class Warehouse
extends BaseEntity
implements IBaseEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_WAREHOUSEID = "warehouseId";
    public static final String PROP_ISACTIVE = "isactive";
    public static final String PROP_CREATED = "created";
    public static final String PROP_CREATEDBY = "createdby";
    public static final String PROP_UPDATED = "updated";
    public static final String PROP_UPDATEDBY = "updatedby";
    public static final String PROP_VALUE = "value";
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_SEPARATOR = "separator";
    public static final String PROP_ISSHIPPER = "isshipper";
    public static final String PROP_SHIPPERCODE = "shippercode";
    public static final String PROP_FROMDOCUMENTNO = "fromdocumentno";
    public static final String PROP_TODOCUMENTNO = "todocumentno";
    public static final String PROP_RETURNLOCATORID = "returnlocatorId";
    public static final String PROP_INVENTORYLIST = "inventoryList";
    public static final String PROP_DEPARTMENTLIST = "departmentList";
    public static final String PROP_LOCATIONID = "locationId";
    public static final String PROP_LOCATORLIST = "locatorList";
    @Id
    @Basic(optional=false)
    @Column(name="warehouse_id", nullable=false, length=32)
    private String warehouseId;
    @Basic(optional=false)
    @Column(name="isactive", nullable=false)
    private Character isactive;
    @Basic(optional=false)
    @Column(name="created", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @Basic(optional=false)
    @Column(name="createdby", nullable=false, length=32)
    private String createdby;
    @Basic(optional=false)
    @Column(name="updated", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updated;
    @Basic(optional=false)
    @Column(name="updatedby", nullable=false, length=32)
    private String updatedby;
    @Basic(optional=false)
    @Column(name="value", nullable=false, length=40)
    private String value;
    @Basic(optional=false)
    @Column(name="name", nullable=false, length=60)
    private String name;
    @Column(name="description", length=255)
    private String description;
    @Basic(optional=false)
    @Column(name="separator", nullable=false)
    private Character separator;
    @Column(name="isshipper")
    private Character isshipper;
    @Column(name="shippercode", length=20)
    private String shippercode;
    @Column(name="fromdocumentno")
    private Long fromdocumentno;
    @Column(name="todocumentno")
    private Long todocumentno;
    @Column(name="returnlocator_id", length=32)
    private String returnlocatorId;
    @OneToMany(mappedBy="warehouseId")
    private List<Inventory> inventoryList;
    @OneToMany(mappedBy="warehouseId")
    private List<Department> departmentList;
    @JoinColumn(name="location_id", referencedColumnName="location_id", nullable=false)
    @ManyToOne(optional=false)
    private Location locationId;
    @OneToMany(mappedBy="warehouseId")
    private List<Locator> locatorList;

    public Warehouse() {
    }

    public Warehouse(String string) {
        this.warehouseId = string;
    }

    public Warehouse(String string, Character c2, Date date, String string2, Date date2, String string3, String string4, String string5, Character c3) {
        this.warehouseId = string;
        this.isactive = c2;
        this.created = date;
        this.createdby = string2;
        this.updated = date2;
        this.updatedby = string3;
        this.value = string4;
        this.name = string5;
        this.separator = c3;
    }

    public int hashCode() {
        int n2 = 0 + (this.warehouseId != null ? this.warehouseId.hashCode() : 0);
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Warehouse)) {
            return false;
        }
        object = (Warehouse)object;
        return (this.warehouseId != null || ((Warehouse)object).warehouseId == null) && (this.warehouseId == null || this.warehouseId.equals(((Warehouse)object).warehouseId));
    }

    public String toString() {
        return "org.systel.db.Warehouse[ warehouseId=" + this.warehouseId + " ]";
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public Character getIsactive() {
        return this.isactive;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getCreatedby() {
        return this.createdby;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getUpdatedby() {
        return this.updatedby;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Character getSeparator() {
        return this.separator;
    }

    public Character getIsshipper() {
        return this.isshipper;
    }

    public String getShippercode() {
        return this.shippercode;
    }

    public Long getFromdocumentno() {
        return this.fromdocumentno;
    }

    public Long getTodocumentno() {
        return this.todocumentno;
    }

    public String getReturnlocatorId() {
        return this.returnlocatorId;
    }

    public List<Inventory> getInventoryList() {
        return this.inventoryList;
    }

    public List<Department> getDepartmentList() {
        return this.departmentList;
    }

    public Location getLocationId() {
        return this.locationId;
    }

    public List<Locator> getLocatorList() {
        return this.locatorList;
    }

    public void setWarehouseId(String string) {
        String string2 = this.warehouseId;
        this.warehouseId = string;
        this.firePropertyChange(PROP_WAREHOUSEID, string2, string);
    }

    public void setIsactive(Character c2) {
        Character c3 = this.isactive;
        this.isactive = c2;
        this.firePropertyChange(PROP_ISACTIVE, c3, c2);
    }

    public void setCreated(Date date) {
        Date date2 = this.created;
        this.created = date;
        this.firePropertyChange(PROP_CREATED, date2, date);
    }

    public void setCreatedby(String string) {
        String string2 = this.createdby;
        this.createdby = string;
        this.firePropertyChange(PROP_CREATEDBY, string2, string);
    }

    public void setUpdated(Date date) {
        Date date2 = this.updated;
        this.updated = date;
        this.firePropertyChange(PROP_UPDATED, date2, date);
    }

    public void setUpdatedby(String string) {
        String string2 = this.updatedby;
        this.updatedby = string;
        this.firePropertyChange(PROP_UPDATEDBY, string2, string);
    }

    public void setValue(String string) {
        String string2 = this.value;
        this.value = string;
        this.firePropertyChange(PROP_VALUE, string2, string);
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange(PROP_NAME, string2, string);
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.firePropertyChange(PROP_DESCRIPTION, string2, string);
    }

    public void setSeparator(Character c2) {
        Character c3 = this.separator;
        this.separator = c2;
        this.firePropertyChange(PROP_SEPARATOR, c3, c2);
    }

    public void setIsshipper(Character c2) {
        Character c3 = this.isshipper;
        this.isshipper = c2;
        this.firePropertyChange(PROP_ISSHIPPER, c3, c2);
    }

    public void setShippercode(String string) {
        String string2 = this.shippercode;
        this.shippercode = string;
        this.firePropertyChange(PROP_SHIPPERCODE, string2, string);
    }

    public void setFromdocumentno(Long l2) {
        Long l3 = this.fromdocumentno;
        this.fromdocumentno = l2;
        this.firePropertyChange(PROP_FROMDOCUMENTNO, l3, l2);
    }

    public void setTodocumentno(Long l2) {
        Long l3 = this.todocumentno;
        this.todocumentno = l2;
        this.firePropertyChange(PROP_TODOCUMENTNO, l3, l2);
    }

    public void setReturnlocatorId(String string) {
        String string2 = this.returnlocatorId;
        this.returnlocatorId = string;
        this.firePropertyChange(PROP_RETURNLOCATORID, string2, string);
    }

    public void setInventoryList(List<Inventory> list) {
        List<Inventory> list2 = this.inventoryList;
        this.inventoryList = list;
        this.firePropertyChange(PROP_INVENTORYLIST, list2, list);
    }

    public void setDepartmentList(List<Department> list) {
        List<Department> list2 = this.departmentList;
        this.departmentList = list;
        this.firePropertyChange(PROP_DEPARTMENTLIST, list2, list);
    }

    public void setLocationId(Location location) {
        Location location2 = this.locationId;
        this.locationId = location;
        this.firePropertyChange(PROP_LOCATIONID, location2, location);
    }

    public void setLocatorList(List<Locator> list) {
        List<Locator> list2 = this.locatorList;
        this.locatorList = list;
        this.firePropertyChange(PROP_LOCATORLIST, list2, list);
    }

    @Override
    public Object getID() {
        return this.warehouseId;
    }
}

