/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.extension;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.XPathEngine;
import org.eclipse.persistence.sdo.helper.extension.OPStack;
import org.eclipse.persistence.sdo.helper.extension.Token;
import org.eclipse.persistence.sdo.helper.extension.XPathExpression;

public class XPathHelper {
    private static XPathHelper instance;
    static final int GTE = 4;
    static final int LTE = 5;
    static final int GT = 6;
    static final int LT = 7;
    static final int EQ = 8;
    static final int NEQ = 9;
    static final int AND = 10;
    static final int OR = 11;
    private static final String GTE_STR = ">=";
    private static final String LTE_STR = "<=";
    private static final String GT_STR = ">";
    private static final String LT_STR = "<";
    private static final String EQ_STR = "=";
    private static final String NEQ_STR = "!=";
    private static final String AND_STR = "and";
    private static final String OR_STR = "or";

    public static XPathHelper getInstance() {
        if (instance == null) {
            instance = new XPathHelper();
        }
        return instance;
    }

    public XPathExpression prepareExpression(String expression) {
        return new XPathExpression(expression);
    }

    public List evaluate(String expression, DataObject dataObject) {
        ArrayList results = new ArrayList();
        if (this.shouldCallXPathEngine(expression)) {
            return this.addResultsToList(XPathEngine.getInstance().get(expression, dataObject), results);
        }
        return this.evaluate(expression, dataObject, results);
    }

    private List evaluate(String expression, DataObject dataObject, List results) {
        int index = expression.indexOf(47);
        if (index > -1) {
            if (index == expression.length() - 1) {
                return this.addResultsToList(this.processFragment(expression.substring(0, index), dataObject), results);
            }
            Object result = this.processFragment(expression.substring(0, index), dataObject);
            if (result instanceof DataObject) {
                return this.evaluate(expression.substring(index + 1, expression.length()), (DataObject)result, results);
            }
            if (result instanceof List) {
                Iterator resultIt = ((List)result).iterator();
                while (resultIt.hasNext()) {
                    this.evaluate(expression.substring(index + 1, expression.length()), (DataObject)resultIt.next(), results);
                }
                return results;
            }
            return null;
        }
        return this.addResultsToList(this.processFragment(expression, dataObject), results);
    }

    private Object processFragment(String xpFrag, DataObject dataObject) {
        if (xpFrag.equals(".")) {
            return dataObject;
        }
        if (xpFrag.equals("..")) {
            return dataObject.getContainer();
        }
        int idx = (xpFrag = this.getPathWithAtRemoved(xpFrag)).indexOf(91);
        if (idx > -1) {
            return this.processBracket(xpFrag, dataObject, idx);
        }
        Property prop = dataObject.getInstanceProperty(xpFrag);
        try {
            return dataObject.get(prop);
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    private Object processBracket(String xpFrag, DataObject dataObject, int idx) {
        int closeIdx = xpFrag.indexOf(93);
        if (closeIdx == -1 || closeIdx < idx) {
            return null;
        }
        String contents = xpFrag.substring(idx + 1, closeIdx);
        if (contents.matches("[1-9][0-9]*")) {
            return this.processIndex(xpFrag, dataObject, idx, Integer.parseInt(contents) - 1);
        }
        if (contents.matches("[1-9].[0-9]*")) {
            Float num = Float.valueOf(contents);
            return this.processIndex(xpFrag, dataObject, idx, num.intValue() - 1);
        }
        String reference = xpFrag.substring(0, idx);
        if (contents.indexOf(AND_STR) != -1 || contents.indexOf(OR_STR) != -1) {
            return this.processComplexQuery(dataObject, reference, contents);
        }
        return this.processSimpleQuery(dataObject, reference, contents);
    }

    private Object processIndex(String xpFrag, DataObject dataObject, int idx, int idxValue) {
        try {
            Property prop = dataObject.getInstanceProperty(xpFrag.substring(0, idx));
            List dataObjects = dataObject.getList(prop);
            if (idxValue < dataObjects.size()) {
                return dataObjects.get(idxValue);
            }
            throw new IndexOutOfBoundsException();
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    private Object processComplexQuery(DataObject dataObject, String reference, String bracketContents) {
        ArrayList<DataObject> objects;
        OPStack opStack = new OPStack();
        List expressionParts = opStack.processExpression(bracketContents);
        ArrayList<Object> queryParts = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < expressionParts.size()) {
            Token tok = (Token)expressionParts.get(i2);
            if (tok.getName().equals(AND_STR) || tok.getName().equals(OR_STR)) {
                queryParts.add(tok.getName());
            } else {
                String propertyName = ((Token)expressionParts.get(i2)).getName();
                String queryValue = ((Token)expressionParts.get(++i2)).getName();
                int n2 = this.getOperandFromString(((Token)expressionParts.get(++i2)).getName());
                queryParts.add(new QueryPart(propertyName.trim(), queryValue, n2));
            }
            ++i2;
        }
        Property prop = dataObject.getInstanceProperty(reference);
        if (prop.isMany()) {
            objects = dataObject.getList(prop);
        } else {
            objects = new ArrayList<DataObject>();
            DataObject obj = dataObject.getDataObject(prop);
            if (obj != null) {
                objects.add(obj);
            }
        }
        ArrayList<SDODataObject> valuesToReturn = new ArrayList<SDODataObject>();
        for (SDODataObject sDODataObject : objects) {
            ArrayList booleanValues = new ArrayList();
            int j2 = 0;
            while (j2 < queryParts.size()) {
                if (queryParts.get(j2).equals(AND_STR) || queryParts.get(j2).equals(OR_STR)) {
                    booleanValues.add(queryParts.get(j2));
                } else {
                    QueryPart qp = (QueryPart)queryParts.get(j2);
                    booleanValues.add(qp.evaluate(sDODataObject));
                }
                ++j2;
            }
            int k2 = 0;
            while (k2 < booleanValues.size()) {
                if ((booleanValues.get(k2).equals(AND_STR) || booleanValues.get(k2).equals(OR_STR)) && k2 >= 2) {
                    Boolean b1 = (Boolean)booleanValues.get(k2 - 1);
                    Boolean b2 = (Boolean)booleanValues.get(k2 - 2);
                    int logicalOp = this.getOperandFromString((String)booleanValues.get(k2));
                    booleanValues.remove(k2);
                    booleanValues.remove(k2 - 1);
                    booleanValues.set(k2 - 2, this.evaluate(b1, b2, logicalOp));
                    k2 = 0;
                }
                ++k2;
            }
            if (booleanValues.size() != 1 || !((Boolean)booleanValues.get(0)).booleanValue()) continue;
            valuesToReturn.add(sDODataObject);
        }
        return valuesToReturn;
    }

    private boolean evaluate(boolean b1, boolean b2, int op) {
        switch (op) {
            case 10: {
                return b1 && b2;
            }
            case 11: {
                return b1 || b2;
            }
        }
        return false;
    }

    private Object processSimpleQuery(DataObject dataObject, String reference, String query) {
        ArrayList<DataObject> objects;
        Property prop = dataObject.getInstanceProperty(reference);
        if (prop.isMany()) {
            objects = dataObject.getList(prop);
        } else {
            objects = new ArrayList<DataObject>();
            DataObject obj = dataObject.getDataObject(prop);
            if (obj != null) {
                objects.add(obj);
            }
        }
        ArrayList<SDODataObject> valuesToReturn = new ArrayList<SDODataObject>();
        QueryPart queryPart = new QueryPart(query);
        for (SDODataObject sDODataObject : objects) {
            if (!queryPart.evaluate(sDODataObject)) continue;
            valuesToReturn.add(sDODataObject);
        }
        return valuesToReturn;
    }

    protected List addResultsToList(Object obj, List results) {
        if (obj != null) {
            if (obj instanceof List) {
                for (Object nextResult : (List)obj) {
                    if (nextResult == null) continue;
                    results.add(nextResult);
                }
            } else {
                results.add(obj);
            }
        }
        return results;
    }

    protected String getPathWithAtRemoved(String expression) {
        int index = expression.indexOf(64);
        if (index > -1) {
            if (index > 0) {
                StringBuffer sbuf = new StringBuffer(expression.substring(0, index));
                sbuf.append(expression.substring(index + 1, expression.length()));
                return sbuf.toString();
            }
            return expression.substring(index + 1, expression.length());
        }
        return expression;
    }

    protected String getPathWithPrefixRemoved(String expression) {
        int index = expression.indexOf(58);
        if (index > -1) {
            return expression.substring(index + 1, expression.length());
        }
        return expression;
    }

    private int getOperandFromString(String op) {
        if (op.equals(EQ_STR)) {
            return 8;
        }
        if (op.equals(NEQ_STR)) {
            return 9;
        }
        if (op.equals(GT_STR)) {
            return 6;
        }
        if (op.equals(LT_STR)) {
            return 7;
        }
        if (op.equals(GTE_STR)) {
            return 4;
        }
        if (op.equals(LTE_STR)) {
            return 5;
        }
        if (op.equals(AND_STR)) {
            return 10;
        }
        if (op.equals(OR_STR)) {
            return 11;
        }
        return -1;
    }

    private String getStringFromOperand(int op) {
        switch (op) {
            case 8: {
                return EQ_STR;
            }
            case 9: {
                return NEQ_STR;
            }
            case 4: {
                return GTE_STR;
            }
            case 5: {
                return LTE_STR;
            }
            case 6: {
                return GT_STR;
            }
            case 7: {
                return LT_STR;
            }
            case 10: {
                return AND_STR;
            }
            case 11: {
                return OR_STR;
            }
        }
        return "";
    }

    protected boolean shouldCallXPathEngine(String expression) {
        return false;
    }

    public class QueryPart {
        String propertyName;
        String queryValue;
        int relOperand;
        int logOperand;

        public QueryPart(String query) {
            this.processQueryContents(query);
        }

        public QueryPart(String property, String value, int op) {
            this.relOperand = op;
            this.propertyName = property;
            this.queryValue = this.formatValue(value);
        }

        private void processQueryContents(String query) {
            int idx = -1;
            int operandLen = 1;
            this.relOperand = 1;
            idx = query.indexOf(XPathHelper.GTE_STR);
            if (idx != -1) {
                this.relOperand = 4;
                operandLen = 2;
            } else {
                idx = query.indexOf(XPathHelper.LTE_STR);
                if (idx != -1) {
                    this.relOperand = 5;
                    operandLen = 2;
                } else {
                    idx = query.indexOf(XPathHelper.NEQ_STR);
                    if (idx != -1) {
                        this.relOperand = 9;
                        operandLen = 2;
                    } else {
                        idx = query.indexOf(XPathHelper.GT_STR);
                        if (idx != -1) {
                            this.relOperand = 6;
                        } else {
                            idx = query.indexOf(XPathHelper.LT_STR);
                            if (idx != -1) {
                                this.relOperand = 7;
                            } else {
                                idx = query.indexOf(XPathHelper.EQ_STR);
                                if (idx != -1) {
                                    this.relOperand = 8;
                                }
                            }
                        }
                    }
                }
            }
            this.propertyName = query.substring(0, idx).trim();
            this.queryValue = this.formatValue(query.substring(idx + operandLen));
        }

        private String formatValue(String value) {
            int openQIdx = value.indexOf(39);
            int closeQIdx = value.lastIndexOf(39);
            if (openQIdx == -1 && closeQIdx == -1) {
                openQIdx = value.indexOf("\"");
                closeQIdx = value.lastIndexOf("\"");
            }
            value = openQIdx != -1 && closeQIdx != -1 && openQIdx < closeQIdx ? value.substring(openQIdx + 1, closeQIdx) : value.trim();
            return value;
        }

        public boolean evaluate(SDODataObject dao) {
            List<Object> values;
            Object queryVal = this.queryValue;
            Object var3_3 = null;
            SDOProperty prop = dao.getInstanceProperty(this.propertyName);
            try {
                SDOXMLHelper sdoXMLHelper = (SDOXMLHelper)dao.getType().getHelperContext().getXMLHelper();
                queryVal = sdoXMLHelper.getXmlConversionManager().convertObject(this.queryValue, prop.getType().getInstanceClass());
            }
            catch (ConversionException sdoXMLHelper) {
                // empty catch block
            }
            if (!prop.isMany()) {
                values = new ArrayList();
                values.add(dao.get(prop));
            } else {
                values = dao.getList(prop);
            }
            for (Object e2 : values) {
                int resultOfComparison;
                if (e2 == null) continue;
                try {
                    resultOfComparison = ((Comparable)e2).compareTo(queryVal);
                }
                catch (Exception x2) {
                    continue;
                }
                switch (this.relOperand) {
                    case 8: {
                        if (resultOfComparison != 0) break;
                        return true;
                    }
                    case 9: {
                        if (resultOfComparison == 0) break;
                        return true;
                    }
                    case 4: {
                        if (resultOfComparison < 0) break;
                        return true;
                    }
                    case 5: {
                        if (resultOfComparison > 0) break;
                        return true;
                    }
                    case 6: {
                        if (resultOfComparison <= 0) break;
                        return true;
                    }
                    case 7: {
                        if (resultOfComparison >= 0) break;
                        return true;
                    }
                }
            }
            return false;
        }

        public String toString() {
            return "QueryPart {" + this.propertyName + " " + XPathHelper.this.getStringFromOperand(this.relOperand) + " " + this.queryValue + "}";
        }
    }
}

