/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;
import org.eclipse.persistence.sdo.types.SDOChangeSummaryType;
import org.eclipse.persistence.sdo.types.SDODataObjectType;
import org.eclipse.persistence.sdo.types.SDODataType;
import org.eclipse.persistence.sdo.types.SDOOpenSequencedType;
import org.eclipse.persistence.sdo.types.SDOTypeType;
import org.eclipse.persistence.sdo.types.SDOWrapperType;
import org.eclipse.persistence.sdo.types.SDOXMLHelperLoadOptionsType;
import org.eclipse.persistence.sessions.Project;

public class SDOTypeHelperDelegate
implements SDOTypeHelper {
    private static final Logger LOGGER = Logger.getLogger(SDOTypeHelperDelegate.class.getName());
    private Map typesHashMap;
    private Map<QName, SDOType> wrappersHashMap;
    private Map<Class, SDOType> interfacesToSDOTypeHashMap;
    private Map<Class, SDOType> implClassesToSDOType = new HashMap<Class, SDOType>();
    private final Map commonjHashMap = new HashMap();
    private final Map commonjJavaHashMap = new HashMap();
    private static final Map sdoTypeForSimpleJavaType = new HashMap(22);
    private final Map sdoToXSDTypes = new HashMap(34);
    private final Map xsdToSDOType = new HashMap(46);
    private Map openContentProperties;
    private List anonymousTypes;
    private HelperContext aHelperContext;
    private NamespaceResolver namespaceResolver;
    private SDOWrapperType SDO_BOOLEAN_WRAPPER;
    private SDOWrapperType SDO_BYTE_WRAPPER;
    private SDOWrapperType SDO_BYTES_WRAPPER;
    private SDOWrapperType SDO_CHARACTER_WRAPPER;
    private SDOWrapperType SDO_DATE_WRAPPER;
    private SDOWrapperType SDO_DATETIME_WRAPPER;
    private SDOWrapperType SDO_DAY_WRAPPER;
    private SDOWrapperType SDO_DECIMAL_WRAPPER;
    private SDOWrapperType SDO_DOUBLE_WRAPPER;
    private SDOWrapperType SDO_DURATION_WRAPPER;
    private SDOWrapperType SDO_FLOAT_WRAPPER;
    private SDOWrapperType SDO_INT_WRAPPER;
    private SDOWrapperType SDO_INTEGER_WRAPPER;
    private SDOWrapperType SDO_LONG_WRAPPER;
    private SDOWrapperType SDO_MONTH_WRAPPER;
    private SDOWrapperType SDO_MONTHDAY_WRAPPER;
    private SDOWrapperType SDO_OBJECT_WRAPPER;
    private SDOWrapperType SDO_SHORT_WRAPPER;
    private SDOWrapperType SDO_STRING_WRAPPER;
    private SDOWrapperType SDO_STRINGS_WRAPPER;
    private SDOWrapperType SDO_TIME_WRAPPER;
    private SDOWrapperType SDO_URI_WRAPPER;
    private SDOWrapperType SDO_YEAR_WRAPPER;
    private SDOWrapperType SDO_YEARMONTH_WRAPPER;
    private SDOWrapperType SDO_YEARMONTHDAY_WRAPPER;
    private SDOWrapperType SDO_BOOLEANOBJECT_WRAPPER;
    private SDOWrapperType SDO_BYTEOBJECT_WRAPPER;
    private SDOWrapperType SDO_CHARACTEROBJECT_WRAPPER;
    private SDOWrapperType SDO_DOUBLEOBJECT_WRAPPER;
    private SDOWrapperType SDO_FLOATOBJECT_WRAPPER;
    private SDOWrapperType SDO_INTOBJECT_WRAPPER;
    private SDOWrapperType SDO_LONGOBJECT_WRAPPER;
    private SDOWrapperType SDO_SHORTOBJECT_WRAPPER;
    private static final String[] SEARCH_SOURCES_NAMES = new String[]{"interfacesToSDOTypeHashMap", "sdoTypeForSimpleJavaType", "typesHashMap", "anonymousTypes", "commonjHashMap"};
    private static final String XML_NAME_VALIDATION_ENABLED_PROPERTY_NAME = "eclipselink.sdo.dynamic.type.names.validation";
    private final boolean isXmlNameValidationEnabled = PrivilegedAccessHelper.getSystemPropertyBoolean("eclipselink.sdo.dynamic.type.names.validation", true);

    static {
        SDOTypeHelperDelegate.initSDOTypeForSimpleJavaTypeMap();
    }

    public SDOTypeHelperDelegate(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.initCommonjHashMap();
        this.initCommonjJavaHashMap();
        this.reset();
    }

    public void initWrapperTypes() {
        Map<SDOWrapperTypeId, SDOWrapperType> sdoWrapperTypes = SDOHelperContext.getWrapperTypes();
        if (sdoWrapperTypes == null) {
            sdoWrapperTypes = new HashMap<SDOWrapperTypeId, SDOWrapperType>();
            this.SDO_BOOLEAN_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BOOLEAN, "Boolean", (SDOTypeHelper)this, XMLConstants.BOOLEAN_QNAME, SDOWrapperType.BooleanWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_BOOLEAN_WRAPPER, this.SDO_BOOLEAN_WRAPPER);
            this.SDO_BYTE_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BYTE, "Byte", (SDOTypeHelper)this, XMLConstants.BYTE_QNAME, SDOWrapperType.ByteWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_BYTE_WRAPPER, this.SDO_BYTE_WRAPPER);
            this.SDO_BYTES_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BYTES, "Bytes", (SDOTypeHelper)this, new QName[]{XMLConstants.BASE_64_BINARY_QNAME, XMLConstants.HEX_BINARY_QNAME}, new Class[]{SDOWrapperType.BytesWrapperImpl.class, SDOWrapperType.Bytes_hexBunaryWrapperImpl.class});
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_BYTES_WRAPPER, this.SDO_BYTES_WRAPPER);
            this.SDO_CHARACTER_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_CHARACTER, "Character", (SDOTypeHelper)this, XMLConstants.STRING_QNAME, SDOWrapperType.CharacterWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_CHARACTER_WRAPPER, this.SDO_CHARACTER_WRAPPER);
            this.SDO_DATE_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DATE, "Date", (SDOTypeHelper)this, XMLConstants.DATE_QNAME, SDOWrapperType.DateWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_DATE_WRAPPER, this.SDO_DATE_WRAPPER);
            this.SDO_DATETIME_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DATETIME, "DateTime", (SDOTypeHelper)this, XMLConstants.DATE_TIME_QNAME, SDOWrapperType.DateTimeWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_DATETIME_WRAPPER, this.SDO_DATETIME_WRAPPER);
            this.SDO_DAY_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DAY, "Day", (SDOTypeHelper)this, XMLConstants.G_DAY_QNAME, SDOWrapperType.DayWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_DAY_WRAPPER, this.SDO_DAY_WRAPPER);
            this.SDO_DECIMAL_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DECIMAL, "Decimal", (SDOTypeHelper)this, XMLConstants.DECIMAL_QNAME, SDOWrapperType.DecimalWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_DECIMAL_WRAPPER, this.SDO_DECIMAL_WRAPPER);
            this.SDO_DOUBLE_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DOUBLE, "Double", (SDOTypeHelper)this, XMLConstants.DOUBLE_QNAME, SDOWrapperType.DoubleWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_DOUBLE_WRAPPER, this.SDO_DOUBLE_WRAPPER);
            this.SDO_DURATION_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DURATION, "Duration", (SDOTypeHelper)this, XMLConstants.DURATION_QNAME, SDOWrapperType.DurationWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_DURATION_WRAPPER, this.SDO_DURATION_WRAPPER);
            this.SDO_FLOAT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_FLOAT, "Float", (SDOTypeHelper)this, XMLConstants.FLOAT_QNAME, SDOWrapperType.FloatWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_FLOAT_WRAPPER, this.SDO_FLOAT_WRAPPER);
            this.SDO_INT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_INT, "Int", (SDOTypeHelper)this, XMLConstants.INT_QNAME, SDOWrapperType.IntWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_INT_WRAPPER, this.SDO_INT_WRAPPER);
            this.SDO_INTEGER_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_INTEGER, "Integer", (SDOTypeHelper)this, XMLConstants.INTEGER_QNAME, SDOWrapperType.IntegerWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_INTEGER_WRAPPER, this.SDO_INTEGER_WRAPPER);
            this.SDO_LONG_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_LONG, "Long", (SDOTypeHelper)this, XMLConstants.LONG_QNAME, SDOWrapperType.LongWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_LONG_WRAPPER, this.SDO_LONG_WRAPPER);
            this.SDO_MONTH_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_MONTH, "Month", (SDOTypeHelper)this, XMLConstants.G_MONTH_QNAME, SDOWrapperType.MonthWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_MONTH_WRAPPER, this.SDO_MONTH_WRAPPER);
            this.SDO_MONTHDAY_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_MONTHDAY, "MonthDay", (SDOTypeHelper)this, XMLConstants.G_MONTH_DAY_QNAME, SDOWrapperType.MonthDayWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_MONTHDAY_WRAPPER, this.SDO_MONTHDAY_WRAPPER);
            this.SDO_OBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_OBJECT, "Object", (SDOTypeHelper)this, XMLConstants.ANY_SIMPLE_TYPE_QNAME, SDOWrapperType.ObjectWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_OBJECT_WRAPPER, this.SDO_OBJECT_WRAPPER);
            this.SDO_SHORT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_SHORT, "Short", (SDOTypeHelper)this, XMLConstants.SHORT_QNAME, SDOWrapperType.ShortWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_SHORT_WRAPPER, this.SDO_SHORT_WRAPPER);
            this.SDO_STRING_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_STRING, "String", (SDOTypeHelper)this, XMLConstants.STRING_QNAME, SDOWrapperType.StringWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_STRING_WRAPPER, this.SDO_STRING_WRAPPER);
            this.SDO_STRINGS_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_STRINGS, "Strings", (SDOTypeHelper)this, XMLConstants.STRING_QNAME, SDOWrapperType.StringsWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_STRINGS_WRAPPER, this.SDO_STRINGS_WRAPPER);
            this.SDO_TIME_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_TIME, "Time", (SDOTypeHelper)this, XMLConstants.TIME_QNAME, SDOWrapperType.TimeWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_TIME_WRAPPER, this.SDO_TIME_WRAPPER);
            this.SDO_URI_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_URI, "URI", (SDOTypeHelper)this, new QName[]{XMLConstants.ANY_URI_QNAME, XMLConstants.QNAME_QNAME}, new Class[]{SDOWrapperType.URIWrapperImpl.class, SDOWrapperType.URI_QNameWrapperImpl.class});
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_URI_WRAPPER, this.SDO_URI_WRAPPER);
            this.SDO_YEAR_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_YEAR, "Year", (SDOTypeHelper)this, XMLConstants.G_YEAR_QNAME, SDOWrapperType.YearWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_YEAR_WRAPPER, this.SDO_YEAR_WRAPPER);
            this.SDO_YEARMONTH_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_YEARMONTH, "YearMonth", (SDOTypeHelper)this, XMLConstants.G_YEAR_MONTH_QNAME, SDOWrapperType.YearMonthWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_YEARMONTH_WRAPPER, this.SDO_YEARMONTH_WRAPPER);
            this.SDO_YEARMONTHDAY_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_YEARMONTHDAY, "YearMonthDay", (SDOTypeHelper)this, XMLConstants.DATE_QNAME, SDOWrapperType.YearMonthDayWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_YEARMONTHDAY_WRAPPER, this.SDO_YEARMONTHDAY_WRAPPER);
            this.SDO_BOOLEANOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BOOLEANOBJECT, "BooleanObject", (SDOTypeHelper)this, XMLConstants.BOOLEAN_QNAME, SDOWrapperType.BooleanObjectWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_BOOLEANOBJECT_WRAPPER, this.SDO_BOOLEANOBJECT_WRAPPER);
            this.SDO_BYTEOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_BYTEOBJECT, "ByteObject", (SDOTypeHelper)this, XMLConstants.BYTE_QNAME, SDOWrapperType.ByteObjectWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_BYTEOBJECT_WRAPPER, this.SDO_BYTEOBJECT_WRAPPER);
            this.SDO_CHARACTEROBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_CHARACTEROBJECT, "CharacterObject", (SDOTypeHelper)this, XMLConstants.STRING_QNAME, SDOWrapperType.CharacterObjectWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_CHARACTEROBJECT_WRAPPER, this.SDO_CHARACTEROBJECT_WRAPPER);
            this.SDO_DOUBLEOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_DOUBLEOBJECT, "DoubleObject", (SDOTypeHelper)this, XMLConstants.DOUBLE_QNAME, SDOWrapperType.DoubleObjectWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_DOUBLEOBJECT_WRAPPER, this.SDO_DOUBLEOBJECT_WRAPPER);
            this.SDO_FLOATOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_FLOATOBJECT, "FloatObject", (SDOTypeHelper)this, XMLConstants.FLOAT_QNAME, SDOWrapperType.FloatObjectWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_FLOATOBJECT_WRAPPER, this.SDO_FLOATOBJECT_WRAPPER);
            this.SDO_INTOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_INTOBJECT, "IntObject", (SDOTypeHelper)this, XMLConstants.INT_QNAME, SDOWrapperType.IntObjectWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_INTOBJECT_WRAPPER, this.SDO_INTOBJECT_WRAPPER);
            this.SDO_LONGOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_LONGOBJECT, "LongObject", (SDOTypeHelper)this, XMLConstants.LONG_QNAME, SDOWrapperType.LongObjectWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_LONGOBJECT_WRAPPER, this.SDO_LONGOBJECT_WRAPPER);
            this.SDO_SHORTOBJECT_WRAPPER = new SDOWrapperType((Type)SDOConstants.SDO_SHORTOBJECT, "ShortObject", (SDOTypeHelper)this, XMLConstants.SHORT_QNAME, SDOWrapperType.ShortObjectWrapperImpl.class);
            sdoWrapperTypes.put(SDOWrapperTypeId.SDO_SHORTOBJECT_WRAPPER, this.SDO_SHORTOBJECT_WRAPPER);
            SDOHelperContext.putWrapperTypes(sdoWrapperTypes);
        } else {
            this.SDO_BOOLEAN_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_BOOLEAN_WRAPPER);
            this.SDO_BYTE_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_BYTE_WRAPPER);
            this.SDO_BYTES_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_BYTES_WRAPPER);
            this.SDO_CHARACTER_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_CHARACTER_WRAPPER);
            this.SDO_DATE_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_DATE_WRAPPER);
            this.SDO_DATETIME_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_DATETIME_WRAPPER);
            this.SDO_DAY_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_DAY_WRAPPER);
            this.SDO_DECIMAL_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_DECIMAL_WRAPPER);
            this.SDO_DOUBLE_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_DOUBLE_WRAPPER);
            this.SDO_DURATION_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_DURATION_WRAPPER);
            this.SDO_FLOAT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_FLOAT_WRAPPER);
            this.SDO_INT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_INT_WRAPPER);
            this.SDO_INTEGER_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_INTEGER_WRAPPER);
            this.SDO_LONG_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_LONG_WRAPPER);
            this.SDO_MONTH_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_MONTH_WRAPPER);
            this.SDO_MONTHDAY_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_MONTHDAY_WRAPPER);
            this.SDO_OBJECT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_OBJECT_WRAPPER);
            this.SDO_SHORT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_SHORT_WRAPPER);
            this.SDO_STRING_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_STRING_WRAPPER);
            this.SDO_STRINGS_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_STRINGS_WRAPPER);
            this.SDO_TIME_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_TIME_WRAPPER);
            this.SDO_URI_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_URI_WRAPPER);
            this.SDO_YEAR_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_YEAR_WRAPPER);
            this.SDO_YEARMONTH_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_YEARMONTH_WRAPPER);
            this.SDO_YEARMONTHDAY_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_YEARMONTHDAY_WRAPPER);
            this.SDO_BOOLEANOBJECT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_BOOLEANOBJECT_WRAPPER);
            this.SDO_BYTEOBJECT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_BYTEOBJECT_WRAPPER);
            this.SDO_CHARACTEROBJECT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_CHARACTEROBJECT_WRAPPER);
            this.SDO_DOUBLEOBJECT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_DOUBLEOBJECT_WRAPPER);
            this.SDO_FLOATOBJECT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_FLOATOBJECT_WRAPPER);
            this.SDO_INTOBJECT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_INTOBJECT_WRAPPER);
            this.SDO_LONGOBJECT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_LONGOBJECT_WRAPPER);
            this.SDO_SHORTOBJECT_WRAPPER = sdoWrapperTypes.get((Object)SDOWrapperTypeId.SDO_SHORTOBJECT_WRAPPER);
        }
    }

    @Override
    public void addWrappersToProject(Project project) {
        this.SDO_BOOLEAN_WRAPPER.addDescriptorToProject(project);
        this.SDO_BYTE_WRAPPER.addDescriptorToProject(project);
        this.SDO_BYTES_WRAPPER.addDescriptorToProject(project);
        this.SDO_CHARACTER_WRAPPER.addDescriptorToProject(project);
        this.SDO_DATE_WRAPPER.addDescriptorToProject(project);
        this.SDO_DAY_WRAPPER.addDescriptorToProject(project);
        this.SDO_DECIMAL_WRAPPER.addDescriptorToProject(project);
        this.SDO_DOUBLE_WRAPPER.addDescriptorToProject(project);
        this.SDO_DURATION_WRAPPER.addDescriptorToProject(project);
        this.SDO_FLOAT_WRAPPER.addDescriptorToProject(project);
        this.SDO_INT_WRAPPER.addDescriptorToProject(project);
        this.SDO_INTEGER_WRAPPER.addDescriptorToProject(project);
        this.SDO_LONG_WRAPPER.addDescriptorToProject(project);
        this.SDO_MONTH_WRAPPER.addDescriptorToProject(project);
        this.SDO_MONTHDAY_WRAPPER.addDescriptorToProject(project);
        this.SDO_OBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_SHORT_WRAPPER.addDescriptorToProject(project);
        this.SDO_STRINGS_WRAPPER.addDescriptorToProject(project);
        this.SDO_TIME_WRAPPER.addDescriptorToProject(project);
        this.SDO_URI_WRAPPER.addDescriptorToProject(project);
        this.SDO_YEAR_WRAPPER.addDescriptorToProject(project);
        this.SDO_YEARMONTH_WRAPPER.addDescriptorToProject(project);
        this.SDO_YEARMONTHDAY_WRAPPER.addDescriptorToProject(project);
        this.SDO_STRING_WRAPPER.addDescriptorToProject(project);
        this.SDO_DATETIME_WRAPPER.addDescriptorToProject(project);
        this.SDO_BOOLEANOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_BYTEOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_CHARACTEROBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_DOUBLEOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_FLOATOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_INTOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_LONGOBJECT_WRAPPER.addDescriptorToProject(project);
        this.SDO_SHORTOBJECT_WRAPPER.addDescriptorToProject(project);
    }

    private void initCommonjHashMap() {
        this.commonjHashMap.put("Boolean", SDOConstants.SDO_BOOLEAN);
        this.commonjHashMap.put("Byte", SDOConstants.SDO_BYTE);
        this.commonjHashMap.put("Bytes", SDOConstants.SDO_BYTES);
        this.commonjHashMap.put("Character", SDOConstants.SDO_CHARACTER);
        SDODataObjectType dataObjectType = new SDODataObjectType(this);
        this.commonjHashMap.put(((SDOType)dataObjectType).getName(), dataObjectType);
        this.commonjHashMap.put("Date", SDOConstants.SDO_DATE);
        this.commonjHashMap.put("DateTime", SDOConstants.SDO_DATETIME);
        this.commonjHashMap.put("Day", SDOConstants.SDO_DAY);
        this.commonjHashMap.put("Decimal", SDOConstants.SDO_DECIMAL);
        this.commonjHashMap.put("Double", SDOConstants.SDO_DOUBLE);
        this.commonjHashMap.put("Duration", SDOConstants.SDO_DURATION);
        this.commonjHashMap.put("Float", SDOConstants.SDO_FLOAT);
        this.commonjHashMap.put("Int", SDOConstants.SDO_INT);
        this.commonjHashMap.put("Integer", SDOConstants.SDO_INTEGER);
        this.commonjHashMap.put("Long", SDOConstants.SDO_LONG);
        this.commonjHashMap.put("Month", SDOConstants.SDO_MONTH);
        this.commonjHashMap.put("MonthDay", SDOConstants.SDO_MONTHDAY);
        this.commonjHashMap.put("Object", SDOConstants.SDO_OBJECT);
        this.commonjHashMap.put("Short", SDOConstants.SDO_SHORT);
        this.commonjHashMap.put("String", SDOConstants.SDO_STRING);
        this.commonjHashMap.put("Strings", SDOConstants.SDO_STRINGS);
        this.commonjHashMap.put("Time", SDOConstants.SDO_TIME);
        this.commonjHashMap.put("Year", SDOConstants.SDO_YEAR);
        this.commonjHashMap.put("YearMonth", SDOConstants.SDO_YEARMONTH);
        this.commonjHashMap.put("YearMonthDay", SDOConstants.SDO_YEARMONTHDAY);
        this.commonjHashMap.put("URI", SDOConstants.SDO_URI);
        SDOChangeSummaryType changeSummaryType = new SDOChangeSummaryType(this);
        this.commonjHashMap.put(((SDOType)changeSummaryType).getName(), changeSummaryType);
        SDOTypeType typeType = new SDOTypeType(this);
        this.commonjHashMap.put(((SDOType)typeType).getName(), typeType);
    }

    private void initCommonjJavaHashMap() {
        this.commonjJavaHashMap.put("BooleanObject", SDOConstants.SDO_BOOLEANOBJECT);
        this.commonjJavaHashMap.put("ByteObject", SDOConstants.SDO_BYTEOBJECT);
        this.commonjJavaHashMap.put("CharacterObject", SDOConstants.SDO_CHARACTEROBJECT);
        this.commonjJavaHashMap.put("DoubleObject", SDOConstants.SDO_DOUBLEOBJECT);
        this.commonjJavaHashMap.put("FloatObject", SDOConstants.SDO_FLOATOBJECT);
        this.commonjJavaHashMap.put("IntObject", SDOConstants.SDO_INTOBJECT);
        this.commonjJavaHashMap.put("LongObject", SDOConstants.SDO_LONGOBJECT);
        this.commonjJavaHashMap.put("ShortObject", SDOConstants.SDO_SHORTOBJECT);
    }

    private void initTypesHashMap() {
        this.typesHashMap = new HashMap();
        SDOType typeType = this.getType("commonj.sdo", "Type");
        SDOXMLHelperLoadOptionsType xmlHelperLoadOptionsType = new SDOXMLHelperLoadOptionsType((SDOTypeHelper)this, typeType);
        this.typesHashMap.put(xmlHelperLoadOptionsType.getQName(), xmlHelperLoadOptionsType);
        SDOOpenSequencedType openSequencedType = new SDOOpenSequencedType(this);
        this.typesHashMap.put(openSequencedType.getQName(), openSequencedType);
        this.implClassesToSDOType.put(openSequencedType.getImplClass(), openSequencedType);
        this.typesHashMap.put(this.SDO_BOOLEAN_WRAPPER.getQName(), this.SDO_BOOLEAN_WRAPPER);
        this.typesHashMap.put(this.SDO_BYTE_WRAPPER.getQName(), this.SDO_BYTE_WRAPPER);
        this.typesHashMap.put(this.SDO_BYTES_WRAPPER.getQName(), this.SDO_BYTES_WRAPPER);
        this.typesHashMap.put(this.SDO_CHARACTER_WRAPPER.getQName(), this.SDO_CHARACTER_WRAPPER);
        this.typesHashMap.put(this.SDO_DATE_WRAPPER.getQName(), this.SDO_DATE_WRAPPER);
        this.typesHashMap.put(this.SDO_DATETIME_WRAPPER.getQName(), this.SDO_DATETIME_WRAPPER);
        this.typesHashMap.put(this.SDO_DAY_WRAPPER.getQName(), this.SDO_DAY_WRAPPER);
        this.typesHashMap.put(this.SDO_DECIMAL_WRAPPER.getQName(), this.SDO_DECIMAL_WRAPPER);
        this.typesHashMap.put(this.SDO_DOUBLE_WRAPPER.getQName(), this.SDO_DOUBLE_WRAPPER);
        this.typesHashMap.put(this.SDO_DURATION_WRAPPER.getQName(), this.SDO_DURATION_WRAPPER);
        this.typesHashMap.put(this.SDO_FLOAT_WRAPPER.getQName(), this.SDO_FLOAT_WRAPPER);
        this.typesHashMap.put(this.SDO_INT_WRAPPER.getQName(), this.SDO_INT_WRAPPER);
        this.typesHashMap.put(this.SDO_INTEGER_WRAPPER.getQName(), this.SDO_INTEGER_WRAPPER);
        this.typesHashMap.put(this.SDO_LONG_WRAPPER.getQName(), this.SDO_LONG_WRAPPER);
        this.typesHashMap.put(this.SDO_MONTH_WRAPPER.getQName(), this.SDO_MONTH_WRAPPER);
        this.typesHashMap.put(this.SDO_MONTHDAY_WRAPPER.getQName(), this.SDO_MONTHDAY_WRAPPER);
        this.typesHashMap.put(this.SDO_OBJECT_WRAPPER.getQName(), this.SDO_OBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_SHORT_WRAPPER.getQName(), this.SDO_SHORT_WRAPPER);
        this.typesHashMap.put(this.SDO_STRING_WRAPPER.getQName(), this.SDO_STRING_WRAPPER);
        this.typesHashMap.put(this.SDO_STRINGS_WRAPPER.getQName(), this.SDO_STRINGS_WRAPPER);
        this.typesHashMap.put(this.SDO_TIME_WRAPPER.getQName(), this.SDO_TIME_WRAPPER);
        this.typesHashMap.put(this.SDO_URI_WRAPPER.getQName(), this.SDO_URI_WRAPPER);
        this.typesHashMap.put(this.SDO_YEAR_WRAPPER.getQName(), this.SDO_YEAR_WRAPPER);
        this.typesHashMap.put(this.SDO_YEARMONTH_WRAPPER.getQName(), this.SDO_YEARMONTH_WRAPPER);
        this.typesHashMap.put(this.SDO_YEARMONTHDAY_WRAPPER.getQName(), this.SDO_YEARMONTHDAY_WRAPPER);
        this.typesHashMap.put(this.SDO_BOOLEANOBJECT_WRAPPER.getQName(), this.SDO_BOOLEANOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_BYTEOBJECT_WRAPPER.getQName(), this.SDO_BYTEOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_CHARACTEROBJECT_WRAPPER.getQName(), this.SDO_CHARACTEROBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_DOUBLEOBJECT_WRAPPER.getQName(), this.SDO_DOUBLEOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_FLOATOBJECT_WRAPPER.getQName(), this.SDO_FLOATOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_INTOBJECT_WRAPPER.getQName(), this.SDO_INTOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_LONGOBJECT_WRAPPER.getQName(), this.SDO_LONGOBJECT_WRAPPER);
        this.typesHashMap.put(this.SDO_SHORTOBJECT_WRAPPER.getQName(), this.SDO_SHORTOBJECT_WRAPPER);
    }

    private void initWrappersHashMap() {
        this.wrappersHashMap = new HashMap<QName, SDOType>();
        this.wrappersHashMap.put(SDOConstants.SDO_BOOLEAN.getQName(), this.SDO_BOOLEAN_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BYTE.getQName(), this.SDO_BYTE_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BYTES.getQName(), this.SDO_BYTES_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_CHARACTER.getQName(), this.SDO_CHARACTER_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DATE.getQName(), this.SDO_DATE_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DATETIME.getQName(), this.SDO_DATETIME_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DAY.getQName(), this.SDO_DAY_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DECIMAL.getQName(), this.SDO_DECIMAL_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DOUBLE.getQName(), this.SDO_DOUBLE_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DURATION.getQName(), this.SDO_DURATION_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_FLOAT.getQName(), this.SDO_FLOAT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_INT.getQName(), this.SDO_INT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_INTEGER.getQName(), this.SDO_INTEGER_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_LONG.getQName(), this.SDO_LONG_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_MONTH.getQName(), this.SDO_MONTH_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_MONTHDAY.getQName(), this.SDO_MONTHDAY_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_OBJECT.getQName(), this.SDO_OBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_SHORT.getQName(), this.SDO_SHORT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_STRING.getQName(), this.SDO_STRING_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_STRINGS.getQName(), this.SDO_STRINGS_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_TIME.getQName(), this.SDO_TIME_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_URI.getQName(), this.SDO_URI_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_YEAR.getQName(), this.SDO_YEAR_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_YEARMONTH.getQName(), this.SDO_YEARMONTH_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_YEARMONTHDAY.getQName(), this.SDO_YEARMONTHDAY_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BOOLEANOBJECT.getQName(), this.SDO_BOOLEANOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_BYTEOBJECT.getQName(), this.SDO_BYTEOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_CHARACTEROBJECT.getQName(), this.SDO_CHARACTEROBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_DOUBLEOBJECT.getQName(), this.SDO_DOUBLEOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_FLOATOBJECT.getQName(), this.SDO_FLOATOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_INTOBJECT.getQName(), this.SDO_INTOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_LONGOBJECT.getQName(), this.SDO_LONGOBJECT_WRAPPER);
        this.wrappersHashMap.put(SDOConstants.SDO_SHORTOBJECT.getQName(), this.SDO_SHORTOBJECT_WRAPPER);
        for (SDOWrapperType sDOWrapperType : this.wrappersHashMap.values()) {
            for (XMLDescriptor d2 : sDOWrapperType.getDescriptorsMap().values()) {
                this.implClassesToSDOType.put(d2.getJavaClass(), sDOWrapperType);
            }
        }
    }

    private void initSdoToXSDType() {
        this.sdoToXSDTypes.put(SDOConstants.SDO_BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BYTE, XMLConstants.BYTE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BYTES, XMLConstants.HEX_BINARY_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_CHARACTER, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DATE, XMLConstants.DATE_TIME_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DATETIME, XMLConstants.DATE_TIME_QNAME);
        SDOType dataObjectType = this.getType("commonj.sdo", "DataObject");
        this.sdoToXSDTypes.put(dataObjectType, SDOConstants.ANY_TYPE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DAY, SDOConstants.GDAY_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DECIMAL, XMLConstants.DECIMAL_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DOUBLE, XMLConstants.DOUBLE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DURATION, SDOConstants.DURATION_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_FLOAT, XMLConstants.FLOAT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_INT, XMLConstants.INT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_INTEGER, XMLConstants.INTEGER_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_LONG, XMLConstants.LONG_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_MONTH, SDOConstants.GMONTH_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_MONTHDAY, SDOConstants.GMONTHDAY_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_OBJECT, XMLConstants.ANY_SIMPLE_TYPE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_SHORT, XMLConstants.SHORT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_STRING, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_STRINGS, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_TIME, XMLConstants.TIME_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_YEAR, SDOConstants.GYEAR_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_YEARMONTH, SDOConstants.GYEARMONTH_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_YEARMONTHDAY, XMLConstants.DATE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_URI, SDOConstants.ANY_URI_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BOOLEANOBJECT, XMLConstants.BOOLEAN_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_BYTEOBJECT, XMLConstants.BYTE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_CHARACTEROBJECT, XMLConstants.STRING_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_DOUBLEOBJECT, XMLConstants.DOUBLE_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_FLOATOBJECT, XMLConstants.FLOAT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_INTOBJECT, XMLConstants.INT_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_LONGOBJECT, XMLConstants.LONG_QNAME);
        this.sdoToXSDTypes.put(SDOConstants.SDO_SHORTOBJECT, XMLConstants.SHORT_QNAME);
    }

    private void initXsdToSDOType() {
        this.xsdToSDOType.put(XMLConstants.ANY_SIMPLE_TYPE_QNAME, SDOConstants.SDO_OBJECT);
        SDOType dataObjectType = this.getType("commonj.sdo", "DataObject");
        this.xsdToSDOType.put(SDOConstants.ANY_TYPE_QNAME, dataObjectType);
        this.xsdToSDOType.put(SDOConstants.ANY_URI_QNAME, SDOConstants.SDO_URI);
        this.xsdToSDOType.put(XMLConstants.BASE_64_BINARY_QNAME, SDOConstants.SDO_BYTES);
        this.xsdToSDOType.put(XMLConstants.BOOLEAN_QNAME, SDOConstants.SDO_BOOLEAN);
        this.xsdToSDOType.put(XMLConstants.BYTE_QNAME, SDOConstants.SDO_BYTE);
        this.xsdToSDOType.put(XMLConstants.DATE_QNAME, SDOConstants.SDO_YEARMONTHDAY);
        this.xsdToSDOType.put(XMLConstants.DATE_TIME_QNAME, SDOConstants.SDO_DATETIME);
        this.xsdToSDOType.put(XMLConstants.DECIMAL_QNAME, SDOConstants.SDO_DECIMAL);
        this.xsdToSDOType.put(XMLConstants.DOUBLE_QNAME, SDOConstants.SDO_DOUBLE);
        this.xsdToSDOType.put(SDOConstants.DURATION_QNAME, SDOConstants.SDO_DURATION);
        this.xsdToSDOType.put(SDOConstants.ENTITIES_QNAME, SDOConstants.SDO_STRINGS);
        this.xsdToSDOType.put(SDOConstants.ENTITY_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.FLOAT_QNAME, SDOConstants.SDO_FLOAT);
        this.xsdToSDOType.put(SDOConstants.GDAY_QNAME, SDOConstants.SDO_DAY);
        this.xsdToSDOType.put(SDOConstants.GMONTH_QNAME, SDOConstants.SDO_MONTH);
        this.xsdToSDOType.put(SDOConstants.GMONTHDAY_QNAME, SDOConstants.SDO_MONTHDAY);
        this.xsdToSDOType.put(SDOConstants.GYEAR_QNAME, SDOConstants.SDO_YEAR);
        this.xsdToSDOType.put(SDOConstants.GYEARMONTH_QNAME, SDOConstants.SDO_YEARMONTH);
        this.xsdToSDOType.put(XMLConstants.HEX_BINARY_QNAME, SDOConstants.SDO_BYTES);
        this.xsdToSDOType.put(SDOConstants.ID_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.IDREF_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.IDREFS_QNAME, SDOConstants.SDO_STRINGS);
        this.xsdToSDOType.put(XMLConstants.INT_QNAME, SDOConstants.SDO_INT);
        this.xsdToSDOType.put(XMLConstants.INTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.LANGUAGE_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.LONG_QNAME, SDOConstants.SDO_LONG);
        this.xsdToSDOType.put(SDOConstants.NAME_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NCNAME_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NEGATIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.NMTOKEN_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NMTOKENS_QNAME, SDOConstants.SDO_STRINGS);
        this.xsdToSDOType.put(SDOConstants.NONNEGATIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.NONPOSITIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(SDOConstants.NORMALIZEDSTRING_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.NOTATION_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(SDOConstants.POSITIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(XMLConstants.QNAME_QNAME, SDOConstants.SDO_URI);
        this.xsdToSDOType.put(XMLConstants.SHORT_QNAME, SDOConstants.SDO_SHORT);
        this.xsdToSDOType.put(XMLConstants.STRING_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.TIME_QNAME, SDOConstants.SDO_TIME);
        this.xsdToSDOType.put(SDOConstants.TOKEN_QNAME, SDOConstants.SDO_STRING);
        this.xsdToSDOType.put(XMLConstants.UNSIGNED_BYTE_QNAME, SDOConstants.SDO_SHORT);
        this.xsdToSDOType.put(XMLConstants.UNSIGNED_INT_QNAME, SDOConstants.SDO_LONG);
        this.xsdToSDOType.put(SDOConstants.UNSIGNEDLONG_QNAME, SDOConstants.SDO_INTEGER);
        this.xsdToSDOType.put(XMLConstants.UNSIGNED_SHORT_QNAME, SDOConstants.SDO_INT);
    }

    private static void initSDOTypeForSimpleJavaTypeMap() {
        sdoTypeForSimpleJavaType.put(ClassConstants.STRING, SDOConstants.SDO_STRING);
        sdoTypeForSimpleJavaType.put(ClassConstants.BOOLEAN, SDOConstants.SDO_BOOLEANOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PBOOLEAN, SDOConstants.SDO_BOOLEAN);
        sdoTypeForSimpleJavaType.put(ClassConstants.BYTE, SDOConstants.SDO_BYTEOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PBYTE, SDOConstants.SDO_BYTE);
        sdoTypeForSimpleJavaType.put(ClassConstants.ABYTE, SDOConstants.SDO_BYTES);
        sdoTypeForSimpleJavaType.put(ClassConstants.APBYTE, SDOConstants.SDO_BYTES);
        sdoTypeForSimpleJavaType.put(ClassConstants.CHAR, SDOConstants.SDO_CHARACTEROBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PCHAR, SDOConstants.SDO_CHARACTER);
        sdoTypeForSimpleJavaType.put(ClassConstants.BIGDECIMAL, SDOConstants.SDO_DECIMAL);
        sdoTypeForSimpleJavaType.put(ClassConstants.UTILDATE, SDOConstants.SDO_DATE);
        sdoTypeForSimpleJavaType.put(ClassConstants.DOUBLE, SDOConstants.SDO_DOUBLEOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PDOUBLE, SDOConstants.SDO_DOUBLE);
        sdoTypeForSimpleJavaType.put(ClassConstants.FLOAT, SDOConstants.SDO_FLOATOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PFLOAT, SDOConstants.SDO_FLOAT);
        sdoTypeForSimpleJavaType.put(ClassConstants.INTEGER, SDOConstants.SDO_INTOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PINT, SDOConstants.SDO_INT);
        sdoTypeForSimpleJavaType.put(ClassConstants.BIGINTEGER, SDOConstants.SDO_INTEGER);
        sdoTypeForSimpleJavaType.put(ClassConstants.LONG, SDOConstants.SDO_LONGOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PLONG, SDOConstants.SDO_LONG);
        sdoTypeForSimpleJavaType.put(ClassConstants.SHORT, SDOConstants.SDO_SHORTOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PSHORT, SDOConstants.SDO_SHORT);
    }

    @Override
    public Class getJavaWrapperTypeForSDOType(Type type) {
        SDOType sdoType = (SDOType)type;
        if (sdoType.getInstanceClass() != null) {
            return sdoType.getInstanceClass();
        }
        Class javaClass = null;
        if (sdoType.isSubType()) {
            int i2 = 0;
            while (i2 < sdoType.getBaseTypes().size()) {
                Type baseType = (Type)sdoType.getBaseTypes().get(i2);
                javaClass = this.getJavaWrapperTypeForSDOType(baseType);
                if (javaClass != null) {
                    return javaClass;
                }
                ++i2;
            }
        }
        return javaClass;
    }

    public SDOType getType(String uri, String typeName) {
        if (typeName == null) {
            return null;
        }
        if (uri != null && uri.equals("commonj.sdo")) {
            return (SDOType)this.commonjHashMap.get(typeName);
        }
        if (uri != null && uri.equals("commonj.sdo/java")) {
            return (SDOType)this.commonjJavaHashMap.get(typeName);
        }
        QName qName = new QName(uri, typeName);
        return (SDOType)this.getTypesHashMap().get(qName);
    }

    @Override
    public void addType(SDOType newType) {
        if ("commonj.sdo".equals(newType.getURI())) {
            this.commonjHashMap.put(newType.getName(), newType);
        } else if ("commonj.sdo/java".equals(newType.getURI())) {
            this.commonjJavaHashMap.put(newType.getName(), newType);
        } else {
            this.getTypesHashMap().put(newType.getQName(), newType);
        }
    }

    public SDOType getType(Class interfaceClass) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Looking for : " + interfaceClass);
        }
        Object[] searchSources = new Object[]{this.interfacesToSDOTypeHashMap, sdoTypeForSimpleJavaType, this.getTypesHashMap().values(), this.anonymousTypes, this.commonjHashMap.values()};
        int i2 = 0;
        while (i2 < searchSources.length) {
            SDOType type;
            Object searchSource = searchSources[i2];
            if (searchSource != null && (type = searchSource instanceof Map ? (SDOType)((Map)searchSource).get(interfaceClass) : this.getFromCollection((Collection)searchSource, interfaceClass)) != null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info(interfaceClass + " was found in: " + SEARCH_SOURCES_NAMES[i2] + '.');
                }
                return type;
            }
            ++i2;
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder log = new StringBuilder();
            log.append("Not found: ").append(interfaceClass).append('\n');
            int i3 = 0;
            while (i3 < searchSources.length) {
                log.append("Content of ").append(SEARCH_SOURCES_NAMES[i3]).append(": ");
                Object searchSource = searchSources[i3];
                if (searchSource == null) {
                    log.append("null");
                } else if (searchSource instanceof Map) {
                    log.append(((Map)searchSource).keySet());
                } else {
                    for (SDOType sdoType : (Collection)searchSource) {
                        log.append(sdoType.getInstanceClass()).append(", ");
                    }
                }
                log.append('\n');
                ++i3;
            }
            LOGGER.info(log.toString());
        }
        return null;
    }

    private SDOType getFromCollection(Collection<SDOType> collection, Class interfaceClass) {
        for (SDOType sdoType : collection) {
            if (sdoType.getInstanceClass() != interfaceClass) continue;
            return sdoType;
        }
        return null;
    }

    @Override
    public SDOType getTypeForImplClass(Class implClass) {
        SDOType type = this.getTypeForSimpleJavaType(implClass);
        if (type != null) {
            return type;
        }
        type = this.getImplClassesToSDOType().get(implClass);
        if (type != null) {
            return type;
        }
        for (Object key : this.commonjHashMap.keySet()) {
            SDOType value = (SDOType)this.commonjHashMap.get(key);
            if (value.isDataType() || value.getImplClass() != implClass) continue;
            return value;
        }
        return null;
    }

    @Override
    public SDOType getTypeForSimpleJavaType(Class implClass) {
        return (SDOType)SDOTypeHelperDelegate.getSDOTypeForSimpleJavaTypeMap().get(implClass);
    }

    public synchronized Type define(DataObject dataObject) {
        ArrayList types = new ArrayList();
        Type rootType = this.define(dataObject, types);
        this.initializeTypes(types);
        return rootType;
    }

    private void initializeTypes(List types) {
        SDOType nextType;
        ArrayList<SDOType> descriptorsToAdd = new ArrayList<SDOType>(types);
        int i2 = 0;
        while (i2 < types.size()) {
            nextType = (SDOType)types.get(i2);
            if (!nextType.isDataType()) {
                nextType.postInitialize();
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < types.size()) {
            nextType = (SDOType)types.get(i2);
            if (!nextType.isDataType() && !nextType.isSubType() && nextType.isBaseType()) {
                nextType.setupInheritance(null);
            } else if (!nextType.isDataType() && nextType.isSubType() && !types.contains(nextType.getBaseTypes().get(0))) {
                SDOType baseType = (SDOType)nextType.getBaseTypes().get(0);
                while (baseType != null && !baseType.isDataType()) {
                    descriptorsToAdd.add(baseType);
                    if (baseType.getBaseTypes().size() == 0) {
                        descriptorsToAdd.add(baseType);
                        baseType.setupInheritance(null);
                        baseType = null;
                        continue;
                    }
                    baseType = (SDOType)baseType.getBaseTypes().get(0);
                }
            }
            ++i2;
        }
        ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(descriptorsToAdd);
    }

    public synchronized Type define(DataObject dataObject, List types) {
        SDOTypeHelper typeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        if (dataObject == null || dataObject.getType() == null || !dataObject.getType().getURI().equals("commonj.sdo") || !dataObject.getType().getName().equals("Type")) {
            throw new IllegalArgumentException(SDOException.errorDefiningType());
        }
        String uri = dataObject.getString("uri");
        String name = dataObject.getString("name");
        if (name == null) {
            throw new IllegalArgumentException(SDOException.errorDefiningTypeNoName());
        }
        SDOType type = (SDOType)typeHelper.getType(uri, name);
        if (type != null) {
            return type;
        }
        if (this.isXmlNameValidationEnabled && !SDOUtil.isValidXmlNCName(name)) {
            throw new IllegalArgumentException(SDOException.errorDefiningTypeInvalidName(name));
        }
        boolean isDataType = dataObject.getBoolean("dataType");
        if (isDataType) {
            type = new SDODataType(uri, name, this);
        } else {
            type = new SDOType(uri, name, this);
            if (dataObject.getBoolean("sequenced")) {
                type.setSequenced(true);
                type.setMixed(true);
            }
        }
        type.setDataType(isDataType);
        this.addType(type);
        types.add(type);
        type.setAppInfoElements((List)dataObject.get("appinfo"));
        type.setAbstract(dataObject.getBoolean("abstract"));
        List baseTypes = dataObject.getList("baseType");
        int i2 = 0;
        while (i2 < baseTypes.size()) {
            SDOType baseType = (SDOType)this.getValueFromObject(baseTypes.get(i2), types);
            type.addBaseType(baseType);
            ++i2;
        }
        List aliasNames = dataObject.getList("aliasName");
        int i3 = 0;
        while (i3 < aliasNames.size()) {
            Object aliasName = aliasNames.get(i3);
            type.getAliasNames().add(aliasName);
            ++i3;
        }
        List openProps = ((SDODataObject)dataObject)._getOpenContentProperties();
        int i4 = 0;
        while (i4 < openProps.size()) {
            SDOProperty nextProp = (SDOProperty)openProps.get(i4);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            type.setInstanceProperty(nextProp, value);
            ++i4;
        }
        List openPropsAttrs = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        int i5 = 0;
        while (i5 < openPropsAttrs.size()) {
            SDOProperty nextProp = (SDOProperty)openPropsAttrs.get(i5);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            type.setInstanceProperty(nextProp, value);
            ++i5;
        }
        if (!type.isDataType()) {
            type.preInitialize(null, null);
        }
        List properties = dataObject.getList("property");
        int i6 = 0;
        while (i6 < properties.size()) {
            Object nextValue = properties.get(i6);
            if (nextValue instanceof DataObject) {
                this.buildPropertyFromDataObject((DataObject)nextValue, type, types);
            }
            ++i6;
        }
        type.setOpen(dataObject.getBoolean("open"));
        if (type.isDataType()) {
            QName typeQName = new QName("http://www.w3.org/2001/XMLSchema", name);
            if (typeHelper.getWrappersHashMap().get(typeQName) != null) {
                return type;
            }
            QName currentTypeQName = null;
            if (type.isSubType()) {
                SDOType baseType = (SDOType)type.getBaseTypes().get(0);
                currentTypeQName = new QName("http://www.w3.org/2001/XMLSchema", baseType.getName());
            }
            SDOWrapperType wrapperType = new SDOWrapperType((Type)type, name, (SDOTypeHelper)this, currentTypeQName);
            typeHelper.getWrappersHashMap().put(typeQName, wrapperType);
            typeHelper.getTypesHashMap().put(typeQName, wrapperType);
            typeHelper.getImplClassesToSDOType().put(wrapperType.getXmlDescriptor().getJavaClass(), wrapperType);
            ArrayList<SDOWrapperType> list = new ArrayList<SDOWrapperType>(1);
            list.add(wrapperType);
            ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(list);
        }
        return type;
    }

    private boolean isBaseTypeBytes(Type theType) {
        if (((SDOType)theType).isSubType()) {
            List baseTypes = ((SDOType)theType).getBaseTypes();
            Type nextType = (Type)baseTypes.get(0);
            if (nextType == SDOConstants.SDO_BYTES) {
                return true;
            }
            return this.isBaseTypeBytes(nextType);
        }
        return false;
    }

    private Object getValueFromObject(Object objectValue, List types) {
        if (objectValue instanceof SDODataObject && ((SDODataObject)objectValue).getType().isTypeType()) {
            return this.define((DataObject)objectValue, types);
        }
        return objectValue;
    }

    private SDOProperty buildPropertyFromDataObject(DataObject dataObject, Type containingType, List types) {
        String nameValue = dataObject.getString("name");
        Object typeObjectValue = dataObject.get("type");
        if (this.isXmlNameValidationEnabled && !SDOUtil.isValidXmlNCName(nameValue)) {
            throw new IllegalArgumentException(SDOException.errorDefiningPropertyInvalidName(nameValue));
        }
        SDOProperty newProperty = new SDOProperty(this.aHelperContext);
        newProperty.setName(nameValue);
        Type typeValue = (Type)this.getValueFromObject(typeObjectValue, types);
        newProperty.setType(typeValue);
        if (typeValue != null) {
            if (typeValue == SDOConstants.SDO_BYTES) {
                newProperty.setXsdType(XMLConstants.BASE_64_BINARY_QNAME);
            } else if (((SDOType)typeValue).isDataType() && this.isBaseTypeBytes(typeValue)) {
                newProperty.setXsdType(XMLConstants.BASE_64_BINARY_QNAME);
            }
        }
        newProperty.setAppInfoElements((List)dataObject.get("appinfo"));
        if (dataObject.isSet("containment")) {
            newProperty.setContainment(dataObject.getBoolean("containment"));
        } else if (typeValue != null) {
            newProperty.setContainment(!((SDOType)typeValue).isDataType());
        }
        newProperty.setReadOnly(dataObject.getBoolean("readOnly"));
        newProperty.setMany(dataObject.getBoolean("many"));
        newProperty.setNullable(dataObject.getBoolean("nullable"));
        List aliasNames = dataObject.getList("aliasName");
        int i2 = 0;
        while (i2 < aliasNames.size()) {
            Object aliasName = aliasNames.get(i2);
            newProperty.getAliasNames().add(aliasName);
            ++i2;
        }
        Object opposite = dataObject.get("opposite");
        if (opposite != null) {
            SDOProperty prop;
            if (opposite instanceof SDOProperty) {
                newProperty.setOpposite((SDOProperty)opposite);
                ((SDOProperty)opposite).setOpposite(newProperty);
            } else if (opposite instanceof DataObject && (prop = (SDOProperty)typeValue.getProperty(((DataObject)opposite).getString("name"))) != null) {
                newProperty.setOpposite(prop);
                prop.setOpposite(newProperty);
            }
        }
        if (dataObject.isSet("default")) {
            newProperty.setDefault(dataObject.get("default"));
        }
        List openProps = ((SDODataObject)dataObject)._getOpenContentProperties();
        int i3 = 0;
        while (i3 < openProps.size()) {
            SDOProperty nextProp = (SDOProperty)openProps.get(i3);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            newProperty.setInstanceProperty(nextProp, value);
            ++i3;
        }
        List openPropsAttrs = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        int i4 = 0;
        while (i4 < openPropsAttrs.size()) {
            SDOProperty nextProp = (SDOProperty)openPropsAttrs.get(i4);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            newProperty.setInstanceProperty(nextProp, value);
            ++i4;
        }
        if (newProperty.getType() == null) {
            throw SDOException.noTypeSpecifiedForProperty(newProperty.getName());
        }
        if (containingType != null) {
            ((SDOType)containingType).addDeclaredProperty(newProperty);
            if (this.aHelperContext.getXSDHelper().isElement((Property)newProperty) || newProperty.getType().isChangeSummaryType()) {
                newProperty.setNamespaceQualified(true);
            }
            newProperty.buildMapping(containingType.getURI());
        }
        return newProperty;
    }

    public synchronized List define(List types) {
        if (types == null) {
            throw new IllegalArgumentException(SDOException.cannotPerformOperationWithNullInputParameter("define", "types"));
        }
        ArrayList<Type> definedTypes = new ArrayList<Type>();
        int i2 = 0;
        while (i2 < types.size()) {
            Type definedType = this.define((DataObject)types.get(i2));
            definedTypes.add(definedType);
            ++i2;
        }
        return definedTypes;
    }

    @Override
    public QName getXSDTypeFromSDOType(Type aType) {
        return (QName)this.sdoToXSDTypes.get(aType);
    }

    @Override
    public SDOType getSDOTypeFromXSDType(QName aName) {
        return (SDOType)this.xsdToSDOType.get(aName);
    }

    @Override
    public void setTypesHashMap(Map typesHashMap) {
        this.typesHashMap = typesHashMap;
    }

    @Override
    public Map getTypesHashMap() {
        if (this.typesHashMap == null) {
            this.initTypesHashMap();
        }
        return this.typesHashMap;
    }

    @Override
    public Map getWrappersHashMap() {
        if (this.wrappersHashMap == null) {
            this.initWrappersHashMap();
        }
        return this.wrappersHashMap;
    }

    @Override
    public void setWrappersHashMap(Map aMap) {
        this.wrappersHashMap = aMap;
    }

    @Override
    public void reset() {
        this.interfacesToSDOTypeHashMap = new HashMap<Class, SDOType>();
        this.namespaceResolver = null;
        this.initWrapperTypes();
        this.initWrappersHashMap();
        this.initTypesHashMap();
        this.initSdoToXSDType();
        this.initXsdToSDOType();
        this.initOpenProps();
    }

    public Property defineOpenContentProperty(String uri, DataObject propertyDO) {
        if (propertyDO == null) {
            throw new IllegalArgumentException(SDOException.cannotPerformOperationWithNullInputParameter("defineOpenContentProperty", "propertyDO"));
        }
        String name = propertyDO.getString("name");
        Property propertyToReturn = this.aHelperContext.getXSDHelper().getGlobalProperty(uri, name, true);
        if (propertyToReturn == null) {
            propertyToReturn = this.aHelperContext.getXSDHelper().getGlobalProperty(uri, name, false);
        }
        if (propertyToReturn == null) {
            ArrayList types = new ArrayList();
            propertyToReturn = this.buildPropertyFromDataObject(propertyDO, null, types);
            this.initializeTypes(types);
            this.defineOpenContentProperty(uri, name, propertyToReturn);
        }
        if (propertyToReturn != null) {
            DataObject newTypeDO;
            Object propDOType = propertyDO.get("type");
            SDOType existingType = (SDOType)propertyToReturn.getType();
            boolean typeMismatch = false;
            if (propDOType instanceof SDOType) {
                SDOType newType = (SDOType)propDOType;
                if (!newType.getQName().equals(existingType.getQName())) {
                    typeMismatch = true;
                }
            } else if (!(!(propDOType instanceof DataObject) || (newTypeDO = (DataObject)propDOType).get("name").equals(existingType.getName()) && newTypeDO.get("uri").equals(existingType.getURI()))) {
                typeMismatch = true;
            }
            if (typeMismatch) {
                throw new IllegalArgumentException("Should not be able to redefine a Property with a different Type.");
            }
        }
        return propertyToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineOpenContentProperty(String propertyUri, String propertyName, Property property) {
        if (propertyUri != null) {
            QName propertyQName = new QName(propertyUri, propertyName);
            this.openContentProperties.put(propertyQName, property);
            boolean isElement = this.aHelperContext.getXSDHelper().isElement(property);
            ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).addGlobalProperty(propertyQName, property, isElement);
            ((SDOProperty)property).setUri(propertyUri);
            if (((SDOType)property.getType()).isDataType()) {
                SDOTypeHelper typeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
                SDOWrapperType wrapperType = (SDOWrapperType)typeHelper.getWrappersHashMap().get(((SDOProperty)property).getType().getQName());
                if (wrapperType != null) {
                    QName descriptorQname = new QName(propertyUri, propertyName);
                    ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().addDescriptorByQName(descriptorQname, wrapperType.getXmlDescriptor(((SDOProperty)property).getXsdType()));
                }
                return;
            }
            XMLDescriptor aDescriptor = ((SDOType)property.getType()).getXmlDescriptor();
            if (aDescriptor != null) {
                XMLDescriptor xMLDescriptor = aDescriptor;
                synchronized (xMLDescriptor) {
                    String rootName = propertyName;
                    String prefix = aDescriptor.getNonNullNamespaceResolver().resolveNamespaceURI(propertyUri);
                    if (prefix == null || prefix.equals("")) {
                        prefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix(propertyUri);
                        aDescriptor.getNonNullNamespaceResolver().put(prefix, propertyUri);
                    }
                    if (prefix != null && !prefix.equals("")) {
                        rootName = String.valueOf(prefix) + ":" + rootName;
                    }
                    aDescriptor.setDefaultRootElement(rootName);
                    QName elementType = new QName(propertyUri, rootName);
                    aDescriptor.setDefaultRootElementType(elementType);
                    ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().storeXMLDescriptorByQName(aDescriptor);
                }
            }
        }
    }

    public Property getOpenContentProperty(String uri, String propertyName) {
        QName qname = new QName(uri, propertyName);
        return (Property)this.openContentProperties.get(qname);
    }

    private static Map getSDOTypeForSimpleJavaTypeMap() {
        return sdoTypeForSimpleJavaType;
    }

    @Override
    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    @Override
    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    @Override
    public String getPrefix(String uri) {
        if (uri == null) {
            return null;
        }
        NamespaceResolver nr = this.getNamespaceResolver();
        String existingPrefixForUri = nr.resolveNamespaceURI(uri);
        if (existingPrefixForUri == null || existingPrefixForUri.equals("")) {
            String newPrefix = this.generatePrefix(uri);
            nr.put(newPrefix, uri);
            return newPrefix;
        }
        return existingPrefixForUri;
    }

    private String generatePrefix(String uri) {
        NamespaceResolver nr = this.getNamespaceResolver();
        if (uri.equals("commonj.sdo")) {
            return nr.generatePrefix("sdo");
        }
        if (uri.equals("commonj.sdo/xml")) {
            return nr.generatePrefix("sdoXML");
        }
        if (uri.equals("commonj.sdo/java")) {
            return nr.generatePrefix("sdoJava");
        }
        return nr.generatePrefix();
    }

    @Override
    public String addNamespace(String prefix, String uri) {
        NamespaceResolver nr = this.getNamespaceResolver();
        String existingPrefixForURI = nr.resolveNamespaceURI(uri);
        if (existingPrefixForURI != null && !existingPrefixForURI.equals("")) {
            return existingPrefixForURI;
        }
        String existingUriForPrefix = nr.resolveNamespacePrefix(prefix);
        if (existingUriForPrefix == null) {
            nr.put(prefix, uri);
            return prefix;
        }
        prefix = this.generatePrefix(uri);
        nr.put(prefix, uri);
        return prefix;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = new NamespaceResolver();
        }
        return this.namespaceResolver;
    }

    @Override
    public Map getOpenContentProperties() {
        return this.openContentProperties;
    }

    private void initOpenProps() {
        SDOType typeType = this.getType("commonj.sdo", "Type");
        this.openContentProperties = new HashMap();
        this.openContentProperties.put(SDOConstants.MIME_TYPE_QNAME, SDOConstants.MIME_TYPE_PROPERTY);
        this.openContentProperties.put(SDOConstants.MIME_TYPE_PROPERTY_QNAME, SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
        this.openContentProperties.put(SDOConstants.SCHEMA_TYPE_QNAME, new SDOProperty(this.aHelperContext, "org.eclipse.persistence.sdo", "xmlSchemaType", typeType));
        this.openContentProperties.put(SDOConstants.JAVA_CLASS_QNAME, SDOConstants.JAVA_CLASS_PROPERTY);
        this.openContentProperties.put(SDOConstants.XML_ELEMENT_QNAME, SDOConstants.XMLELEMENT_PROPERTY);
        this.openContentProperties.put(SDOConstants.XML_DATATYPE_QNAME, new SDOProperty(this.aHelperContext, "commonj.sdo/xml", "dataType", typeType));
        this.openContentProperties.put(SDOConstants.XML_ID_PROPERTY_QNAME, SDOConstants.ID_PROPERTY);
        this.openContentProperties.put(SDOConstants.DOCUMENTATION_PROPERTY_QNAME, SDOConstants.DOCUMENTATION_PROPERTY);
    }

    @Override
    public Map getInterfacesToSDOTypeHashMap() {
        return this.interfacesToSDOTypeHashMap;
    }

    @Override
    public Map<Class, SDOType> getImplClassesToSDOType() {
        return this.implClassesToSDOType;
    }

    @Override
    public List getAnonymousTypes() {
        if (this.anonymousTypes == null) {
            this.anonymousTypes = new ArrayList();
        }
        return this.anonymousTypes;
    }

    public static enum SDOWrapperTypeId {
        SDO_BOOLEAN_WRAPPER,
        SDO_BYTE_WRAPPER,
        SDO_BYTES_WRAPPER,
        SDO_CHARACTER_WRAPPER,
        SDO_DATE_WRAPPER,
        SDO_DATETIME_WRAPPER,
        SDO_DAY_WRAPPER,
        SDO_DECIMAL_WRAPPER,
        SDO_DOUBLE_WRAPPER,
        SDO_DURATION_WRAPPER,
        SDO_FLOAT_WRAPPER,
        SDO_INT_WRAPPER,
        SDO_INTEGER_WRAPPER,
        SDO_LONG_WRAPPER,
        SDO_MONTH_WRAPPER,
        SDO_MONTHDAY_WRAPPER,
        SDO_OBJECT_WRAPPER,
        SDO_SHORT_WRAPPER,
        SDO_STRING_WRAPPER,
        SDO_STRINGS_WRAPPER,
        SDO_TIME_WRAPPER,
        SDO_URI_WRAPPER,
        SDO_YEAR_WRAPPER,
        SDO_YEARMONTH_WRAPPER,
        SDO_YEARMONTHDAY_WRAPPER,
        SDO_BOOLEANOBJECT_WRAPPER,
        SDO_BYTEOBJECT_WRAPPER,
        SDO_CHARACTEROBJECT_WRAPPER,
        SDO_DOUBLEOBJECT_WRAPPER,
        SDO_FLOATOBJECT_WRAPPER,
        SDO_INTOBJECT_WRAPPER,
        SDO_LONGOBJECT_WRAPPER,
        SDO_SHORTOBJECT_WRAPPER;

    }
}

