/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.util.List;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.sequenced.Setting;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.SDOType;

public class SDOEqualityHelper
implements EqualityHelper {
    private HelperContext aHelperContext;

    public SDOEqualityHelper() {
    }

    public SDOEqualityHelper(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public boolean equalShallow(DataObject dataObject1, DataObject dataObject2) {
        return this.compareDataObjects(dataObject1, dataObject2, false);
    }

    public boolean equal(DataObject dataObject1, DataObject dataObject2) {
        return this.compareDataObjects(dataObject1, dataObject2, true);
    }

    private boolean compareDataObjects(DataObject dataObject1, DataObject dataObject2, boolean isDeep) {
        if (dataObject1 == null) {
            return dataObject2 == null;
        }
        if (dataObject2 == null) {
            return false;
        }
        if (dataObject1.getType() != dataObject2.getType()) {
            return false;
        }
        if (dataObject1.getType().isSequenced() && !this.compareSequences((SDOSequence)dataObject1.getSequence(), (SDOSequence)dataObject2.getSequence(), isDeep)) {
            return false;
        }
        if (!this.compare(dataObject1, dataObject2, isDeep, dataObject1.getType().getProperties())) {
            return false;
        }
        List properties_1 = ((SDODataObject)dataObject1)._getOpenContentProperties();
        List properties_2 = ((SDODataObject)dataObject2)._getOpenContentProperties();
        if (properties_1.size() != properties_2.size() || !properties_1.containsAll(properties_2)) {
            return false;
        }
        if (!this.compare(dataObject1, dataObject2, isDeep, properties_1)) {
            return false;
        }
        List attrProperties_1 = ((SDODataObject)dataObject1)._getOpenContentPropertiesAttributes();
        List attrProperties_2 = ((SDODataObject)dataObject2)._getOpenContentPropertiesAttributes();
        if (attrProperties_1.size() != attrProperties_2.size() || !attrProperties_1.containsAll(attrProperties_2)) {
            return false;
        }
        return this.compare(dataObject1, dataObject2, isDeep, attrProperties_1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compareSequences(SDOSequence aSequence, SDOSequence aSequenceCopy, boolean isDeep) {
        if (aSequence == null && aSequenceCopy == null) {
            return true;
        }
        if (aSequence == null || aSequenceCopy == null) {
            return false;
        }
        if (isDeep && aSequence.size() != aSequenceCopy.size()) {
            return false;
        }
        List<Setting> originalSettingsList = aSequence.getSettings();
        List<Setting> copySettingsList = aSequenceCopy.getSettings();
        if (originalSettingsList == null || copySettingsList == null) {
            return false;
        }
        SDOProperty originalProperty = null;
        SDOProperty copyProperty = null;
        if (isDeep) {
            int index = 0;
            int size = aSequence.size();
            while (index < size) {
                originalProperty = aSequence.getProperty(originalSettingsList.get(index));
                copyProperty = aSequenceCopy.getProperty(copySettingsList.get(index));
                if (originalProperty == null && copyProperty != null || originalProperty != null && copyProperty == null) {
                    return false;
                }
                if (!this.arePropertiesEqual(originalProperty, copyProperty)) {
                    return false;
                }
                Object originalValue = aSequence.getValue(index);
                Object copyValue = aSequenceCopy.getValue(index);
                if (originalProperty == null || originalProperty.getType().isDataType()) {
                    if (originalValue == null && copyValue != null || originalValue != null && copyValue == null) {
                        return false;
                    }
                    if (originalValue != null && !originalValue.equals(copyValue)) {
                        return false;
                    }
                } else if (isDeep) {
                    if (originalValue != null && copyValue != null) {
                        if (originalValue instanceof DataObject && copyValue instanceof DataObject) {
                            if (!this.equal((DataObject)originalValue, (DataObject)copyValue)) {
                                return false;
                            }
                        } else {
                            if (!(originalValue instanceof XMLRoot) || !(copyValue instanceof XMLRoot)) return false;
                            XMLRoot originalXMLRoot = (XMLRoot)originalValue;
                            XMLRoot copyXMLRoot = (XMLRoot)copyValue;
                            if (!originalXMLRoot.getLocalName().equals(copyXMLRoot.getLocalName())) {
                                return false;
                            }
                            if (!originalXMLRoot.getNamespaceURI().equals(copyXMLRoot.getNamespaceURI())) {
                                return false;
                            }
                            Object originalUnwrappedValue = originalXMLRoot.getObject();
                            Object copyUnwrappedValue = copyXMLRoot.getObject();
                            if (originalUnwrappedValue instanceof DataObject && copyUnwrappedValue instanceof DataObject && !this.equal((DataObject)originalUnwrappedValue, (DataObject)copyUnwrappedValue)) {
                                return false;
                            }
                        }
                    } else if (originalValue == null && copyValue != null || copyValue == null && originalValue != null) {
                        return false;
                    }
                }
                ++index;
            }
            return true;
        } else {
            int cpyIdx = 0;
            int idx = 0;
            while (idx < aSequence.getSettings().size()) {
                SDOProperty nextProperty = aSequence.getProperty(idx);
                if (nextProperty == null || nextProperty.getType().isDataType()) {
                    Object nextValue = aSequence.getValue(idx);
                    boolean locatedSetting = false;
                    while (cpyIdx < aSequenceCopy.getSettings().size()) {
                        SDOProperty nextCopyProperty = aSequenceCopy.getProperty(cpyIdx);
                        if (nextCopyProperty == null || nextCopyProperty.getType().isDataType()) {
                            Object nextCopyValue = aSequenceCopy.getValue(cpyIdx);
                            if (nextValue == nextCopyValue && this.arePropertiesEqual(nextProperty, nextCopyProperty)) {
                                locatedSetting = true;
                            }
                            ++cpyIdx;
                            break;
                        }
                        ++cpyIdx;
                    }
                    if (!locatedSetting) {
                        return false;
                    }
                }
                ++idx;
            }
            if (this.getIndexOfNextDataTypeSetting(aSequenceCopy, cpyIdx) == -1) return true;
            return false;
        }
    }

    private int getIndexOfNextDataTypeSetting(SDOSequence aSequence, int index) {
        List<Setting> settings = aSequence.getSettings();
        int i2 = index;
        while (i2 < settings.size()) {
            SDOProperty nextProperty = aSequence.getProperty(i2);
            if (nextProperty == null || nextProperty.getType().isDataType()) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private boolean arePropertiesEqual(Property prop1, Property prop2) {
        if (prop1 == null && prop2 != null || prop1 != null && prop2 == null) {
            return false;
        }
        return prop1.equals(prop2);
    }

    private boolean compare(DataObject dataObject1, DataObject dataObject2, boolean isDeep, List properties) {
        for (SDOProperty p2 : properties) {
            if (this.compareProperty(dataObject1, dataObject2, isDeep, p2)) continue;
            return false;
        }
        return true;
    }

    private boolean compareProperty(DataObject dataObject1, DataObject dataObject2, boolean isDeep, SDOProperty p2) {
        if (p2.isMany()) {
            return this.compareManyProperty(dataObject1, dataObject2, isDeep, p2);
        }
        if (p2.getType().isDataType() && !p2.getType().isChangeSummaryType()) {
            boolean isSet1 = dataObject1.isSet((Property)p2);
            boolean isSet2 = dataObject2.isSet((Property)p2);
            if (!isSet1 && !isSet2) {
                return true;
            }
            if (isSet1 && isSet2) {
                Object aProperty1 = dataObject1.get((Property)p2);
                Object aProperty2 = dataObject2.get((Property)p2);
                if (aProperty1 == null) {
                    return aProperty2 == null;
                }
                if (aProperty2 == null) {
                    return false;
                }
                return aProperty1.equals(aProperty2);
            }
            return false;
        }
        if (isDeep && !p2.getType().isChangeSummaryType()) {
            if (!dataObject1.isSet((Property)p2) && !dataObject2.isSet((Property)p2)) {
                return true;
            }
            if (!p2.getType().isDataType()) {
                if (p2.getOpposite() == null) {
                    return this.compareDataObjects(dataObject1.getDataObject((Property)p2), dataObject2.getDataObject((Property)p2), isDeep);
                }
                return this.compareDataObjects(dataObject1.getDataObject((Property)p2), dataObject2.getDataObject((Property)p2), false);
            }
            return false;
        }
        return true;
    }

    private boolean compareManyProperty(DataObject dataObject1, DataObject dataObject2, boolean isDeep, Property p2) {
        List l1 = dataObject1.getList(p2);
        List l2 = dataObject2.getList(p2);
        if (((SDOType)p2.getType()).isDataType()) {
            if (dataObject1.isSet(p2) != dataObject2.isSet(p2)) {
                return false;
            }
            if (l1.size() != l2.size()) {
                return false;
            }
            int i2 = 0;
            while (i2 < l1.size()) {
                Object o2;
                Object o1 = l1.get(i2);
                if (!o1.equals(o2 = l2.get(i2))) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        if (isDeep) {
            if (dataObject1.isSet(p2) != dataObject2.isSet(p2)) {
                return false;
            }
            if (l1.size() != l2.size()) {
                return false;
            }
            int i3 = 0;
            int size = l1.size();
            while (i3 < size) {
                DataObject o1_l1 = (DataObject)l1.get(i3);
                DataObject o2_l2 = (DataObject)l2.get(i3);
                if (!this.isADataObjectInList(o1_l1, l2)) {
                    return false;
                }
                if (!this.isADataObjectInList(o2_l2, l1)) {
                    return false;
                }
                ++i3;
            }
        }
        return true;
    }

    private boolean isADataObjectInList(DataObject dataObject1, List objects) {
        for (DataObject dataObject2 : objects) {
            if (!this.compareDataObjects(dataObject1, dataObject2, true)) continue;
            return true;
        }
        return false;
    }

    public HelperContext getHelperContext() {
        if (this.aHelperContext == null) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

