/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.jaxp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.validation.Schema;
import org.eclipse.persistence.internal.helper.XMLHelper;
import org.eclipse.persistence.platform.xml.DefaultErrorHandler;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXPParser
implements XMLParser {
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private DocumentBuilderFactory documentBuilderFactory;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private DocumentBuilder documentBuilder;
    private TransformerFactory transformerFactory;

    public JAXPParser() {
        this.errorHandler = DefaultErrorHandler.getInstance();
    }

    public JAXPParser(DocumentBuilderFactory documentBuilderFactory, ErrorHandler errorHandler) {
        this.documentBuilderFactory = documentBuilderFactory;
        this.errorHandler = errorHandler != null ? errorHandler : DefaultErrorHandler.getInstance();
    }

    public JAXPParser(Map<String, Boolean> parserFeatures) {
        this();
        this.loadDocumentBuilderFactory();
        try {
            if (parserFeatures != null) {
                for (Map.Entry<String, Boolean> entry : parserFeatures.entrySet()) {
                    this.documentBuilderFactory.setFeature(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e2) {
            throw XMLPlatformException.xmlPlatformParseException(e2);
        }
    }

    private void loadDocumentBuilderFactory() {
        this.documentBuilderFactory = XMLHelper.createDocumentBuilderFactory(false);
        this.setNamespaceAware(true);
        this.setWhitespacePreserving(false);
    }

    @Override
    public void setNamespaceAware(boolean isNamespaceAware) {
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        this.documentBuilderFactory.setNamespaceAware(isNamespaceAware);
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(!isWhitespacePreserving);
    }

    @Override
    public int getValidationMode() {
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        if (!this.documentBuilderFactory.isValidating()) {
            return 0;
        }
        try {
            if (this.documentBuilderFactory.getAttribute(SCHEMA_LANGUAGE) == null) {
                return 2;
            }
        }
        catch (IllegalArgumentException e2) {
            return 2;
        }
        return 3;
    }

    @Override
    public void setValidationMode(int validationMode) {
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        switch (validationMode) {
            case 0: {
                this.documentBuilderFactory.setValidating(false);
                return;
            }
            case 2: {
                this.documentBuilderFactory.setValidating(true);
                XMLHelper.allowExternalDTDAccess(this.documentBuilderFactory, "all", false);
                return;
            }
            case 3: {
                try {
                    this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
                    this.documentBuilderFactory.setValidating(true);
                    XMLHelper.allowExternalAccess(this.documentBuilderFactory, "all", false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void setXMLSchema(URL url) throws XMLPlatformException {
        if (url == null) {
            return;
        }
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, url.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e2) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(url, e2);
        }
    }

    @Override
    public void setXMLSchema(Schema schema) throws XMLPlatformException {
        this.documentBuilderFactory.setSchema(schema);
    }

    @Override
    public Schema getXMLSchema() throws XMLPlatformException {
        return this.documentBuilderFactory.getSchema();
    }

    @Override
    public void setXMLSchemas(Object[] schemas) throws XMLPlatformException {
        if (schemas == null || schemas.length == 0) {
            return;
        }
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, schemas);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e2) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchemas(schemas, e2);
        }
    }

    @Override
    public Document parse(InputSource inputSource) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputSource);
        }
        catch (SAXException e2) {
            throw XMLPlatformException.xmlPlatformParseException(e2);
        }
        catch (IOException e3) {
            throw XMLPlatformException.xmlPlatformParseException(e3);
        }
    }

    @Override
    public Document parse(File file) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(file);
        }
        catch (SAXParseException e2) {
            throw XMLPlatformException.xmlPlatformSAXParseException(e2);
        }
        catch (SAXException e3) {
            throw XMLPlatformException.xmlPlatformParseException(e3);
        }
        catch (IOException e4) {
            throw XMLPlatformException.xmlPlatformFileNotFoundException(file, e4);
        }
    }

    @Override
    public Document parse(InputStream inputStream) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputStream);
        }
        catch (SAXParseException e2) {
            throw XMLPlatformException.xmlPlatformSAXParseException(e2);
        }
        catch (SAXException e3) {
            throw XMLPlatformException.xmlPlatformParseException(e3);
        }
        catch (IOException e4) {
            throw XMLPlatformException.xmlPlatformParseException(e4);
        }
    }

    @Override
    public Document parse(Reader reader) throws XMLPlatformException {
        InputSource inputSource = new InputSource(reader);
        return this.parse(inputSource);
    }

    @Override
    public Document parse(Source source) throws XMLPlatformException {
        try {
            if (this.transformerFactory == null) {
                this.transformerFactory = XMLHelper.createTransformerFactory(false);
            }
            Transformer transformer = this.transformerFactory.newTransformer();
            SAXResult saxResult = new SAXResult();
            SAXDocumentBuilder builder = new SAXDocumentBuilder();
            saxResult.setHandler(builder);
            transformer.transform(source, saxResult);
            return builder.getDocument();
        }
        catch (TransformerException e2) {
            throw XMLPlatformException.xmlPlatformParseException(e2);
        }
    }

    @Override
    public Document parse(URL url) throws XMLPlatformException {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (IOException | IllegalArgumentException e2) {
            throw XMLPlatformException.xmlPlatformParseException(e2);
        }
        boolean hasThrownException = false;
        try {
            Document document = this.parse(inputStream);
            return document;
        }
        catch (RuntimeException e3) {
            hasThrownException = true;
            throw e3;
        }
        finally {
            block11: {
                try {
                    inputStream.close();
                }
                catch (IOException e4) {
                    if (hasThrownException) break block11;
                    throw XMLPlatformException.xmlPlatformParseException(e4);
                }
            }
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        try {
            if (this.documentBuilder == null) {
                this.documentBuilder = this.getNewDocumentBuilder();
            } else {
                try {
                    this.documentBuilder.reset();
                }
                catch (UnsupportedOperationException uoe) {
                    this.documentBuilder = this.getNewDocumentBuilder();
                }
            }
            return this.documentBuilder;
        }
        catch (ParserConfigurationException e2) {
            throw XMLPlatformException.xmlPlatformParseException(e2);
        }
    }

    private DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        DocumentBuilder newDb = this.documentBuilderFactory.newDocumentBuilder();
        newDb.setEntityResolver(this.entityResolver);
        newDb.setErrorHandler(this.errorHandler);
        return newDb;
    }
}

