/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLMarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class WriterRecord
extends MarshalRecord<XMLMarshaller> {
    protected StringBuilder builder = new StringBuilder(3072);
    protected boolean isStartElementOpen = false;
    protected boolean isProcessingCData = false;
    protected CharsetEncoder encoder;
    String charset = "UNKNOWN_CHARSET";
    private static final String defaultCharset = "UTF-8".intern();
    private Writer writer;

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void startDocument(String encoding, String version) {
        this.builder.append("<?xml version=\"");
        this.builder.append(version);
        this.builder.append('\"');
        if (encoding != null) {
            this.builder.append(" encoding=\"");
            this.builder.append(encoding);
            this.builder.append('\"');
        }
        this.builder.append("?>");
    }

    @Override
    public void writeHeader() {
        this.builder.append(((XMLMarshaller)this.getMarshaller()).getXmlHeader());
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.builder.append('>');
        }
        this.isStartElementOpen = true;
        this.builder.append('<');
        this.builder.append(this.getNameForFragment(xPathFragment));
        if (xPathFragment.isGeneratedPrefix()) {
            this.namespaceDeclaration(xPathFragment.getPrefix(), xPathFragment.getNamespaceURI());
        }
    }

    @Override
    public void element(XPathFragment frag) {
        if (this.isStartElementOpen) {
            this.builder.append('>');
            this.isStartElementOpen = false;
        }
        this.builder.append('<');
        this.builder.append(this.getNameForFragment(frag));
        this.builder.append('/');
        this.builder.append('>');
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.attribute(null, xPathFragment.getLocalName(), this.getNameForFragment(xPathFragment), value);
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value) {
        this.builder.append(' ');
        this.builder.append(qName);
        this.builder.append('=');
        this.builder.append('\"');
        this.writeValue(value, true, this.builder);
        this.builder.append('\"');
    }

    @Override
    public void closeStartElement() {
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (this.isStartElementOpen) {
            this.builder.append('/');
            this.builder.append('>');
            this.isStartElementOpen = false;
        } else {
            this.builder.append('<');
            this.builder.append('/');
            this.builder.append(this.getNameForFragment(xPathFragment));
            this.builder.append('>');
        }
        this.isStartElementOpen = false;
    }

    @Override
    public void characters(String value) {
        if (this.isStartElementOpen) {
            this.isStartElementOpen = false;
            this.builder.append('>');
        }
        this.writeValue(value);
    }

    @Override
    public void cdata(String value) {
        if (this.isStartElementOpen) {
            this.isStartElementOpen = false;
            this.builder.append('>');
        }
        for (String part : MarshalRecord.splitCData(value)) {
            this.builder.append("<![CDATA[");
            this.builder.append(part);
            this.builder.append("]]>");
        }
    }

    protected void writeValue(String value) {
        this.writeValue(value, false, this.builder);
    }

    protected void writeValue(String value, boolean isAttribute, StringBuilder writer) {
        CharacterEscapeHandler escapeHandler = null;
        if (this.marshaller != null) {
            escapeHandler = (CharacterEscapeHandler)((XMLMarshaller)this.marshaller).getCharacterEscapeHandler();
        }
        if (escapeHandler != null) {
            try {
                StringWriter sw = new StringWriter();
                escapeHandler.escape(value.toCharArray(), 0, value.length(), isAttribute, sw);
                writer.append(sw.toString());
            }
            catch (IOException e2) {
                throw XMLMarshalException.marshalException(e2);
            }
            return;
        }
        if (this.encoder == null) {
            this.encoder = Constants.DEFAULT_CHARSET.newEncoder();
            this.charset = defaultCharset;
        }
        char[] chars = value.toCharArray();
        int nClosingSquareBracketsInRow = 0;
        int x2 = 0;
        int charsSize = chars.length;
        while (x2 < charsSize) {
            char character = chars[x2];
            switch (character) {
                case '&': {
                    writer.append("&amp;");
                    break;
                }
                case '<': {
                    writer.append("&lt;");
                    break;
                }
                case '>': {
                    if (nClosingSquareBracketsInRow >= 2) {
                        writer.append("&gt;");
                        break;
                    }
                    writer.append(character);
                    break;
                }
                case '\"': {
                    writer.append("&quot;");
                    break;
                }
                case '\n': {
                    if (isAttribute) {
                        writer.append("&#xa;");
                        break;
                    }
                    writer.append('\n');
                    break;
                }
                case '\r': {
                    writer.append("&#xd;");
                    break;
                }
                default: {
                    if (this.charset == defaultCharset) {
                        writer.append(character);
                        break;
                    }
                    if (this.encoder.canEncode(character)) {
                        writer.append(character);
                        break;
                    }
                    writer.append("&#");
                    writer.append(Integer.toString(character));
                    writer.append(';');
                }
            }
            if (!isAttribute) {
                nClosingSquareBracketsInRow = ']' == character ? ++nClosingSquareBracketsInRow : 0;
            }
            ++x2;
        }
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver, String newNamespace, String newName) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.namespaceDeclaration(attr.getPrefix(), attr.getNamespaceURI());
                    ((NamespaceResolver)this.getNamespaceResolver()).put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                WriterRecordContentHandler wrcHandler = new WriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node, newNamespace, newName);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    @Override
    public void setMarshaller(XMLMarshaller marshaller) {
        super.setMarshaller(marshaller);
        if (this.charset == marshaller.getEncoding()) {
            this.encoder.reset();
        } else {
            this.encoder = Charset.forName(marshaller.getEncoding()).newEncoder();
            this.charset = marshaller.getEncoding();
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.write(this.builder.toString());
            this.builder.setLength(0);
            this.writer.flush();
        }
        catch (IOException e2) {
            throw XMLMarshalException.marshalException(e2);
        }
    }

    protected class WriterRecordContentHandler
    implements ExtendedContentHandler,
    LexicalHandler {
        Map<String, String> prefixMappings = new HashMap<String, String>();

        WriterRecordContentHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (WriterRecord.this.isStartElementOpen) {
                WriterRecord.this.builder.append('>');
            }
            WriterRecord.this.builder.append('<');
            WriterRecord.this.builder.append(qName);
            WriterRecord.this.isStartElementOpen = true;
            this.handleAttributes(atts);
            this.writePrefixMappings();
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (WriterRecord.this.isStartElementOpen) {
                WriterRecord.this.builder.append('/');
                WriterRecord.this.builder.append('>');
            } else {
                WriterRecord.this.builder.append('<');
                WriterRecord.this.builder.append('/');
                WriterRecord.this.builder.append(qName);
                WriterRecord.this.builder.append('>');
            }
            WriterRecord.this.isStartElementOpen = false;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = ((NamespaceResolver)WriterRecord.this.getNamespaceResolver()).resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String characters = new String(ch, start, length);
            this.characters(characters);
        }

        @Override
        public void characters(CharSequence characters) throws SAXException {
            if (WriterRecord.this.isProcessingCData) {
                WriterRecord.this.cdata(characters.toString());
                return;
            }
            if (WriterRecord.this.isStartElementOpen) {
                WriterRecord.this.builder.append('>');
                WriterRecord.this.isStartElementOpen = false;
            }
            WriterRecord.this.writeValue(characters.toString());
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (WriterRecord.this.isStartElementOpen) {
                WriterRecord.this.builder.append('>');
                WriterRecord.this.isStartElementOpen = false;
            }
            this.writeComment(ch, start, length);
        }

        @Override
        public void startCDATA() throws SAXException {
            WriterRecord.this.isProcessingCData = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            WriterRecord.this.isProcessingCData = false;
        }

        protected void writePrefixMappings() {
            if (!this.prefixMappings.isEmpty()) {
                Set<Map.Entry<String, String>> entries = this.prefixMappings.entrySet();
                for (Map.Entry<String, String> nextEntry : entries) {
                    String prefix = nextEntry.getKey();
                    WriterRecord.this.builder.append(' ');
                    WriterRecord.this.builder.append("xmlns");
                    if (prefix != null && prefix.length() > 0) {
                        WriterRecord.this.builder.append(':');
                        WriterRecord.this.builder.append(prefix);
                    }
                    WriterRecord.this.builder.append('=');
                    WriterRecord.this.builder.append('\"');
                    String uri = nextEntry.getValue();
                    if (uri != null) {
                        WriterRecord.this.builder.append(uri);
                    }
                    WriterRecord.this.builder.append('\"');
                }
                this.prefixMappings.clear();
            }
        }

        protected void handleAttributes(Attributes atts) {
            int i2 = 0;
            int attsLength = atts.getLength();
            while (i2 < attsLength) {
                String qName = atts.getQName(i2);
                if (qName == null || !qName.startsWith("xmlns:") && !qName.equals("xmlns")) {
                    WriterRecord.this.attribute(atts.getURI(i2), atts.getLocalName(i2), qName, atts.getValue(i2));
                }
                ++i2;
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
            WriterRecord.this.builder.append('<');
            WriterRecord.this.builder.append('!');
            WriterRecord.this.builder.append('-');
            WriterRecord.this.builder.append('-');
            int x2 = start;
            while (x2 < length) {
                WriterRecord.this.builder.append(chars[x2]);
                ++x2;
            }
            WriterRecord.this.builder.append('-');
            WriterRecord.this.builder.append('-');
            WriterRecord.this.builder.append('>');
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            int x2 = start;
            while (x2 < length) {
                WriterRecord.this.builder.append(chars[x2]);
                ++x2;
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void setNil(boolean isNil) {
        }
    }
}

