/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.mappings.CoreAttributeAccessor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.accessor.OrmAttributeAccessor;
import org.eclipse.persistence.internal.oxm.documentpreservation.DescriptorLevelDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.documentpreservation.NoDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLBinder;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.XMLValidator;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.platform.SAXPlatform;
import org.eclipse.persistence.oxm.platform.XMLPlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

public class XMLContext
extends Context<AbstractSession, XMLDescriptor, XMLField, NamespaceResolver, Project, DatabaseSession, SessionEventListener> {
    XMLContext(XMLContextState xmlContextState) {
        this.contextState = xmlContextState;
    }

    public XMLContext(String sessionNames) {
        this(sessionNames, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class));
    }

    public XMLContext(String sessionNames, ClassLoader classLoader) {
        this(sessionNames, classLoader, null);
    }

    public XMLContext(String sessionNames, String xmlResource) {
        this(sessionNames, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(XMLContext.class), xmlResource);
    }

    public XMLContext(String sessionNames, ClassLoader classLoader, String xmlResource) {
        this.contextState = new XMLContextState(this, sessionNames, classLoader, xmlResource);
    }

    public XMLContext(Project project) {
        this(project, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Project project, ClassLoader classLoader) {
        this(project, classLoader, (Collection<SessionEventListener>)null);
    }

    public XMLContext(Project project, ClassLoader classLoader, SessionEventListener sessionEventListener) {
        ArrayList<SessionEventListener> sessionEventListeners = new ArrayList<SessionEventListener>(1);
        sessionEventListeners.add(sessionEventListener);
        this.contextState = new XMLContextState(this, project, classLoader, sessionEventListeners);
    }

    public XMLContext(Project project, ClassLoader classLoader, Collection<SessionEventListener> sessionEventListeners) {
        this.contextState = new XMLContextState(this, project, classLoader, sessionEventListeners);
    }

    public XMLContext(Collection projects) {
        this(projects, Thread.currentThread().getContextClassLoader());
    }

    public XMLContext(Collection projects, ClassLoader classLoader) {
        this.contextState = new XMLContextState(this, projects, classLoader);
    }

    public XMLContextState getXMLContextState() {
        return (XMLContextState)this.contextState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXMLContextState(XMLContextState xcs) {
        XMLContext xMLContext = this;
        synchronized (xMLContext) {
            this.contextState = xcs;
        }
    }

    public void addSession(DatabaseSession sessionToAdd) {
        this.getXMLContextState().addSession(sessionToAdd);
    }

    @Override
    public XMLUnmarshaller createUnmarshaller() {
        return new XMLUnmarshaller(this);
    }

    public XMLUnmarshaller createUnmarshaller(Map<String, Boolean> parserFeatures) {
        return new XMLUnmarshaller(this, parserFeatures);
    }

    public XMLBinder createBinder() {
        return new XMLBinder(this);
    }

    public XMLBinder createBinder(XMLMarshaller marshaller, XMLUnmarshaller unmarshaller) {
        return new XMLBinder(this, marshaller, unmarshaller);
    }

    @Override
    public XMLMarshaller createMarshaller() {
        return new XMLMarshaller(this);
    }

    public XMLValidator createValidator() {
        return new XMLValidator(this);
    }

    public AbstractSession getReadSession(Object object) {
        return this.getSession(object);
    }

    public AbstractSession getReadSession(Class clazz) {
        return (AbstractSession)super.getSession(clazz);
    }

    public AbstractSession getReadSession(XMLDescriptor xmlDescriptor) {
        return (AbstractSession)super.getSession(xmlDescriptor);
    }

    public List getSessions() {
        return this.getXMLContextState().getSessions();
    }

    @Override
    public DatabaseSession getSession(int index) {
        return this.getXMLContextState().getSession(index);
    }

    @Override
    public AbstractSession getSession(Object object) {
        return (AbstractSession)super.getSession(object);
    }

    @Override
    public AbstractSession getSession(Class clazz) {
        return (AbstractSession)super.getSession(clazz);
    }

    @Override
    public AbstractSession getSession(XMLDescriptor xmlDescriptor) {
        return (AbstractSession)super.getSession(xmlDescriptor);
    }

    public void storeXMLDescriptorByQName(XMLDescriptor xmlDescriptor) {
        this.contextState.storeDescriptorByQName(xmlDescriptor, null, null);
    }

    @Override
    public XMLDescriptor getDescriptor(QName qName) {
        return (XMLDescriptor)super.getDescriptor(qName);
    }

    @Override
    public XMLDescriptor getDescriptor(XPathQName xpathQName) {
        return (XMLDescriptor)super.getDescriptor(xpathQName);
    }

    public void addDescriptorByQName(QName qName, XMLDescriptor descriptor) {
        this.contextState.addDescriptorByQName(qName, descriptor);
    }

    @Override
    public XMLDescriptor getDescriptorByGlobalType(XPathFragment xPathFragment) {
        return (XMLDescriptor)super.getDescriptorByGlobalType(xPathFragment);
    }

    public DocumentPreservationPolicy getDocumentPreservationPolicy(AbstractSession session) {
        if (session == null) {
            return null;
        }
        XMLLogin login = (XMLLogin)session.getDatasourceLogin();
        return login.getDocumentPreservationPolicy();
    }

    public void setupDocumentPreservationPolicy(DatabaseSession session) {
        this.getXMLContextState().setupDocumentPreservationPolicy(session);
    }

    @Override
    public boolean hasDocumentPreservation() {
        return this.getXMLContextState().hasDocumentPreservation();
    }

    public void applyORMMetadata(AbstractSession ormSession) {
        for (ClassDescriptor ormDescriptor : ormSession.getDescriptors().values()) {
            Class javaClass = ormDescriptor.getJavaClass();
            AbstractSession oxmSession = null;
            try {
                oxmSession = this.getSession(javaClass);
            }
            catch (XMLMarshalException xMLMarshalException) {
                // empty catch block
            }
            if (oxmSession == null) continue;
            ClassDescriptor oxmDescriptor = oxmSession.getDescriptor(javaClass);
            for (DatabaseMapping ormMapping : ormDescriptor.getMappings()) {
                DatabaseMapping ormContainerMapping;
                ClassDescriptor containerDescriptor;
                Mapping oxmMapping = (Mapping)((Object)oxmDescriptor.getMappingForAttributeName(ormMapping.getAttributeName()));
                if (oxmMapping == null) continue;
                Object oxmAccessor = oxmMapping.getAttributeAccessor();
                OrmAttributeAccessor newAccessor = new OrmAttributeAccessor(ormMapping.getAttributeAccessor(), (CoreAttributeAccessor)oxmAccessor);
                if (ormMapping.isOneToOneMapping() && ((OneToOneMapping)ormMapping).usesIndirection()) {
                    newAccessor.setValueHolderProperty(true);
                }
                newAccessor.setChangeTracking(ormDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
                oxmMapping.setAttributeAccessor(newAccessor);
                CoreAttributeAccessor containerAccessor = null;
                Class containerClass = null;
                if (oxmMapping.isAbstractCompositeObjectMapping()) {
                    containerAccessor = (CoreAttributeAccessor)((CompositeObjectMapping)oxmMapping).getInverseReferenceMapping().getAttributeAccessor();
                    containerClass = ((CompositeObjectMapping)oxmMapping).getReferenceClass();
                } else if (oxmMapping.isAbstractCompositeCollectionMapping()) {
                    containerAccessor = (CoreAttributeAccessor)((CompositeCollectionMapping)oxmMapping).getInverseReferenceMapping().getAttributeAccessor();
                    containerClass = ((CompositeCollectionMapping)oxmMapping).getReferenceClass();
                }
                if (containerAccessor == null || (containerDescriptor = ormSession.getDescriptor(containerClass)) == null || (ormContainerMapping = containerDescriptor.getMappingForAttributeName(containerAccessor.getAttributeName())) == null) continue;
                OrmAttributeAccessor ormAccessor = new OrmAttributeAccessor(ormContainerMapping.getAttributeAccessor(), containerAccessor);
                ormAccessor.setChangeTracking(containerDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
                ormAccessor.setValueHolderProperty(ormContainerMapping instanceof OneToOneMapping && ((OneToOneMapping)ormContainerMapping).usesIndirection());
                if (oxmMapping.isAbstractCompositeObjectMapping()) {
                    ((CompositeObjectMapping)oxmMapping).getInverseReferenceMapping().setAttributeAccessor(ormAccessor);
                    continue;
                }
                if (!oxmMapping.isAbstractCompositeCollectionMapping()) continue;
                ((CompositeCollectionMapping)oxmMapping).getInverseReferenceMapping().setAttributeAccessor(ormAccessor);
            }
            for (DatabaseMapping nextMapping : oxmDescriptor.getMappings()) {
                DatabaseMapping backpointerMapping;
                ClassDescriptor refDescriptor;
                ObjectReferenceMapping refMapping;
                if (!(nextMapping instanceof ObjectReferenceMapping) || (refMapping = (ObjectReferenceMapping)((Object)nextMapping)).getInverseReferenceMapping().getAttributeAccessor() == null || refMapping.getInverseReferenceMapping().getContainerPolicy() == null || (refDescriptor = ormSession.getClassDescriptor(refMapping.getReferenceClass())) == null || (backpointerMapping = refDescriptor.getMappingForAttributeName(refMapping.getInverseReferenceMapping().getAttributeName())) == null || !backpointerMapping.isCollectionMapping()) continue;
                refMapping.getInverseReferenceMapping().getContainerPolicy().setContainerClass(((CollectionMapping)backpointerMapping).getContainerPolicy().getContainerClass());
            }
        }
    }

    @Override
    public <T> T getValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        return super.getValueByXPath(object, xPath, namespaceResolver, returnType);
    }

    @Override
    public void setValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Object value) {
        super.setValueByXPath(object, xPath, namespaceResolver, value);
    }

    public Object createByQualifiedName(String namespace, String typeName, boolean isGlobalType) throws IllegalArgumentException {
        QName qName = new QName(namespace, typeName);
        XMLDescriptor d2 = null;
        if (!isGlobalType) {
            d2 = this.getDescriptor(qName);
        } else {
            XPathFragment frag = new XPathFragment();
            frag.setNamespaceURI(namespace);
            frag.setLocalName(typeName);
            d2 = this.getDescriptorByGlobalType(frag);
        }
        if (d2 == null) {
            return null;
        }
        return ((InstantiationPolicy)d2.getInstantiationPolicy()).buildNewInstance();
    }

    @Override
    public <T> T createByXPath(Object parentObject, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        return super.createByXPath(parentObject, xPath, namespaceResolver, returnType);
    }

    @Override
    protected XMLField createField(String path) {
        if (path == null) {
            return new XMLField();
        }
        return new XMLField(path);
    }

    public List<Descriptor> getDescriptors() {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        List sessions = this.getSessions();
        for (Session session : sessions) {
            List<ClassDescriptor> orderedDescriptors = session.getProject().getOrderedDescriptors();
            for (Descriptor descriptor : orderedDescriptors) {
                descriptors.add(descriptor);
            }
        }
        return descriptors;
    }

    public ConversionManager getOxmConversionManager() {
        return (ConversionManager)((Object)((DatabaseSession)this.getSession()).getDatasourcePlatform().getConversionManager());
    }

    public Descriptor getDescriptorForObject(Object object) {
        AbstractSession session = this.getSession(object);
        if (session != null && session.getDescriptor(object) != null) {
            return (Descriptor)((Object)session.getDescriptor(object));
        }
        return null;
    }

    private static class XMLContextState
    extends Context.ContextState<AbstractSession, XMLDescriptor, Project, DatabaseSession, SessionEventListener> {
        private List<DatabaseSession> sessions;
        private boolean hasDocumentPreservation = false;

        protected XMLContextState(XMLContext xmlContext, Collection<Project> projects, ClassLoader classLoader) {
            this.context = xmlContext;
            this.sessions = new ArrayList<DatabaseSession>(projects.size());
            for (Project project : projects) {
                this.preLogin(project, classLoader);
                DatabaseSession session = project.createDatabaseSession();
                session.setLogLevel(8);
                this.setupSession(session);
                this.sessions.add(session);
                this.storeDescriptorsByQName(session);
            }
        }

        private XMLContextState(XMLContext xmlContext, String sessionNames, ClassLoader classLoader, String xmlResource) {
            this.context = xmlContext;
            XMLSessionConfigLoader loader = null;
            loader = xmlResource != null ? new XMLSessionConfigLoader(xmlResource) : new XMLSessionConfigLoader();
            this.descriptorsByQName = new HashMap();
            this.descriptorsByGlobalType = new HashMap();
            StringTokenizer st = new StringTokenizer(sessionNames, ":");
            this.sessions = new ArrayList<DatabaseSession>(st.countTokens());
            int index = 0;
            while (st.hasMoreTokens()) {
                this.sessions.add(this.buildSession(st.nextToken(), classLoader, loader));
                ++index;
            }
            int x2 = index - 1;
            while (x2 >= 0) {
                this.storeDescriptorsByQName(this.sessions.get(x2));
                --x2;
            }
        }

        protected XMLContextState(XMLContext xmlContext, Project project, ClassLoader classLoader, Collection<SessionEventListener> sessionEventListeners) {
            super(xmlContext, project, classLoader, sessionEventListeners);
        }

        private void addSession(DatabaseSession sessionToAdd) {
            if (sessionToAdd.getDatasourceLogin() == null || !(sessionToAdd.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                SAXPlatform platform = new SAXPlatform();
                sessionToAdd.setLogin(new XMLLogin(platform));
            }
            DatabaseSession session = sessionToAdd.getProject().createDatabaseSession();
            if (sessionToAdd.getEventManager().hasListeners()) {
                List<SessionEventListener> listeners = sessionToAdd.getEventManager().getListeners();
                int listenersSize = listeners.size();
                int x2 = 0;
                while (x2 < listenersSize) {
                    session.getEventManager().addListener(listeners.get(x2));
                    ++x2;
                }
            }
            session.setExceptionHandler(sessionToAdd.getExceptionHandler());
            session.setLogLevel(8);
            this.setupSession(session);
            if (this.sessions == null) {
                this.sessions = new ArrayList<DatabaseSession>();
            }
            if (this.session != null) {
                this.sessions.add((DatabaseSession)this.session);
            }
            this.sessions.add(session);
            this.storeDescriptorsByQName(session);
        }

        @Override
        protected void setupSession(DatabaseSession session) {
            session.setLogLevel(8);
            session.login();
            this.setupDocumentPreservationPolicy(session);
        }

        private DatabaseSession buildSession(String sessionName, ClassLoader classLoader, XMLSessionConfigLoader sessionLoader) throws XMLMarshalException {
            DatabaseSession dbSession = classLoader != null ? (DatabaseSession)((Object)SessionManager.getManager().getSession(sessionLoader, sessionName, classLoader, false, true)) : (DatabaseSession)((Object)SessionManager.getManager().getSession(sessionLoader, sessionName, PrivilegedAccessHelper.privilegedGetClassLoaderForClass(this.getClass()), false, false, false));
            if (dbSession.getDatasourceLogin() == null || !(dbSession.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                SAXPlatform platform = new SAXPlatform();
                dbSession.setLogin(new XMLLogin(platform));
            }
            DatabaseSession session = dbSession.getProject().createDatabaseSession();
            if (dbSession.getEventManager().hasListeners()) {
                List<SessionEventListener> listeners = dbSession.getEventManager().getListeners();
                int listenersSize = listeners.size();
                int x2 = 0;
                while (x2 < listenersSize) {
                    session.getEventManager().addListener(listeners.get(x2));
                    ++x2;
                }
            }
            session.setExceptionHandler(dbSession.getExceptionHandler());
            session.setLogLevel(8);
            this.setupDocumentPreservationPolicy(session);
            session.login();
            return session;
        }

        @Override
        protected DatabaseSession getSession() {
            if (this.sessions == null) {
                return (DatabaseSession)super.getSession();
            }
            return this.sessions.get(0);
        }

        @Override
        protected AbstractSession getSession(Class clazz) {
            if (clazz == null) {
                return null;
            }
            if (this.sessions == null) {
                return (AbstractSession)super.getSession(clazz);
            }
            int x2 = 0;
            int numberOfSessions = this.sessions.size();
            while (x2 < numberOfSessions) {
                AbstractSession next = (AbstractSession)((Object)this.sessions.get(x2));
                if (next.getDescriptor(clazz) != null) {
                    return next;
                }
                ++x2;
            }
            throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
        }

        @Override
        protected AbstractSession getSession(XMLDescriptor xmlDescriptor) {
            if (xmlDescriptor == null) {
                return null;
            }
            if (this.sessions == null) {
                return (AbstractSession)super.getSession(xmlDescriptor);
            }
            int x2 = 0;
            int numberOfSessions = this.sessions.size();
            while (x2 < numberOfSessions) {
                AbstractSession next = (AbstractSession)((Object)this.sessions.get(x2));
                if (next.getProject().getOrderedDescriptors().contains(xmlDescriptor)) {
                    return next;
                }
                ++x2;
            }
            throw XMLMarshalException.descriptorNotFoundInProject(xmlDescriptor.getJavaClass().getName());
        }

        private List<DatabaseSession> getSessions() {
            if (this.sessions == null) {
                return Collections.singletonList((DatabaseSession)this.session);
            }
            return this.sessions;
        }

        @Override
        private DatabaseSession getSession(int index) {
            if (this.sessions == null) {
                return (DatabaseSession)this.session;
            }
            return this.sessions.get(index);
        }

        @Override
        protected AbstractSession getSession(Object object) {
            if (object == null) {
                return null;
            }
            if (this.sessions == null) {
                return (AbstractSession)super.getSession(object);
            }
            int x2 = 0;
            int numberOfSessions = this.sessions.size();
            while (x2 < numberOfSessions) {
                AbstractSession next = (AbstractSession)((Object)this.sessions.get(x2));
                if (next.getDescriptor(object) != null) {
                    return next;
                }
                ++x2;
            }
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }

        private boolean hasDocumentPreservation() {
            return this.hasDocumentPreservation;
        }

        @Override
        protected void preLogin(Project project, ClassLoader classLoader) {
            if (project.getDatasourceLogin() == null || !(project.getDatasourceLogin().getDatasourcePlatform() instanceof XMLPlatform)) {
                SAXPlatform platform = new SAXPlatform();
                platform.getConversionManager().setLoader(classLoader);
                project.setLogin(new XMLLogin(platform));
            }
        }

        private void setupDocumentPreservationPolicy(DatabaseSession session) {
            XMLLogin login = (XMLLogin)session.getDatasourceLogin();
            if (login.getDocumentPreservationPolicy() == null) {
                for (Descriptor descriptor : session.getProject().getOrderedDescriptors()) {
                    if (!descriptor.shouldPreserveDocument()) continue;
                    login.setDocumentPreservationPolicy(new DescriptorLevelDocumentPreservationPolicy());
                    break;
                }
            }
            if (login.getDocumentPreservationPolicy() == null) {
                login.setDocumentPreservationPolicy(new NoDocumentPreservationPolicy());
            }
            login.getDocumentPreservationPolicy().initialize(this.context);
            if (login.getDocumentPreservationPolicy().shouldPreserveDocument() && !this.hasDocumentPreservation) {
                this.hasDocumentPreservation = true;
            }
        }
    }
}

