/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public abstract class AbstractColumnMapping
extends DatabaseMapping {
    protected DatabaseField field;
    protected Converter converter;
    protected String converterClassName;
    protected boolean isInsertable = true;
    protected boolean isUpdatable = true;

    public AbstractColumnMapping() {
        this.setWeight(WEIGHT_DIRECT);
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public Object clone() {
        AbstractColumnMapping clone = (AbstractColumnMapping)super.clone();
        clone.setField(this.getField().clone());
        return clone;
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        Vector<DatabaseField> databaseField = new Vector<DatabaseField>(1);
        databaseField.addElement(this.field);
        return databaseField;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.field != null) {
            this.field.convertClassNamesToClasses(classLoader);
        }
        this.convertConverterClassNamesToClasses(this.converter, classLoader);
        if (this.converterClassName != null) {
            Converter converter;
            block10: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        Class converterClass;
                        try {
                            converterClass = AccessController.doPrivileged(new PrivilegedClassForName(this.converterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, exception.getException());
                        }
                        try {
                            converter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(converterClass));
                            break block10;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, exception.getException());
                        }
                    }
                    Class converterClass = PrivilegedAccessHelper.getClassForName(this.converterClassName, true, classLoader);
                    converter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(converterClass);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, exc);
                }
                catch (Exception e2) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, e2);
                }
            }
            this.setConverter(converter);
        }
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
    }

    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    public abstract Object getFieldValue(Object var1, AbstractSession var2);

    public abstract Object getObjectValue(Object var1, Session var2);

    public boolean hasConverter() {
        return this.converter != null;
    }

    @Override
    public boolean isAbstractColumnMapping() {
        return true;
    }

    protected boolean isInsertable() {
        return this.isInsertable;
    }

    protected boolean isUpdatable() {
        return this.isUpdatable;
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        if (iterator.shouldIterateOnPrimitives()) {
            iterator.iteratePrimitiveForMapping(this.getAttributeValueFromObject(iterator.getVisitedParent()), this);
        }
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setConverterClassName(String converterClassName) {
        this.converterClassName = converterClassName;
    }

    public void setField(DatabaseField theField) {
        this.field = theField;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getAttributeName() + "-->" + this.getField() + "]";
    }

    protected abstract void writeValueIntoRow(AbstractRecord var1, DatabaseField var2, Object var3);
}

