/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.utility.iterator;

import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.jpql.utility.CollectionTools;

public class CloneListIterator<E>
implements ListIterator<E> {
    private int cursor;
    private final ListIterator<Object> listIterator;
    private final Mutator<E> mutator;
    private State state;

    public CloneListIterator(E[] array) {
        this(array, Mutator.ReadOnly.instance());
    }

    public CloneListIterator(E[] array, Mutator<E> mutator) {
        this(mutator, (Object[])array.clone());
    }

    public CloneListIterator(List<? extends E> list) {
        this(list, Mutator.ReadOnly.instance());
    }

    public CloneListIterator(List<? extends E> list, Mutator<E> mutator) {
        this(mutator, list.toArray());
    }

    protected CloneListIterator(Mutator<E> mutator, Object ... array) {
        this.listIterator = CollectionTools.list(array).listIterator();
        this.mutator = mutator;
        this.cursor = 0;
        this.state = State.UNKNOWN;
    }

    @Override
    public void add(E o2) {
        this.listIterator.add(o2);
        this.add(this.cursor, o2);
        ++this.cursor;
    }

    protected void add(int index, E o2) {
        this.mutator.add(index, o2);
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    protected E nestedNext() {
        return (E)this.listIterator.next();
    }

    protected E nestedPrevious() {
        return (E)this.listIterator.previous();
    }

    @Override
    public E next() {
        E next = this.nestedNext();
        ++this.cursor;
        this.state = State.NEXT;
        return next;
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public E previous() {
        E previous = this.nestedPrevious();
        --this.cursor;
        this.state = State.PREVIOUS;
        return previous;
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public void remove() {
        this.listIterator.remove();
        if (this.state == State.PREVIOUS) {
            this.remove(this.cursor);
        } else {
            --this.cursor;
            this.remove(this.cursor);
        }
    }

    protected void remove(int index) {
        this.mutator.remove(index);
    }

    @Override
    public void set(E o2) {
        this.listIterator.set(o2);
        if (this.state == State.PREVIOUS) {
            this.set(this.cursor, o2);
        } else {
            this.set(this.cursor - 1, o2);
        }
    }

    protected void set(int index, E o2) {
        this.mutator.set(index, o2);
    }

    public static interface Mutator<T> {
        public void add(int var1, T var2);

        public void remove(int var1);

        public void set(int var1, T var2);

        public static final class ReadOnly<S>
        implements Mutator<S>,
        Serializable {
            public static final Mutator INSTANCE = new ReadOnly();
            private static final long serialVersionUID = 1L;

            private ReadOnly() {
            }

            public static <R> Mutator<R> instance() {
                return INSTANCE;
            }

            @Override
            public void add(int index, Object o2) {
                throw new UnsupportedOperationException();
            }

            private Object readResolve() {
                return INSTANCE;
            }

            @Override
            public void remove(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(int index, Object o2) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static enum State {
        NEXT,
        PREVIOUS,
        UNKNOWN;

    }
}

