/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class FunctionExpressionFactory
extends ExpressionFactory {
    private ParameterCount parameterCount;
    private String parameterQueryBNFId;
    public static final String ID = "FUNCTION";

    public FunctionExpressionFactory(String id, ParameterCount parameterCount, String parameterQueryBNFId, String ... identifiers) {
        super(id, identifiers);
        this.setParameterCount(parameterCount);
        this.setParameterQueryBNFId(parameterQueryBNFId);
    }

    public FunctionExpressionFactory(String id, String ... identifiers) {
        this(id, ParameterCount.ZERO_OR_MANY, "function_item", identifiers);
    }

    @Override
    protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        String identifier = null;
        String[] stringArray = this.identifiers();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String possibleIdentifier = stringArray[n3];
            if (possibleIdentifier.equalsIgnoreCase(word)) {
                identifier = possibleIdentifier;
                break;
            }
            ++n3;
        }
        if (identifier == null) {
            return null;
        }
        if (ExpressionTools.isFunctionExpression(wordParser, identifier)) {
            expression = new FunctionExpression(parent, identifier, this.parameterCount, this.parameterQueryBNFId);
            expression.parse(wordParser, tolerant);
            return expression;
        }
        return null;
    }

    public void setParameterCount(ParameterCount parameterCount) {
        Assert.isNotNull((Object)parameterCount, "The ParameterCount cannot be null");
        this.parameterCount = parameterCount;
    }

    public void setParameterQueryBNFId(String parameterQueryBNFId) {
        Assert.isNotNull(parameterQueryBNFId, "The JPQLQueryBNF for the parameters cannot be null");
        this.parameterQueryBNFId = parameterQueryBNFId;
    }

    public static enum ParameterCount {
        ONE,
        ONE_OR_MANY,
        ZERO,
        ZERO_OR_MANY,
        ZERO_OR_ONE;

    }
}

