/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;

public class Util {
    public static final XMLPlatform XML_PLATFORM = XMLPlatformFactory.getInstance().getXMLPlatform();
    public static final Document TEMP_DOC = XML_PLATFORM.createDocument();
    public static final int OPAQUE = 2007;
    public static final String DEFAULT_ATTACHMENT_MIMETYPE = "application/octet-stream";
    public static final String WEB_INF_DIR = "WEB-INF/";
    public static final String WSDL_DIR = "wsdl/";
    public static final String[] META_INF_PATHS = new String[]{"META-INF/", "/META-INF/"};
    public static final String DBWS_SERVICE_XML = "eclipselink-dbws.xml";
    public static final String DBWS_OR_LABEL = "dbws-or";
    public static final String DBWS_OX_LABEL = "dbws-ox";
    public static final String DBWS_OR_XML = "eclipselink-dbws-or.xml";
    public static final String DBWS_OX_XML = "eclipselink-dbws-ox.xml";
    public static final String DBWS_SCHEMA_XML = "eclipselink-dbws-schema.xsd";
    public static final String DBWS_WSDL = "eclipselink-dbws.wsdl";
    public static final String DBWS_SESSIONS_XML = "eclipselink-dbws-sessions.xml";
    public static final String DBWS_OR_SESSION_NAME_SUFFIX = "dbws-or-session";
    public static final String DBWS_OX_SESSION_NAME_SUFFIX = "dbws-ox-session";
    public static final String TARGET_NAMESPACE_PREFIX = "ns1";
    public static final String SERVICE_NAMESPACE_PREFIX = "srvc";
    public static final String SERVICE_SUFFIX = "Service";
    public static final String ALL_QUERYNAME = "findAll";
    public static final String PK_QUERYNAME = "findByPrimaryKey";
    public static final String XMLTYPE_STR = "XMLTYPE";
    public static final String DOT_STR = ".";
    public static final String UNDERSCORE_STR = "_";
    public static final String TYPE_STR = "Type";
    public static final String COLLECTION_WRAPPER_STR = "CollectionWrapper";
    public static final String DASH_STR = "-";
    public static final String EMPTY_STR = "";
    public static final char COLON_CHAR = ':';
    public static final char SLASH_CHAR = '/';
    static final int[] chartype = new int[256];
    static final int FWHITESPACE = 1;
    static final int FDIGIT = 2;
    static final int FLETTER = 4;
    static final int FMISCNAME = 8;
    static final int FSTARTNAME = 16;
    public static final QName SXF_QNAME;
    public static final Map<QName, Class<?>> SCHEMA_2_CLASS;

    static {
        int i2 = 0;
        while (i2 < 256) {
            char c2 = (char)i2;
            Util.chartype[i2] = 0;
            if (c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n') {
                Util.chartype[i2] = 1;
            }
            if (Character.isLetter(c2)) {
                int n2 = i2;
                chartype[n2] = chartype[n2] | 4;
            }
            if (Character.isDigit(c2)) {
                int n3 = i2;
                chartype[n3] = chartype[n3] | 2;
            }
            ++i2;
        }
        chartype[46] = chartype[46] | 8;
        chartype[45] = chartype[45] | 8;
        chartype[95] = chartype[95] | 0x18;
        chartype[183] = chartype[183] | 8;
        SXF_QNAME = new QName(EMPTY_STR, "simple-xml-format");
        SCHEMA_2_CLASS = Collections.unmodifiableMap(new HashMap<QName, Class<?>>(){
            {
                this.put(Constants.ANY_SIMPLE_TYPE_QNAME, ClassConstants.Object_Class);
                this.put(Constants.BASE_64_BINARY_QNAME, ClassConstants.APBYTE);
                this.put(Constants.BOOLEAN_QNAME, ClassConstants.BOOLEAN);
                this.put(Constants.BYTE_QNAME, ClassConstants.BYTE);
                this.put(Constants.DATE_QNAME, ClassConstants.CALENDAR);
                this.put(Constants.DATE_TIME_QNAME, ClassConstants.CALENDAR);
                this.put(Constants.DECIMAL_QNAME, ClassConstants.BIGDECIMAL);
                this.put(Constants.DOUBLE_QNAME, ClassConstants.DOUBLE);
                this.put(Constants.DURATION_QNAME, ClassConstants.STRING);
                this.put(Constants.FLOAT_QNAME, ClassConstants.FLOAT);
                this.put(Constants.G_YEAR_MONTH_QNAME, ClassConstants.STRING);
                this.put(Constants.G_YEAR_QNAME, ClassConstants.STRING);
                this.put(Constants.G_MONTH_QNAME, ClassConstants.STRING);
                this.put(Constants.G_MONTH_DAY_QNAME, ClassConstants.STRING);
                this.put(Constants.G_DAY_QNAME, ClassConstants.STRING);
                this.put(Constants.HEX_BINARY_QNAME, ClassConstants.APBYTE);
                this.put(Constants.INT_QNAME, ClassConstants.INTEGER);
                this.put(Constants.INTEGER_QNAME, ClassConstants.BIGINTEGER);
                this.put(Constants.LONG_QNAME, ClassConstants.LONG);
                this.put(Constants.QNAME_QNAME, QName.class);
                this.put(Constants.SHORT_QNAME, ClassConstants.SHORT);
                this.put(Constants.STRING_QNAME, ClassConstants.STRING);
                this.put(Constants.TIME_QNAME, ClassConstants.CALENDAR);
                this.put(Constants.UNSIGNED_BYTE_QNAME, ClassConstants.SHORT);
                this.put(Constants.UNSIGNED_INT_QNAME, ClassConstants.LONG);
                this.put(Constants.UNSIGNED_SHORT_QNAME, ClassConstants.INTEGER);
            }
        });
    }

    public static String sqlToXmlName(String name) {
        int length = name.length();
        if (length == 0) {
            return name;
        }
        StringBuilder xmlName = new StringBuilder();
        int beginAt = 1;
        char firstChar = name.charAt(0);
        if (firstChar == ':') {
            xmlName.append("_x003A_");
        } else if (length >= 2 && name.substring(0, 2).equals("_x")) {
            xmlName.append("_x005F_");
        } else if (firstChar >= '\ud800' && firstChar < '\udc00') {
            if (length > 1) {
                xmlName.append(Util.hexEscape(firstChar << 16 | name.charAt(1) & 0xFFFF));
                beginAt = 2;
            } else {
                xmlName.append(Util.hexEscape(firstChar));
            }
        } else if (Util.isFirstNameChar(firstChar)) {
            xmlName.append(firstChar);
        } else {
            xmlName.append(Util.hexEscape(firstChar));
        }
        int x2 = beginAt;
        while (x2 < length) {
            char c2 = name.charAt(x2);
            if (c2 >= '\ud800' && c2 < '\udc00') {
                if (x2 + 1 < length) {
                    xmlName.append(Util.hexEscape(c2 << 16 | name.charAt(x2 + 1) & 0xFFFF));
                    ++x2;
                } else {
                    xmlName.append(Util.hexEscape(c2));
                }
            } else if (!Util.isNameChar(c2)) {
                xmlName.append(Util.hexEscape(c2));
            } else {
                xmlName.append(c2);
            }
            ++x2;
        }
        return xmlName.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String xmlToSqlName(String name) {
        sqlName = "";
        length = name.length();
        unescapeMode = false;
        hexString = null;
        x = 0;
        while (x < length) {
            c = name.charAt(x);
            if (unescapeMode) {
                if (c >= 'A' && c <= 'F' || c >= '0' && c <= '9') {
                    hexString = String.valueOf(hexString) + c;
                } else if (c == '_') {
                    unescapeMode = false;
                    if (hexString != null) {
                        len = hexString.length();
                        if (len > 4) {
                            i1 = (char)Integer.parseInt(hexString.substring(0, len - 4), 16);
                            i2 = (char)Integer.parseInt(hexString.substring(len - 4), 16);
                            sqlName = String.valueOf(sqlName) + i1;
                            sqlName = String.valueOf(sqlName) + i2;
                        } else {
                            try {
                                i = Integer.parseInt(hexString, 16);
                                if (i == 65535) ** GOTO lbl39
                                sqlName = String.valueOf(sqlName) + (char)i;
                            }
                            catch (NumberFormatException nfe) {
                                throw new RuntimeException(nfe);
                            }
                        }
                    }
                } else {
                    sqlName = String.valueOf(sqlName) + "_x" + hexString + c;
                    unescapeMode = false;
                }
            } else if (c == '_' && x + 1 < length && name.charAt(x + 1) == 'x') {
                unescapeMode = true;
                hexString = "";
                ++x;
            } else {
                sqlName = String.valueOf(sqlName) + c;
            }
lbl39:
            // 8 sources

            ++x;
        }
        return sqlName;
    }

    public static String hexEscape(char c2) {
        String outPutString = Integer.toHexString(c2);
        switch (outPutString.length()) {
            case 1: {
                outPutString = "_x000" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 2: {
                outPutString = "_x00" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 3: {
                outPutString = "_x0" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 4: {
                outPutString = "_x" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
            }
        }
        return outPutString;
    }

    public static String hexEscape(int c2) {
        String outPutString = Integer.toHexString(c2);
        switch (outPutString.length()) {
            case 1: 
            case 5: {
                outPutString = "_x000" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 2: 
            case 6: {
                outPutString = "_x00" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 3: 
            case 7: {
                outPutString = "_x0" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
                break;
            }
            case 4: 
            case 8: {
                outPutString = "_x" + outPutString.toUpperCase(Locale.US) + UNDERSCORE_STR;
            }
        }
        return outPutString;
    }

    public static boolean isNameChar(char c2) {
        boolean res = c2 < '\u0100' ? (chartype[c2] & 0xE) != 0 : (c2 >= '\u2180' && c2 <= '\u2182' || c2 >= '\u3041' && c2 <= '\u3094' || c2 >= '\u30a1' && c2 <= '\u30fa' || c2 >= '\u3105' && c2 <= '\u312c' || c2 >= '\uac00' && c2 <= '\ud7a3' || c2 >= '\u0e47' && c2 <= '\u0e4e' ? true : c2 != '\u02ff' && c2 != '\u0346' && c2 != '\u0362' && c2 != '\u0487' && c2 != '\u05a2' && c2 != '\u05ba' && c2 != '\u05be' && c2 != '\u05c0' && c2 != '\u05c3' && c2 != '\u0653' && c2 != '\u06b8' && c2 != '\u06b9' && c2 != '\u06e9' && c2 != '\u06ee' && c2 != '\u0904' && c2 != '\u093b' && c2 != '\u094e' && c2 != '\u0955' && c2 != '\u0964' && c2 != '\u0984' && c2 != '\u09c5' && c2 != '\u09c9' && c2 != '\u09ce' && c2 != '\u09d8' && c2 != '\u09e4' && c2 != '\u0a03' && c2 != '\u0a3d' && c2 != '\u0a46' && c2 != '\u0a49' && c2 != '\u0a4e' && c2 != '\u0a80' && c2 != '\u0a84' && c2 != '\u0abb' && c2 != '\u0ac6' && c2 != '\u0aca' && c2 != '\u0ace' && c2 != '\u0b04' && c2 != '\u0b3b' && c2 != '\u0b44' && c2 != '\u0b4a' && c2 != '\u0b4e' && c2 != '\u0b58' && c2 != '\u0b84' && c2 != '\u0bc3' && c2 != '\u0bc9' && c2 != '\u0bd6' && c2 != '\u0c0d' && c2 != '\u0c45' && c2 != '\u0c49' && c2 != '\u0c54' && c2 != '\u0c81' && c2 != '\u0c84' && c2 != '\u0cc5' && c2 != '\u0cc9' && c2 != '\u0cd4' && c2 != '\u0cd7' && c2 != '\u0d04' && c2 != '\u0d45' && c2 != '\u0d49' && c2 != '\u0d4e' && c2 != '\u0d58' && c2 != '\u0e3f' && c2 != '\u0e3b' && c2 != '\u0e4f' && c2 != '\u0eba' && c2 != '\u0ebe' && c2 != '\u0ece' && c2 != '\u0f1a' && c2 != '\u0f36' && c2 != '\u0f38' && c2 != '\u0f3b' && c2 != '\u0f3a' && c2 != '\u0f70' && c2 != '\u0f85' && c2 != '\u0f8c' && c2 != '\u0f96' && c2 != '\u0f98' && c2 != '\u0fb0' && c2 != '\u0fb8' && c2 != '\u0fba' && c2 != '\u20dd' && c2 != '\u20e2' && c2 != '\u3030' && c2 != '\u309b' && c2 != '\u066a' && c2 != '\u06fa' && c2 != '\u0970' && c2 != '\u09f2' && c2 != '\u0af0' && c2 != '\u0b70' && c2 != '\u0c65' && c2 != '\u0ce5' && c2 != '\u0cf0' && c2 != '\u0d70' && c2 != '\u0e5a' && c2 != '\u0eda' && c2 != '\u0f2a' && c2 != '\u02d2' && c2 != '\u03fe' && c2 != '\u065f' && c2 != '\u0e5c' && c2 != '\u0c04');
        return res;
    }

    public static boolean isFirstNameChar(char c2) {
        boolean res = c2 < '\u0100' ? (chartype[c2] & 0x14) != 0 : (c2 >= '\u2180' && c2 <= '\u2182' || c2 == '\u3007' || c2 >= '\u3021' && c2 <= '\u3029' || c2 >= '\u3041' && c2 <= '\u3094' || c2 >= '\u30a1' && c2 <= '\u30fa' || c2 >= '\u3105' && c2 <= '\u312c' || c2 >= '\uac00' && c2 <= '\ud7a3' ? true : c2 != '\u1101' && c2 != '\u1104' && c2 != '\u1108' && c2 != '\u110a' && c2 != '\u110d' && c2 != '\u113b' && c2 != '\u1141' && c2 != '\u114d' && c2 != '\u114f' && c2 != '\u1151' && c2 != '\u1156' && c2 != '\u1162' && c2 != '\u1164' && c2 != '\u1166' && c2 != '\u116b' && c2 != '\u116f' && c2 != '\u1174' && c2 != '\u119f' && c2 != '\u11ac' && c2 != '\u11b6' && c2 != '\u11b9' && c2 != '\u11bb' && c2 != '\u11c3' && c2 != '\u11f1' && c2 != '\u0132' && c2 != '\u0133' && c2 != '\u013f' && c2 != '\u0140' && c2 != '\u0149' && c2 != '\u017f' && c2 != '\u01c4' && c2 != '\u01cc' && c2 != '\u01f1' && c2 != '\u01f3' && c2 != '\u0e46' && c2 != '\u113f' && c2 != '\u01f6' && c2 != '\u01f9' && c2 != '\u0230' && c2 != '\u03d7' && c2 != '\u03dd' && c2 != '\u03e1' && c2 != '\u040d' && c2 != '\u0450' && c2 != '\u045d' && c2 != '\u04ec' && c2 != '\u04ed' && c2 != '\u06b8' && c2 != '\u06bf' && c2 != '\u06cf' && c2 != '\u0e2f' && c2 != '\u0eaf' && c2 != '\u0f6a' && c2 != '\u4cff' && c2 != '\u212f' && c2 != '\u0587');
        return res;
    }

    public static Class<?> getClassFromJDBCType(String typeName, DatabasePlatform databasePlatform) {
        Class clz = databasePlatform.getClassTypes().get(typeName);
        if (clz == null) {
            return ClassConstants.Object_Class;
        }
        return clz;
    }

    public static String getTypeNameForJDBCType(int jdbcType) {
        String typeName = null;
        switch (jdbcType) {
            case 2007: 
            case 2009: {
                typeName = XMLTYPE_STR;
                break;
            }
        }
        return typeName;
    }

    public static int getJDBCTypeForTypeName(String typeName) {
        int typeCode = -1;
        if (typeName.equals(XMLTYPE_STR)) {
            typeCode = 2007;
        }
        return typeCode;
    }
}

