/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ValueReadQuery;

public abstract class QueryHandler {
    protected DatabaseQuery databaseQuery;

    public DatabaseQuery getDatabaseQuery() {
        return this.databaseQuery;
    }

    public void setDatabaseQuery(DatabaseQuery databaseQuery) {
        this.databaseQuery = databaseQuery;
    }

    public void validate(XRServiceAdapter xrService, QueryOperation queryOperation) {
    }

    public void initialize(XRServiceAdapter xrService, QueryOperation queryOperation) {
        this.initializeDatabaseQuery(xrService, queryOperation);
        this.initializeCall(xrService, queryOperation, this.getDatabaseQuery());
        this.initializeArguments(xrService, queryOperation, this.getDatabaseQuery());
    }

    public void initializeDatabaseQuery(XRServiceAdapter xrService, QueryOperation queryOperation) {
        DatabaseQuery databaseQueryToInitialize;
        if (queryOperation.hasResponse()) {
            QName type = queryOperation.getResult().getType();
            databaseQueryToInitialize = queryOperation.isCollection() ? (queryOperation.isSimpleXMLFormat() || xrService.descriptorsByQName.containsKey(type) && xrService.getORSession().getClassDescriptorForAlias(xrService.descriptorsByQName.get(type).getAlias()).isAggregateDescriptor() && !xrService.getORSession().getClassDescriptorForAlias(xrService.descriptorsByQName.get(type).getAlias()).isObjectRelationalDataTypeDescriptor() ? new DataReadQuery() : (!xrService.descriptorsByQName.containsKey(type) ? new DataReadQuery() : new ReadAllQuery(xrService.getTypeClass(type)))) : (queryOperation.isSimpleXMLFormat() || xrService.descriptorsByQName.containsKey(type) && xrService.getORSession().getClassDescriptorForAlias(xrService.descriptorsByQName.get(type).getAlias()).isAggregateDescriptor() && !xrService.getORSession().getClassDescriptorForAlias(xrService.descriptorsByQName.get(type).getAlias()).isObjectRelationalDataTypeDescriptor() ? new DataReadQuery() : (!xrService.descriptorsByQName.containsKey(type) ? new ValueReadQuery() : new ReadObjectQuery(xrService.getTypeClass(type))));
        } else {
            databaseQueryToInitialize = new DataModifyQuery();
        }
        databaseQueryToInitialize.bindAllParameters();
        this.setDatabaseQuery(databaseQueryToInitialize);
    }

    public void initializeCall(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
    }

    public void initializeArguments(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
        int i2 = 0;
        while (i2 < queryOperation.getParameters().size()) {
            Parameter p2;
            String name;
            Parameter o2 = queryOperation.getParameters().get(i2);
            if (o2 instanceof Parameter && (name = (p2 = o2).getName()) != null && name.length() > 0) {
                databaseQuery.addArgument(name);
            } else {
                String s2 = Integer.toString(i2 + 1);
                databaseQuery.addArgument(s2);
            }
            ++i2;
        }
    }
}

