/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] nArray) {
        int n2 = nArray.length;
        if (n2 <= 1) {
            return 0.0;
        }
        double d2 = Stats.avg(nArray);
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += ((double)nArray[i2] - d2) * ((double)nArray[i2] - d2);
        }
        return Math.sqrt(d3 /= (double)(n2 - 1));
    }

    public static double avg(int[] nArray) {
        double d2 = 0.0;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += (double)nArray[i2];
        }
        if (d2 >= 0.0) {
            return d2 / (double)n2;
        }
        return 0.0;
    }

    public static int min(int[] nArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = nArray.length;
        if (n3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] >= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static int max(int[] nArray) {
        int n2 = Integer.MIN_VALUE;
        int n3 = nArray.length;
        if (n3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] <= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static double avg(List<Integer> list) {
        double d2 = 0.0;
        int n2 = list.size();
        if (n2 == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += (double)list.get(i2).intValue();
        }
        if (d2 >= 0.0) {
            return d2 / (double)n2;
        }
        return 0.0;
    }

    public static int min(List<Integer> list) {
        int n2 = Integer.MAX_VALUE;
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (list.get(i2) >= n2) continue;
            n2 = list.get(i2);
        }
        return n2;
    }

    public static int max(List<Integer> list) {
        int n2 = Integer.MIN_VALUE;
        int n3 = list.size();
        if (n3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (list.get(i2) <= n2) continue;
            n2 = list.get(i2);
        }
        return n2;
    }

    public static int sum(int[] nArray) {
        int n2 = 0;
        int n3 = nArray.length;
        if (n3 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += nArray[i2];
        }
        return n2;
    }

    public static void writeReport(String string, String string2) throws IOException {
        String string3 = Stats.getAbsoluteFileName(string);
        File file = new File(string3);
        File file2 = file.getParentFile();
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file, true);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        PrintStream printStream = new PrintStream(bufferedOutputStream);
        printStream.println(string2);
        printStream.close();
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    public static String getAbsoluteFileName(String string) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + string;
    }
}

