/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.modelgen.LoggerContext;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.ElementVisitor;
import org.eclipse.persistence.logging.LogCategory;
import org.eclipse.persistence.logging.LogLevel;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;

public class MetadataMirrorFactory
extends MetadataFactory {
    private ElementVisitor<MetadataClass, MetadataClass> elementVisitor;
    private Map<String, PersistenceUnit> persistenceUnits;
    private Map<String, MetadataProject> metadataProjects;
    private Map<Element, MetadataClass> roundElements;
    private HashSet<MetadataClass> roundMetadataClasses;
    private ProcessingEnvironment processingEnv;
    private final LoggerContext loggerContext;

    protected MetadataMirrorFactory(MetadataLogger logger, LoggerContext loggerContext, ClassLoader loader) {
        super(logger, loader);
        this.loggerContext = loggerContext;
        this.roundElements = new HashMap<Element, MetadataClass>();
        this.roundMetadataClasses = new HashSet();
        this.persistenceUnits = new HashMap<String, PersistenceUnit>();
        this.metadataProjects = new HashMap<String, MetadataProject>();
    }

    public void addPersistenceUnit(SEPersistenceUnitInfo puInfo, PersistenceUnit persistenceUnit) {
        this.persistenceUnits.put(puInfo.getPersistenceUnitName(), persistenceUnit);
    }

    public MetadataClass getMetadataClass(Element element) {
        MetadataClass metadataClass = this.roundElements.get(element);
        if (metadataClass == null) {
            if (this.isRoundElement(element)) {
                if (this.m_logger.shouldLog(LogLevel.FINE, LogCategory.PROCESSOR)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Building metadata class for round element: " + element);
                }
                metadataClass = new MetadataClass((MetadataFactory)this, "");
                this.roundElements.put(element, metadataClass);
                this.roundMetadataClasses.add(metadataClass);
                element.accept(this.elementVisitor, metadataClass);
                this.addMetadataClass(metadataClass);
            } else {
                String name = element.toString();
                if (this.metadataClassExists(name)) {
                    return this.getMetadataClass(name);
                }
                if (element instanceof TypeElement || element instanceof TypeParameterElement) {
                    if (element instanceof TypeElement) {
                        if (this.m_logger.shouldLog(LogLevel.FINE, LogCategory.PROCESSOR)) {
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Building metadata class for type element: " + name);
                        }
                        metadataClass = new MetadataClass((MetadataFactory)this, name);
                        this.addMetadataClass(metadataClass);
                        element.accept(this.elementVisitor, metadataClass);
                        this.addMetadataClass(metadataClass);
                    } else {
                        if (this.m_logger.shouldLog(LogLevel.FINE, LogCategory.PROCESSOR)) {
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Building type parameter element: " + name);
                        }
                        metadataClass = new MetadataClass((MetadataFactory)this, name);
                        this.addMetadataClass(metadataClass);
                        element.accept(this.elementVisitor, metadataClass);
                        this.addMetadataClass(metadataClass);
                    }
                } else {
                    metadataClass = this.getMetadataClass(element.toString());
                }
            }
        }
        return metadataClass;
    }

    @Override
    public MetadataClass getMetadataClass(String className, boolean isLazy) {
        return this.getMetadataClass(className);
    }

    @Override
    public MetadataClass getMetadataClass(String className) {
        if (className == null) {
            return null;
        }
        if (!this.metadataClassExists(className)) {
            this.addMetadataClass(new MetadataClass((MetadataFactory)this, className));
        }
        return this.getMetadataClasses().get(className);
    }

    public MetadataClass getMetadataClass(TypeMirror typeMirror) {
        Element element = this.processingEnv.getTypeUtils().asElement(typeMirror);
        if (element == null) {
            return this.getMetadataClass(typeMirror.toString());
        }
        return this.getMetadataClass(element);
    }

    public MetadataProject getMetadataProject(SEPersistenceUnitInfo puInfo) {
        if (!this.metadataProjects.containsKey(puInfo.getPersistenceUnitName())) {
            MetadataProject project = new MetadataProject(puInfo, new ServerSession(new Project(new DatabaseLogin())), false, false, false, false, false);
            this.metadataProjects.put(puInfo.getPersistenceUnitName(), project);
            return project;
        }
        return this.metadataProjects.get(puInfo.getPersistenceUnitName());
    }

    public Collection<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits.values();
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    public Map<Element, MetadataClass> getRoundElements() {
        return this.roundElements;
    }

    public boolean isRoundElement(Element element) {
        return this.roundElements.containsKey(element);
    }

    public boolean isRoundElement(MetadataClass cls) {
        return this.roundMetadataClasses.contains(cls);
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    @Override
    public void resolveGenericTypes(MetadataClass child, List<String> genericTypes, MetadataClass parent, MetadataDescriptor descriptor) {
    }

    public void setEnvironments(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnvironment) {
        this.processingEnv = processingEnvironment;
        this.roundElements.clear();
        this.roundMetadataClasses.clear();
        if (this.elementVisitor == null) {
            this.elementVisitor = new ElementVisitor(this.processingEnv);
        }
        for (Element element : roundEnvironment.getRootElements()) {
            if (!element.getKind().isClass()) continue;
            boolean isGenerated = false;
            List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                Name qn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
                if (!"javax.annotation.Generated".equals(qn) && !"javax.annotation.processing.Generated".equals(qn)) continue;
                isGenerated = true;
                break;
            }
            if (isGenerated) continue;
            this.roundElements.put(element, null);
        }
        for (Element element : this.roundElements.keySet()) {
            this.getMetadataClass(element);
        }
    }
}

