/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.RelationalTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class JoinTableMetadata
extends RelationalTableMetadata {
    private ForeignKeyMetadata m_inverseForeignKey;
    private List<JoinColumnMetadata> m_inverseJoinColumns = new ArrayList<JoinColumnMetadata>();

    public JoinTableMetadata() {
        super("<join-table>");
    }

    public JoinTableMetadata(MetadataAccessor accessor) {
        super(null, accessor);
    }

    public JoinTableMetadata(MetadataAnnotation joinTable, MetadataAccessor accessor) {
        super(joinTable, accessor);
        if (joinTable != null) {
            Object[] objectArray = joinTable.getAttributeArray("inverseJoinColumns");
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object inverseJoinColumn = objectArray[n3];
                this.m_inverseJoinColumns.add(new JoinColumnMetadata((MetadataAnnotation)inverseJoinColumn, accessor));
                ++n3;
            }
            if (joinTable.hasAttribute("inverseForeignKey")) {
                this.m_inverseForeignKey = new ForeignKeyMetadata(joinTable.getAttributeAnnotation("inverseForeignKey"), accessor);
            }
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof JoinTableMetadata) {
            JoinTableMetadata joinTable = (JoinTableMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_inverseJoinColumns, this.getInverseJoinColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_inverseForeignKey, joinTable.getInverseForeignKey());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.m_inverseForeignKey != null ? this.m_inverseForeignKey.hashCode() : 0;
        result = 31 * result + (this.m_inverseJoinColumns != null ? this.m_inverseJoinColumns.hashCode() : 0);
        return result;
    }

    @Override
    public String getCatalogContext() {
        return "metadata_default_join_table_catalog";
    }

    public ForeignKeyMetadata getInverseForeignKey() {
        return this.m_inverseForeignKey;
    }

    public List<JoinColumnMetadata> getInverseJoinColumns() {
        return this.m_inverseJoinColumns;
    }

    @Override
    public String getNameContext() {
        return "metadata_default_join_table_name";
    }

    @Override
    public String getSchemaContext() {
        return "metadata_default_join_table_schema";
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_inverseForeignKey, accessibleObject);
        this.initXMLObjects(this.m_inverseJoinColumns, accessibleObject);
    }

    @Override
    public void processForeignKey() {
        super.processForeignKey();
        if (this.m_inverseForeignKey != null) {
            this.m_inverseForeignKey.process(this.getDatabaseTable());
        }
    }

    public void setInverseForeignKey(ForeignKeyMetadata inverseForeignKey) {
        this.m_inverseForeignKey = inverseForeignKey;
    }

    public void setInverseJoinColumns(List<JoinColumnMetadata> inverseJoinColumns) {
        this.m_inverseJoinColumns = inverseJoinColumns;
    }
}

