/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListener;

public class EntityClassListener<T>
extends EntityListener<T> {
    public EntityClassListener(Class entityClass) {
        super(entityClass);
    }

    @Override
    public void addEventMethod(String event, Method method) {
        if (!this.hasOverriddenEventMethod(method, event)) {
            super.addEventMethod(event, method);
        }
    }

    @Override
    public Class getListenerClass() {
        return this.getEntityClass();
    }

    @Override
    protected void invokeMethod(String event, DescriptorEvent descriptorEvent) {
        if (this.hasEventMethods(event)) {
            List<Method> eventMethods = this.getEventMethods(event);
            int i2 = eventMethods.size() - 1;
            while (i2 >= 0) {
                Method method = eventMethods.get(i2);
                Object[] objectList = new Object[]{};
                this.invokeMethod(method, descriptorEvent.getObject(), objectList);
                --i2;
            }
        }
    }

    @Override
    protected void validateMethod(Method method) {
        if (method.getParameterTypes().length > 0) {
            throw ValidationException.invalidEntityCallbackMethodArguments(this.getEntityClass(), method.getName());
        }
        this.validateMethodModifiers(method);
    }
}

