/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class ProxyIndirectionHandler
implements InvocationHandler,
Serializable {
    private ValueHolderInterface valueHolder;

    public ProxyIndirectionHandler() {
    }

    private ProxyIndirectionHandler(ValueHolderInterface valueHolder) {
        this.valueHolder = valueHolder;
    }

    @Override
    public Object invoke(Object proxy, Method m2, Object[] args) throws Throwable {
        Object result = null;
        try {
            if (m2.getName().equals("toString")) {
                if (this.valueHolder.isInstantiated()) {
                    if (this.valueHolder.getValue() == null) {
                        result = "null";
                    } else if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        String toString = (String)AccessController.doPrivileged(new PrivilegedMethodInvoker(m2, this.valueHolder.getValue(), args));
                        result = "{ " + toString + " }";
                    } else {
                        String toString = (String)PrivilegedAccessHelper.invokeMethod(m2, this.valueHolder.getValue(), args);
                        result = "{ " + toString + " }";
                    }
                } else {
                    result = "{ IndirectProxy: not instantiated }";
                }
            } else if (m2.getName().equals("equals") && this.valueHolder.getValue() == null && args[0] == null) {
                result = Boolean.TRUE;
            } else {
                Object value = this.valueHolder.getValue();
                if (value == null) {
                    throw ValidationException.nullUnderlyingValueHolderValue(m2.getName());
                }
                result = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedMethodInvoker(m2, value, args)) : PrivilegedAccessHelper.invokeMethod(m2, value, args);
            }
        }
        catch (InvocationTargetException e2) {
            throw e2.getTargetException();
        }
        catch (ValidationException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw QueryException.unexpectedInvocation(e4.getMessage());
        }
        return result;
    }

    public static Object newProxyInstance(Class anInterface, Class[] interfaces, ValueHolderInterface valueHolder) {
        ClassLoader classLoader = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                classLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(anInterface));
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getCause();
            }
        } else {
            classLoader = PrivilegedAccessHelper.getClassLoaderForClass(anInterface);
        }
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ProxyIndirectionHandler(valueHolder));
    }

    public ValueHolderInterface getValueHolder() {
        return this.valueHolder;
    }

    public void setValueHolder(ValueHolderInterface value) {
        this.valueHolder = value;
    }
}

