/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;

public class NonSynchronizedVector
extends Vector {
    public static NonSynchronizedVector newInstance(int initialCapacity, int capacityIncrement) {
        return new NonSynchronizedVector(initialCapacity, capacityIncrement);
    }

    public static NonSynchronizedVector newInstance(int initialCapacity) {
        return new NonSynchronizedVector(initialCapacity);
    }

    public static NonSynchronizedVector newInstance() {
        return new NonSynchronizedVector();
    }

    public static NonSynchronizedVector newInstance(Collection c2) {
        return new NonSynchronizedVector(c2);
    }

    public NonSynchronizedVector(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public NonSynchronizedVector(int initialCapacity) {
        super(initialCapacity);
    }

    public NonSynchronizedVector() {
    }

    public NonSynchronizedVector(Collection c2) {
        super(c2);
    }

    @Override
    public void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    @Override
    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        this.ensureCapacityHelper(minCapacity);
    }

    private void ensureCapacityHelper(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            Object[] oldData = this.elementData;
            int n2 = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    @Override
    public void setSize(int newSize) {
        ++this.modCount;
        if (newSize > this.elementCount) {
            this.ensureCapacityHelper(newSize);
        } else {
            int i2 = newSize;
            while (i2 < this.elementCount) {
                this.elementData[i2] = null;
                ++i2;
            }
        }
        this.elementCount = newSize;
    }

    @Override
    public int capacity() {
        return this.elementData.length;
    }

    @Override
    public Object clone() {
        return new NonSynchronizedVector((Collection)this);
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < NonSynchronizedVector.this.elementCount;
            }

            public Object nextElement() {
                if (this.count < NonSynchronizedVector.this.elementCount) {
                    return NonSynchronizedVector.this.elementData[this.count++];
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public int indexOf(Object elem, int index) {
        if (elem == null) {
            int i2 = index;
            while (i2 < this.elementCount) {
                if (this.elementData[i2] == null) {
                    return i2;
                }
                ++i2;
            }
        } else {
            int i3 = index;
            while (i3 < this.elementCount) {
                if (elem.equals(this.elementData[i3])) {
                    return i3;
                }
                ++i3;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    @Override
    public int lastIndexOf(Object elem, int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        if (elem == null) {
            int i2 = index;
            while (i2 >= 0) {
                if (this.elementData[i2] == null) {
                    return i2;
                }
                --i2;
            }
        } else {
            int i3 = index;
            while (i3 >= 0) {
                if (elem.equals(this.elementData[i3])) {
                    return i3;
                }
                --i3;
            }
        }
        return -1;
    }

    public Object elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    public Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public void setElementAt(Object obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    @Override
    public void removeElementAt(int index) {
        ++this.modCount;
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j2 = this.elementCount - index - 1;
        if (j2 > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public void insertElementAt(Object obj, int index) {
        ++this.modCount;
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public void addElement(Object obj) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = obj;
    }

    @Override
    public boolean removeElement(Object obj) {
        ++this.modCount;
        int i2 = this.indexOf(obj);
        if (i2 >= 0) {
            this.removeElementAt(i2);
            return true;
        }
        return false;
    }

    @Override
    public void removeAllElements() {
        ++this.modCount;
        int i2 = 0;
        while (i2 < this.elementCount) {
            this.elementData[i2] = null;
            ++i2;
        }
        this.elementCount = 0;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, result, 0, this.elementCount);
        return result;
    }

    @Override
    public Object[] toArray(Object[] a2) {
        if (a2.length < this.elementCount) {
            a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, a2, 0, this.elementCount);
        if (a2.length > this.elementCount) {
            a2[this.elementCount] = null;
        }
        return a2;
    }

    @Override
    public Object get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elementData[index];
    }

    @Override
    public Object set(int index, Object element) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Object oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public boolean add(Object o2) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = o2;
        return true;
    }

    @Override
    public Object remove(int index) {
        ++this.modCount;
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Object oldValue = this.elementData[index];
        int numMoved = this.elementCount - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.elementCount] = null;
        return oldValue;
    }

    @Override
    public boolean containsAll(Collection c2) {
        Iterator e2 = c2.iterator();
        while (e2.hasNext()) {
            if (this.contains(e2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c2) {
        ++this.modCount;
        Object[] a2 = c2.toArray();
        int numNew = a2.length;
        this.ensureCapacityHelper(this.elementCount + numNew);
        System.arraycopy(a2, 0, this.elementData, this.elementCount, numNew);
        this.elementCount += numNew;
        return numNew != 0;
    }

    @Override
    public boolean removeAll(Collection c2) {
        boolean modified = false;
        Iterator e2 = this.iterator();
        while (e2.hasNext()) {
            if (!c2.contains(e2.next())) continue;
            e2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection c2) {
        boolean modified = false;
        Iterator e2 = this.iterator();
        while (e2.hasNext()) {
            if (c2.contains(e2.next())) continue;
            e2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection c2) {
        ++this.modCount;
        if (index < 0 || index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Object[] a2 = c2.toArray();
        int numNew = a2.length;
        this.ensureCapacityHelper(this.elementCount + numNew);
        int numMoved = this.elementCount - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a2, 0, this.elementData, index, numNew);
        this.elementCount += numNew;
        return numNew != 0;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        List list = (List)o2;
        int size = this.size();
        if (list.size() != size) {
            return false;
        }
        int index = 0;
        while (index < size) {
            Object right;
            Object left = this.get(index);
            if (!(left == (right = list.get(index)) || left != null && right != null && left.equals(right))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int size = this.size();
        int index = 0;
        while (index < size) {
            Object obj = this.get(index);
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            ++index;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        Iterator e2 = this.iterator();
        buf.append("[");
        int maxIndex = this.size() - 1;
        int i2 = 0;
        while (i2 <= maxIndex) {
            buf.append(String.valueOf(e2.next()));
            if (i2 < maxIndex) {
                buf.append(", ");
            }
            ++i2;
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.elementCount - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newElementCount = this.elementCount - (toIndex - fromIndex);
        while (this.elementCount != newElementCount) {
            this.elementData[--this.elementCount] = null;
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        return new NonSynchronizedSubVector(this, fromIndex, toIndex);
    }
}

