/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class DescriptorHelper {
    private DescriptorHelper() {
        throw new UnsupportedOperationException("Instances of DescriptorHelper are not allowed");
    }

    public static void buildColsFromMappings(StringBuilder target, Collection<DatabaseMapping> mappings, String separator) {
        Iterator<DatabaseMapping> i2 = mappings.iterator();
        while (i2.hasNext()) {
            target.append(i2.next().getField().getName());
            if (!i2.hasNext()) continue;
            target.append(separator);
        }
    }

    public static void buildValuesAsQMarksFromMappings(StringBuilder target, Collection<DatabaseMapping> mappings, String separator) {
        int count = mappings.size();
        if (count > 0) {
            int i2 = 0;
            while (i2 < count) {
                if (i2 > 0) {
                    target.append(separator);
                }
                target.append('?').append(Integer.toString(i2 + 1));
                ++i2;
            }
        }
    }

    public static void buildColsAndValuesBindingsFromMappings(StringBuilder target, Collection<DatabaseMapping> mappings, Collection<DatabaseField> keys, int valueIndex, String binder, String separator) {
        int idx = valueIndex;
        Iterator<DatabaseMapping> i2 = mappings.iterator();
        while (i2.hasNext()) {
            DatabaseMapping mapping = i2.next();
            DatabaseField field = mapping.getField();
            if (keys.contains(field)) continue;
            target.append(field.getName()).append(binder).append(Integer.toString(++idx));
            if (!i2.hasNext()) continue;
            target.append(separator);
        }
    }
}

