/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.FieldPartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.RangePartition;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;

public class RangePartitioningPolicy
extends FieldPartitioningPolicy {
    protected List<RangePartition> partitions = new ArrayList<RangePartition>();

    public RangePartitioningPolicy() {
    }

    public RangePartitioningPolicy(String partitionField) {
        super(partitionField);
    }

    public RangePartitioningPolicy(String partitionField, boolean unionUnpartitionableQueries) {
        super(partitionField, unionUnpartitionableQueries);
    }

    public RangePartitioningPolicy(String partitionField, RangePartition ... partitions) {
        this(partitionField);
        RangePartition[] rangePartitionArray = partitions;
        int n2 = partitions.length;
        int n3 = 0;
        while (n3 < n2) {
            RangePartition partition = rangePartitionArray[n3];
            this.addPartition(partition);
            ++n3;
        }
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (RangePartition rangePartition : this.partitions) {
            rangePartition.convertClassNamesToClasses(classLoader);
        }
    }

    public List<RangePartition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<RangePartition> partitions) {
        this.partitions = partitions;
    }

    public void addPartition(String connectionPool, Comparable startValue, Comparable endValue) {
        this.getPartitions().add(new RangePartition(connectionPool, startValue, endValue));
    }

    public void addPartition(RangePartition partition) {
        this.getPartitions().add(partition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Accessor> getConnectionsForQuery(AbstractSession session, DatabaseQuery query, AbstractRecord arguments) {
        Object value = arguments.get(this.partitionField);
        ArrayList<Accessor> accessors = null;
        if (value == null) {
            if (!this.unionUnpartitionableQueries) return null;
            accessors = new ArrayList(this.partitions.size());
        } else {
            accessors = new ArrayList<Accessor>(1);
        }
        int size = this.partitions.size();
        int index = 0;
        while (index < size) {
            RangePartition partition = this.partitions.get(index);
            if (value == null || partition.isInRange(value)) {
                if (session.getPlatform().hasPartitioningCallback()) {
                    session.getPlatform().getPartitioningCallback().setPartitionId(index);
                    return null;
                }
                accessors.add(this.getAccessor(partition.getConnectionPool(), session, query, false));
                if (value != null) break;
            }
            ++index;
        }
        if (!accessors.isEmpty()) return accessors;
        return null;
    }

    @Override
    public void partitionPersist(AbstractSession session, Object object, ClassDescriptor descriptor) {
        Object value = this.extractPartitionValueForPersist(session, object, descriptor);
        if (value == null) {
            return;
        }
        int size = this.partitions.size();
        int index = 0;
        while (index < size) {
            RangePartition partition = this.partitions.get(index);
            if (partition.isInRange(value)) {
                if (session.getPlatform().hasPartitioningCallback()) {
                    session.getPlatform().getPartitioningCallback().setPartitionId(index);
                } else {
                    this.getAccessor(partition.getConnectionPool(), session, null, false);
                }
                return;
            }
            ++index;
        }
    }
}

