/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;

public class SftpStreamProxy
implements Proxy {
    public static final String BASH_TCP_COMMAND = "/bin/bash -c 'exec 3<>/dev/tcp/%s/%d; cat <&3 & cat >&3; kill $!";
    public static final String NETCAT_COMMAND = "nc -q 0 %s %d";
    private ChannelExec channel;
    private final String commandFormat;
    private final String proxyHost;
    private final FileSystemOptions proxyOptions;
    private final String proxyPassword;
    private final int proxyPort;
    private final String proxyUser;
    private Session session;

    public SftpStreamProxy(String commandFormat, String proxyUser, String proxyHost, int proxyPort, String proxyPassword, FileSystemOptions proxyOptions) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.commandFormat = commandFormat;
        this.proxyOptions = proxyOptions;
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    @Override
    public void connect(SocketFactory socketFactory, String targetHost, int targetPort, int timeout) throws Exception {
        this.session = SftpClientFactory.createConnection(this.proxyHost, this.proxyPort, this.proxyUser.toCharArray(), this.proxyPassword.toCharArray(), this.proxyOptions);
        this.channel = (ChannelExec)this.session.openChannel("exec");
        this.channel.setCommand(String.format(this.commandFormat, targetHost, targetPort));
        this.channel.connect(timeout);
    }

    @Override
    public InputStream getInputStream() {
        try {
            return this.channel.getInputStream();
        }
        catch (IOException e2) {
            throw new IllegalStateException("IOException getting the SSH proxy input stream", e2);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return this.channel.getOutputStream();
        }
        catch (IOException e2) {
            throw new IllegalStateException("IOException getting the SSH proxy output stream", e2);
        }
    }

    @Override
    public Socket getSocket() {
        return null;
    }
}

