/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.UriParser;

public class LocalFileName
extends AbstractFileName {
    private final String rootFile;

    protected LocalFileName(String scheme, String rootFile, String path, FileType type) {
        super(scheme, path, type);
        this.rootFile = rootFile;
    }

    @Override
    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
        buffer.append(this.rootFile);
    }

    @Override
    public FileName createName(String path, FileType type) {
        return new LocalFileName(this.getScheme(), this.rootFile, path, type);
    }

    public String getRootFile() {
        return this.rootFile;
    }

    @Override
    public String toString() {
        try {
            return UriParser.decode(super.getURI());
        }
        catch (FileSystemException e2) {
            return super.getURI();
        }
    }
}

