/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.local.LocalFileRandomAccessContent;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class LocalFile
extends AbstractFileObject<LocalFileSystem> {
    private final String rootFile;
    private File file;

    protected LocalFile(LocalFileSystem fileSystem, String rootFile, AbstractFileName name) {
        super(name, fileSystem);
        this.rootFile = rootFile;
    }

    @Override
    protected void doAttach() throws Exception {
        if (this.file == null) {
            String fileName = this.rootFile + this.getName().getPathDecoded();
            this.file = new File(fileName);
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        if (!this.file.mkdirs()) {
            throw new FileSystemException("vfs.provider.local/create-folder.error", (Object)this.file);
        }
    }

    @Override
    protected void doDelete() throws Exception {
        if (!this.file.delete()) {
            throw new FileSystemException("vfs.provider.local/delete-file.error", (Object)this.file);
        }
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        return new FileInputStream(this.file);
    }

    @Override
    protected long doGetLastModifiedTime() throws FileSystemException {
        try {
            return Files.getLastModifiedTime(this.file.toPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException e2) {
            throw new FileSystemException(this.file.toString(), e2);
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return Files.newOutputStream(this.file.toPath(), bAppend ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new LocalFileRandomAccessContent(this.file, mode);
    }

    @Override
    protected FileType doGetType() {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected boolean doIsExecutable() {
        return this.file.canExecute();
    }

    @Override
    protected boolean doIsHidden() {
        return this.file.isHidden();
    }

    @Override
    protected boolean doIsReadable() throws FileSystemException {
        return this.file.canRead();
    }

    @Override
    protected boolean doIsSameFile(FileObject destFile) throws FileSystemException {
        if (!FileObjectUtils.isInstanceOf(destFile, LocalFile.class)) {
            return false;
        }
        LocalFile destLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject(destFile);
        if (!this.exists() || !destLocalFile.exists()) {
            return false;
        }
        try {
            return this.file.getCanonicalPath().equals(destLocalFile.file.getCanonicalPath());
        }
        catch (IOException e2) {
            throw new FileSystemException(e2);
        }
    }

    @Override
    protected boolean doIsSymbolicLink() throws FileSystemException {
        return Files.isSymbolicLink(this.file.toPath());
    }

    @Override
    protected boolean doIsWriteable() throws FileSystemException {
        return this.file.canWrite();
    }

    @Override
    protected String[] doListChildren() throws Exception {
        return UriParser.encode(this.file.list());
    }

    @Override
    protected void doRename(FileObject newFile) throws Exception {
        LocalFile newLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject(newFile);
        if (!this.file.renameTo(newLocalFile.getLocalFile())) {
            throw new FileSystemException("vfs.provider.local/rename-file.error", this.file.toString(), newFile.toString());
        }
    }

    @Override
    protected boolean doSetExecutable(boolean executable, boolean ownerOnly) throws Exception {
        return this.file.setExecutable(executable, ownerOnly);
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws FileSystemException {
        return this.file.setLastModified(modtime);
    }

    @Override
    protected boolean doSetReadable(boolean readable, boolean ownerOnly) throws Exception {
        return this.file.setReadable(readable, ownerOnly);
    }

    @Override
    protected boolean doSetWritable(boolean writable, boolean ownerOnly) throws Exception {
        return this.file.setWritable(writable, ownerOnly);
    }

    protected File getLocalFile() {
        return this.file;
    }

    @Override
    public String toString() {
        try {
            return UriParser.decode(this.getName().getURI());
        }
        catch (FileSystemException e2) {
            return this.getName().getURI();
        }
    }
}

