/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.local.LocalFileName;
import org.apache.commons.vfs2.provider.local.LocalFileNameParser;

public class GenericFileNameParser
extends LocalFileNameParser {
    private static final GenericFileNameParser INSTANCE = new GenericFileNameParser();

    public static GenericFileNameParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected FileName createFileName(String scheme, String rootFile, String path, FileType type) {
        return new LocalFileName(scheme, "", path, type);
    }

    @Override
    protected String extractRootPrefix(String uri, StringBuilder name) throws FileSystemException {
        if (StringUtils.isEmpty(name) || name.charAt(0) != '/') {
            throw new FileSystemException("vfs.provider.local/not-absolute-file-name.error", (Object)uri);
        }
        return "/";
    }
}

