/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.filter.IOCase;

public class NameFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IOCase caseSensitivity;
    private final List<String> names;

    public NameFileFilter(List<String> names) {
        this((IOCase)null, names);
    }

    public NameFileFilter(IOCase caseSensitivity, List<String> names) {
        if (names == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = new ArrayList<String>(names);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public NameFileFilter(String ... names) {
        this((IOCase)null, names);
    }

    public NameFileFilter(IOCase caseSensitivity, String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = new ArrayList<String>(Arrays.asList(names));
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public boolean accept(FileSelectInfo fileSelectInfo) {
        String name = fileSelectInfo.getFile().getName().getBaseName();
        for (String name2 : this.names) {
            if (!this.caseSensitivity.checkEquals(name, name2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.names != null) {
            for (int i2 = 0; i2 < this.names.size(); ++i2) {
                if (i2 > 0) {
                    buffer.append(",");
                }
                buffer.append(this.names.get(i2));
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

