/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.util;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;

public class SystemInfo {
    private static final GraphicsEnvironment graphicsEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private static final GraphicsDevice graphicsDev;
    private static final boolean headless;
    private static final boolean uniformTranslucencySupported;
    private static final boolean perPixelTranslucencySupported;
    private static final boolean shapedWindowSupported;

    public static boolean isHeadless() {
        return headless;
    }

    public static boolean isUniformTranslucencySupported() {
        return uniformTranslucencySupported;
    }

    public static boolean isPerPixelTranslucencySupported() {
        return perPixelTranslucencySupported;
    }

    public static boolean isShapedWindowSupported() {
        return shapedWindowSupported;
    }

    static {
        if (graphicsEnv != null) {
            graphicsDev = graphicsEnv.getDefaultScreenDevice();
            headless = GraphicsEnvironment.isHeadless();
        } else {
            graphicsDev = null;
            headless = false;
        }
        if (graphicsDev != null) {
            uniformTranslucencySupported = graphicsDev.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
            perPixelTranslucencySupported = graphicsDev.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT);
            shapedWindowSupported = graphicsDev.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT);
        } else {
            uniformTranslucencySupported = false;
            perPixelTranslucencySupported = false;
            shapedWindowSupported = false;
        }
    }
}

