/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class PropFile {
    private final String pathname;
    private InputStream is;
    private OutputStream os;
    private boolean autoSave;
    private final Properties props;
    private File file;

    public PropFile(String pathname, Properties defaults) throws IOException, NullPointerException, SecurityException {
        Path path = Paths.get(pathname, new String[0]);
        this.autoSave = true;
        this.pathname = path.toString();
        this.props = defaults == null ? new Properties() : defaults;
        this.file = new File(this.pathname);
        if (this.file.exists() && !Files.isRegularFile(path, new LinkOption[0])) {
            this.file = null;
            throw new FileNotFoundException("property file '" + this.pathname + "' not " + "found in the classpath, file exists but is a directory rather than a regular file, does" + " not exist but cannot be created, or cannot be opened for any other reason");
        }
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        this.privLoadProps();
    }

    private void privLoadProps() throws FileNotFoundException, IOException {
        block6: {
            if (this.file != null) {
                try {
                    this.is = new FileInputStream(this.file);
                    if (this.is != null) {
                        this.props.load(this.is);
                        break block6;
                    }
                    throw new FileNotFoundException("property file '" + this.pathname + "' not found in the classpath");
                }
                finally {
                    if (this.is != null) {
                        this.is.close();
                    }
                }
            }
        }
    }

    public void loadProps() throws IOException {
        this.privLoadProps();
    }

    public String getFilename() {
        return this.pathname;
    }

    public boolean isActive() {
        return this.file != null;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public String readValue(String key) {
        return this.props.getProperty(key);
    }

    public Integer readInt(String key) {
        try {
            String str = this.readValue(key);
            if (str == null) {
                return null;
            }
            return new Integer(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public Object setProperty(String key, String value, String comments) throws IOException {
        Object res = this.props.setProperty(key, value);
        if (this.autoSave) {
            this.store(comments);
        }
        return res;
    }

    public void store(String comments) throws IOException {
        try {
            if (this.file == null) {
                throw new FileNotFoundException("property file '" + this.pathname + "' not found in the classpath");
            }
            this.os = new FileOutputStream(this.file);
            if (this.os == null) {
                throw new FileNotFoundException("property file '" + this.pathname + "' not found in the classpath");
            }
            this.props.store(this.os, comments);
        }
        finally {
            if (this.os != null) {
                this.os.close();
            }
        }
    }
}

