/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTools {
    private static final Logger logger = Logger.getLogger(FileTools.class.getName());
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();

    public static List<String> readFile(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        return lines;
    }

    public static String getAppropiateUoM(long bytes, int digits) {
        float value;
        DIGITAL_UOM unit = DIGITAL_UOM.UOM_BYTE;
        NUMBER_FORMAT.setMaximumFractionDigits(digits);
        for (value = (float)bytes; value >= 1024.0f; value /= 1024.0f) {
            if (DIGITAL_UOM.UOM_BYTE.equals((Object)unit)) {
                unit = DIGITAL_UOM.UOM_KB;
                continue;
            }
            if (DIGITAL_UOM.UOM_KB.equals((Object)unit)) {
                unit = DIGITAL_UOM.UOM_MB;
                continue;
            }
            if (DIGITAL_UOM.UOM_MB.equals((Object)unit)) {
                unit = DIGITAL_UOM.UOM_GB;
                continue;
            }
            unit = DIGITAL_UOM.UOM_TB;
            break;
        }
        return NUMBER_FORMAT.format(value) + " " + unit.getUoMName();
    }

    public static File createTempDirectory(File parentDir, String name) {
        File tempDir = new File(parentDir, name);
        if (tempDir.exists()) {
            int i2 = 1;
            while ((tempDir = new File(parentDir, name + i2)).exists()) {
                ++i2;
            }
        }
        if (!tempDir.mkdirs()) {
            logger.log(Level.WARNING, "can not create {0}", tempDir);
        }
        return tempDir;
    }

    public static boolean recursiveDelete(File file, boolean removeFile) throws IOException {
        File[] subFiles;
        if (file.isDirectory() && !FileTools.isSymlink(file) && (subFiles = file.listFiles()) != null) {
            for (File subFile : subFiles) {
                FileTools.recursiveDelete(subFile, true);
            }
        }
        return removeFile ? file.delete() : true;
    }

    public static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    public static String getCanonicalFile(File file) throws IOException {
        File canon;
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        if (!canon.getCanonicalFile().equals(canon.getAbsoluteFile())) {
            return canon.getCanonicalFile().getAbsolutePath();
        }
        return "";
    }

    public static enum DIGITAL_UOM {
        UOM_BYTE{

            @Override
            public long getUoMVal() {
                return 1L;
            }

            @Override
            public String getUoMName() {
                return "byte";
            }
        }
        ,
        UOM_KB{

            @Override
            public long getUoMVal() {
                return 1024L;
            }

            @Override
            public String getUoMName() {
                return "KiB";
            }
        }
        ,
        UOM_MB{

            @Override
            public long getUoMVal() {
                return 0x100000L;
            }

            @Override
            public String getUoMName() {
                return "MiB";
            }
        }
        ,
        UOM_GB{

            @Override
            public long getUoMVal() {
                return 0x40000000L;
            }

            @Override
            public String getUoMName() {
                return "GiB";
            }
        }
        ,
        UOM_TB{

            @Override
            public long getUoMVal() {
                return 0x10000000000L;
            }

            @Override
            public String getUoMName() {
                return "TiB";
            }
        };


        public abstract long getUoMVal();

        public abstract String getUoMName();
    }
}

