/*
 * Decompiled with CFR 0.152.
 */
package com.ucod.swingplus;

import com.ucod.swingplus.CollapChildPanel;
import com.ucod.swingplus.CollapHeaderPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class CollapsiblePanel
extends JPanel {
    boolean movingComponents = false;
    int selectedIndex;
    int childCount;
    private MouseListener ml = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e2) {
            int index = ((CollapHeaderPanel)e2.getSource()).id - 1;
            if (!CollapsiblePanel.this.movingComponents) {
                CollapsiblePanel.this.setSelectedChild(index);
            }
        }
    };

    public CollapsiblePanel() {
        this.setLayout(null);
        this.childCount = 0;
        this.selectedIndex = 0;
    }

    private void setZOrder() {
        Component[] c2 = this.getComponents();
        for (int j2 = 0; j2 < c2.length - 1; ++j2) {
            this.setComponentZOrder(c2[j2], c2.length - 1 - j2);
        }
    }

    private void setSelectedChild(int indexToOpen) {
        int[] indices = new int[]{};
        int travelLimit = 0;
        if (this.selectedIndex < indexToOpen) {
            travelLimit = 45 - this.getComponent(this.selectedIndex).getHeight();
            int n2 = indexToOpen - this.selectedIndex;
            indices = new int[n2];
            int j2 = this.selectedIndex;
            int k2 = 0;
            while (j2 < indexToOpen) {
                indices[k2] = j2 + 1;
                ++j2;
                ++k2;
            }
        } else if (this.selectedIndex > indexToOpen) {
            travelLimit = this.getComponent(this.selectedIndex).getHeight() - 45;
            int n3 = this.selectedIndex - indexToOpen;
            indices = new int[n3];
            int j3 = indexToOpen;
            int k3 = 0;
            while (j3 < this.selectedIndex) {
                indices[k3] = j3 + 1;
                ++j3;
                ++k3;
            }
        }
        this.movePanels(indices, travelLimit);
        this.selectedIndex = indexToOpen;
    }

    private void movePanels(final int[] indices, final int travel) {
        this.movingComponents = true;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int dy;
                Component[] c2 = CollapsiblePanel.this.getComponents();
                int limit = travel > 0 ? travel : 0;
                int n2 = dy = travel > 0 ? 8 : -8;
                for (int count = travel > 0 ? 0 : travel; count < limit; count += 8) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException e2) {
                        System.out.println("interrupted");
                        break;
                    }
                    for (int j2 = 0; j2 < indices.length; ++j2) {
                        int index = c2.length - 1 - indices[j2];
                        Point p2 = c2[index].getLocation();
                        p2.y += dy;
                        c2[index].setLocation(p2.x, p2.y);
                        System.out.println("x=" + p2.x + "y=" + p2.y);
                    }
                    CollapsiblePanel.this.repaint();
                }
                CollapsiblePanel.this.movingComponents = false;
            }
        });
        thread.setPriority(5);
        thread.start();
    }

    public int addPanel(JPanel panel) {
        Dimension d2 = new Dimension();
        int id = this.childCount++;
        int h2 = 0;
        CollapChildPanel child = new CollapChildPanel(id, this.ml, panel);
        this.add(child);
        for (int j2 = 0; j2 < this.childCount; ++j2) {
            d2 = child.getPreferredSize();
            child.setBounds(0, h2, d2.width, d2.height);
            if (j2 >= this.childCount - 1) continue;
            h2 += 45;
        }
        this.setPreferredSize(new Dimension(d2.width, h2 += d2.height));
        this.setZOrder();
        if (id == 0) {
            this.setSelectedChild(0);
        }
        return id;
    }
}

